/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.tools;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;

@NonNullByDefault
public class WaitForTopicValue {
    private CompletableFuture<String> future = new CompletableFuture();
    private final CompletableFuture<Boolean> subscripeFuture;

    public WaitForTopicValue(MqttBrokerConnection connection, String topic) throws InterruptedException, ExecutionException {
        MqttMessageSubscriber mqttMessageSubscriber = (t, payload) -> this.future.complete(new String(payload));
        this.future = this.future.whenComplete((r, e) -> connection.unsubscribe(topic, mqttMessageSubscriber));
        this.subscripeFuture = connection.subscribe(topic, mqttMessageSubscriber);
    }

    public void stop() {
        this.future.completeExceptionally(new Exception("Stopped"));
    }

    public @Nullable String waitForTopicValue(int timeoutInMS) {
        try {
            return (String)((CompletableFuture)this.subscripeFuture.thenCompose(b -> this.future)).get(timeoutInMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return null;
        }
    }

    private void timeout() {
        if (!this.future.isDone()) {
            this.future.completeExceptionally(new TimeoutException());
        }
    }

    public CompletableFuture<String> waitForTopicValueAsync(ScheduledExecutorService scheduler, int timeoutInMS) {
        scheduler.schedule(this::timeout, (long)timeoutInMS, TimeUnit.MILLISECONDS);
        return this.subscripeFuture.thenCompose(b -> this.future);
    }
}

