/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.Collections;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class ColorValue
implements Value {
    private State state = UnDefType.UNDEF;
    private HSBType colorValue;
    private final boolean isRGB;
    private final String onValue;
    private final String offValue;

    public ColorValue(boolean isRGB, @Nullable String onValue, @Nullable String offValue) {
        this.isRGB = isRGB;
        this.colorValue = new HSBType();
        this.onValue = onValue == null ? "ON" : onValue;
        this.offValue = offValue == null ? "OFF" : offValue;
    }

    public ColorValue(boolean isRGB, String colorTextValue, @Nullable String onValue, @Nullable String offValue) {
        this.isRGB = isRGB;
        this.colorValue = new HSBType(colorTextValue);
        this.onValue = onValue == null ? "ON" : onValue;
        this.offValue = offValue == null ? "OFF" : offValue;
    }

    @Override
    public State getValue() {
        return this.state;
    }

    @Override
    public String update(Command command) throws IllegalArgumentException {
        if (command instanceof OnOffType) {
            OnOffType boolValue = (OnOffType)command;
            PercentType minOn = new PercentType(Math.max(this.colorValue.getBrightness().intValue(), 10));
            this.colorValue = new HSBType(this.colorValue.getHue(), this.colorValue.getSaturation(), boolValue == OnOffType.ON ? minOn : new PercentType(0));
        } else if (command instanceof OpenClosedType) {
            OnOffType boolValue = (OpenClosedType)command == OpenClosedType.OPEN ? OnOffType.ON : OnOffType.OFF;
            PercentType minOn = new PercentType(Math.max(this.colorValue.getBrightness().intValue(), 10));
            this.colorValue = new HSBType(this.colorValue.getHue(), this.colorValue.getSaturation(), boolValue == OnOffType.ON ? minOn : new PercentType(0));
        } else if (command instanceof HSBType) {
            this.colorValue = (HSBType)command;
        } else if (command instanceof StringType) {
            if (this.isRGB) {
                String[] split = command.toString().split(",");
                if (split.length != 3) {
                    throw new IllegalArgumentException(String.valueOf(command.toString()) + " is not a valid RGB syntax");
                }
                this.colorValue = HSBType.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]));
            } else {
                this.colorValue = new HSBType(command.toString());
            }
        } else {
            throw new IllegalArgumentException("Didn't recognise the color value " + command.toString());
        }
        this.state = this.colorValue;
        if (this.isRGB) {
            return this.colorValue.getRed() + "," + this.colorValue.getGreen() + "," + this.colorValue.getBlue();
        }
        return this.colorValue.toString();
    }

    @Override
    public State update(String updatedValue) throws IllegalArgumentException {
        if (this.onValue.equals(updatedValue)) {
            PercentType minOn = new PercentType(Math.max(this.colorValue.getBrightness().intValue(), 10));
            this.colorValue = new HSBType(this.colorValue.getHue(), this.colorValue.getSaturation(), minOn);
        } else if (this.offValue.equals(updatedValue)) {
            this.colorValue = new HSBType(this.colorValue.getHue(), this.colorValue.getSaturation(), new PercentType(0));
        } else if (updatedValue.indexOf(44) > 0) {
            if (this.isRGB) {
                String[] split = updatedValue.toString().split(",");
                if (split.length != 3) {
                    throw new IllegalArgumentException(String.valueOf(updatedValue) + " is not a valid RGB syntax");
                }
                this.colorValue = HSBType.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]));
            } else {
                this.colorValue = new HSBType(updatedValue);
            }
        } else {
            this.colorValue = new HSBType(this.colorValue.getHue(), this.colorValue.getSaturation(), new PercentType(updatedValue));
        }
        this.state = this.colorValue;
        return this.colorValue;
    }

    @Override
    public String getItemType() {
        return "Color";
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }

    @Override
    public void resetState() {
        this.state = UnDefType.UNDEF;
    }
}

