/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.Collections;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class OnOffValue
implements Value {
    private State state = UnDefType.UNDEF;
    private OnOffType onOffValue;
    private final String onString;
    private final String offString;

    public OnOffValue() {
        this.onString = OnOffType.ON.name();
        this.offString = OnOffType.OFF.name();
        this.onOffValue = OnOffType.OFF;
    }

    public OnOffValue(@Nullable String onValue, @Nullable String offValue) {
        this.onString = onValue == null ? OnOffType.ON.name() : onValue;
        this.offString = offValue == null ? OnOffType.OFF.name() : offValue;
        this.onOffValue = OnOffType.OFF;
    }

    @Override
    public State getValue() {
        return this.state;
    }

    @Override
    public String update(Command command) throws IllegalArgumentException {
        if (command instanceof OnOffType) {
            this.onOffValue = (OnOffType)command;
        } else if (command instanceof StringType) {
            this.onOffValue = (OnOffType)this.update(command.toString());
        } else {
            throw new IllegalArgumentException("Type " + command.getClass().getName() + " not supported for OnOffValue");
        }
        this.state = this.onOffValue;
        return this.onOffValue == OnOffType.ON ? this.onString : this.offString;
    }

    @Override
    public State update(String updatedValue) throws IllegalArgumentException {
        String upperCase = updatedValue.toUpperCase();
        if (this.onString.equals(updatedValue) || OnOffType.ON.name().equals(upperCase)) {
            this.onOffValue = OnOffType.ON;
        } else if (this.offString.equals(updatedValue) || OnOffType.OFF.name().equals(upperCase)) {
            this.onOffValue = OnOffType.OFF;
        } else {
            throw new IllegalArgumentException("Didn't recognise the on/off value " + updatedValue);
        }
        this.state = this.onOffValue;
        return this.onOffValue;
    }

    @Override
    public String getItemType() {
        return "Switch";
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }

    @Override
    public void resetState() {
        this.state = UnDefType.UNDEF;
    }
}

