/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.BeaconBluetoothHandler;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompletionStatus;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothService;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothConnectionStatusNotification;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.DefaultSystemChannelTypeProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.ARRAY_CONTENTS, DefaultLocation.TYPE_ARGUMENT, DefaultLocation.TYPE_BOUND, DefaultLocation.TYPE_PARAMETER})
public class ConnectedBluetoothHandler
extends BeaconBluetoothHandler {
    private final Logger logger = LoggerFactory.getLogger(ConnectedBluetoothHandler.class);
    private ScheduledFuture<?> connectionJob;
    protected volatile Boolean resolved = false;
    protected final Set<BluetoothCharacteristic> deviceCharacteristics = new CopyOnWriteArraySet<BluetoothCharacteristic>();

    public ConnectedBluetoothHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.connectionJob = this.scheduler.scheduleWithFixedDelay(() -> {
            if (this.device.getConnectionState() != BluetoothDevice.ConnectionState.CONNECTED) {
                this.device.connect();
            }
            this.updateRSSI();
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void dispose() {
        if (this.connectionJob != null) {
            this.connectionJob.cancel(true);
            this.connectionJob = null;
        }
        this.scheduler.submit(() -> {
            try {
                this.deviceLock.lock();
                if (this.device != null) {
                    this.device.removeListener(this);
                    this.device.disconnect();
                    this.device = null;
                }
            }
            finally {
                this.deviceLock.unlock();
            }
        });
    }

    @Override
    public void handleCommand(ChannelUID channelUID, Command command) {
        super.handleCommand(channelUID, command);
        if (command == RefreshType.REFRESH) {
            for (BluetoothCharacteristic characteristic : this.deviceCharacteristics) {
                if (characteristic.getGattCharacteristic() == null || !channelUID.getId().equals(characteristic.getGattCharacteristic().name())) continue;
                this.device.readCharacteristic(characteristic);
                break;
            }
        }
    }

    public void channelLinked(ChannelUID channelUID) {
        super.channelLinked(channelUID);
    }

    @Override
    protected void updateStatusBasedOnRssi(boolean receivedSignal) {
        if (receivedSignal) {
            if (this.device.getConnectionState() == BluetoothDevice.ConnectionState.CONNECTED) {
                this.updateStatus(ThingStatus.ONLINE);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "Device is not connected.");
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
        }
    }

    @Override
    public void onConnectionStateChange(BluetoothConnectionStatusNotification connectionNotification) {
        switch (connectionNotification.getConnectionState()) {
            case DISCOVERED: {
                this.scheduler.submit(() -> {
                    ScheduledFuture<?> scheduledFuture = this.connectionJob;
                    synchronized (scheduledFuture) {
                        if (this.device.getConnectionState() != BluetoothDevice.ConnectionState.CONNECTED && !this.device.connect()) {
                            this.logger.debug("Error connecting to device after discovery.");
                        }
                    }
                });
                break;
            }
            case CONNECTED: {
                this.updateStatus(ThingStatus.ONLINE);
                this.scheduler.submit(() -> {
                    Boolean bl = this.resolved;
                    synchronized (bl) {
                        if (!this.resolved.booleanValue() && !this.device.discoverServices()) {
                            this.logger.debug("Error while discovering services");
                        }
                    }
                });
                break;
            }
            case DISCONNECTED: {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                break;
            }
        }
    }

    @Override
    public void onServicesDiscovered() {
        if (!this.resolved.booleanValue()) {
            this.resolved = true;
            this.logger.debug("Service discovery completed for '{}'", (Object)this.address);
            for (BluetoothService service : this.device.getServices()) {
                for (BluetoothCharacteristic characteristic : service.getCharacteristics()) {
                    if (characteristic.getGattCharacteristic() == null) continue;
                    if (characteristic.getGattCharacteristic().equals((Object)BluetoothCharacteristic.GattCharacteristic.BATTERY_LEVEL)) {
                        this.activateChannel(characteristic, DefaultSystemChannelTypeProvider.SYSTEM_CHANNEL_BATTERY_LEVEL.getUID());
                        continue;
                    }
                    this.logger.debug("Added GATT characteristic '{}'", (Object)characteristic.getGattCharacteristic().name());
                }
            }
        }
    }

    @Override
    public void onCharacteristicReadComplete(BluetoothCharacteristic characteristic, BluetoothCompletionStatus status) {
        if (status == BluetoothCompletionStatus.SUCCESS) {
            if (BluetoothCharacteristic.GattCharacteristic.BATTERY_LEVEL.equals((Object)characteristic.getGattCharacteristic())) {
                this.updateBatteryLevel(characteristic);
            } else {
                this.logger.debug("Characteristic {} from {} has been read - value {}", new Object[]{characteristic.getUuid(), this.address, characteristic.getValue()});
            }
        } else {
            this.logger.debug("Characteristic {} from {} has been read - ERROR", (Object)characteristic.getUuid(), (Object)this.address);
            return;
        }
    }

    @Override
    public void onCharacteristicWriteComplete(BluetoothCharacteristic characteristic, BluetoothCompletionStatus status) {
        this.logger.debug("Wrote {} to characteristic {} of device {}: {}", new Object[]{characteristic.getByteValue(), characteristic.getUuid(), this.address, status});
    }

    @Override
    public void onCharacteristicUpdate(BluetoothCharacteristic characteristic) {
        if (BluetoothCharacteristic.GattCharacteristic.BATTERY_LEVEL.equals((Object)characteristic.getGattCharacteristic())) {
            this.updateBatteryLevel(characteristic);
        }
    }

    protected void updateBatteryLevel(BluetoothCharacteristic characteristic) {
        Double level = (double)characteristic.getValue()[0] / 2.55;
        this.updateState(characteristic.getGattCharacteristic().name(), (State)new DecimalType((long)level.intValue()));
    }

    protected void activateChannel(@Nullable BluetoothCharacteristic characteristic, ChannelTypeUID channelTypeUID, @Nullable String name) {
        if (characteristic != null) {
            String channelId;
            String string = channelId = name != null ? name : characteristic.getGattCharacteristic().name();
            if (channelId == null) {
                channelId = channelTypeUID.getId();
            }
            if (this.getThing().getChannel(channelId) == null) {
                ThingBuilder updatedThing = this.editThing();
                Channel channel = ChannelBuilder.create((ChannelUID)new ChannelUID(this.getThing().getUID(), channelId), (String)"Number").withType(channelTypeUID).build();
                updatedThing.withChannel(channel);
                this.updateThing(updatedThing.build());
                this.logger.debug("Added channel '{}' to Thing '{}'", (Object)channelId, (Object)this.getThing().getUID());
            }
            this.deviceCharacteristics.add(characteristic);
            this.device.enableNotifications(characteristic);
            if (this.isLinked(channelId)) {
                this.device.readCharacteristic(characteristic);
            }
        } else {
            this.logger.debug("Characteristic is null - not activating any channel.");
        }
    }

    protected void activateChannel(@Nullable BluetoothCharacteristic characteristic, ChannelTypeUID channelTypeUID) {
        this.activateChannel(characteristic, channelTypeUID, null);
    }
}

