/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap.internal;

import com.google.common.collect.MapMaker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTOMapper;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.io.rest.sitemap.internal.MappingDTO;
import org.eclipse.smarthome.io.rest.sitemap.internal.PageDTO;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapDTO;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEventOutput;
import org.eclipse.smarthome.io.rest.sitemap.internal.WidgetDTO;
import org.eclipse.smarthome.model.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.ColorArray;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.List;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Mapview;
import org.eclipse.smarthome.model.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Webview;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.BroadcasterListener;
import org.glassfish.jersey.server.ChunkedOutput;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sitemaps")
@RolesAllowed(value={"user", "administrator"})
@Api(value="sitemaps")
@Component(service={RESTResource.class})
public class SitemapResource
implements RESTResource,
SitemapSubscriptionService.SitemapSubscriptionCallback,
BroadcasterListener<OutboundEvent> {
    private final Logger logger = LoggerFactory.getLogger(SitemapResource.class);
    public static final String PATH_SITEMAPS = "sitemaps";
    private static final String SEGMENT_EVENTS = "events";
    private static final String X_ACCEL_BUFFERING_HEADER = "X-Accel-Buffering";
    private static final long TIMEOUT_IN_MS = 30000L;
    private SseBroadcaster broadcaster;
    @Context
    UriInfo uriInfo;
    @Context
    HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    private ItemUIRegistry itemUIRegistry;
    private SitemapSubscriptionService subscriptions;
    private LocaleService localeService;
    private final java.util.List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, EventOutput> eventOutputs = new MapMaker().weakValues().makeMap();
    private ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private ScheduledFuture<?> cleanSubscriptionsJob;

    @Activate
    protected void activate() {
        this.broadcaster = new SseBroadcaster();
        this.broadcaster.add((BroadcasterListener)this);
        this.cleanSubscriptionsJob = this.scheduler.scheduleAtFixedRate(() -> {
            this.logger.debug("Run clean SSE subscriptions job");
            if (this.subscriptions != null) {
                this.subscriptions.checkAliveClients();
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    @Deactivate
    protected void deactivate() {
        if (this.cleanSubscriptionsJob != null && !this.cleanSubscriptionsJob.isCancelled()) {
            this.logger.debug("Cancel clean SSE subscriptions job");
            this.cleanSubscriptionsJob.cancel(true);
            this.cleanSubscriptionsJob = null;
        }
        this.broadcaster.remove((BroadcasterListener)this);
        this.broadcaster = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void unsetSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    public void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available sitemaps.", response=SitemapDTO.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getSitemaps() {
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        Collection<SitemapDTO> responseObject = this.getSitemapBeans(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]));
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get sitemap by name.", response=SitemapDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getSitemapData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="sitemapname") @ApiParam(value="sitemap name") String sitemapname, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}' for media type '{}'.", new Object[]{this.request.getRemoteAddr(), this.uriInfo.getPath(), type});
        SitemapDTO responseObject = this.getSitemapBean(sitemapname, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale);
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]*}/{pageid: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Polls the data for a sitemap.", response=PageDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Sitemap with requested name does not exist or page does not exist, or page refers to a non-linkable widget"), @ApiResponse(code=400, message="Invalid subscription id has been provided.")})
    public Response getPageData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="sitemapname") @ApiParam(value="sitemap name") String sitemapname, @PathParam(value="pageid") @ApiParam(value="page id") String pageId, @QueryParam(value="subscriptionid") @ApiParam(value="subscriptionid", required=false) String subscriptionId) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        if (subscriptionId != null) {
            try {
                this.subscriptions.setPageId(subscriptionId, sitemapname, pageId);
            }
            catch (IllegalArgumentException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        boolean timeout = false;
        if (headers.getRequestHeader("X-Atmosphere-Transport") != null) {
            timeout = this.blockUnlessChangeOccurs(sitemapname, pageId);
        }
        PageDTO responseObject = this.getPageBean(sitemapname, pageId, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale, timeout);
        return Response.ok((Object)responseObject).build();
    }

    @POST
    @Path(value="events/subscribe")
    @ApiOperation(value="Creates a sitemap event subscription.")
    @ApiResponses(value={@ApiResponse(code=201, message="Subscription created."), @ApiResponse(code=503, message="Subscriptions limit reached.")})
    public Object createEventSubscription() {
        String subscriptionId = this.subscriptions.createSubscription(this);
        if (subscriptionId == null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, null, (String)"Max number of subscriptions is reached.");
        }
        SitemapEventOutput eventOutput = new SitemapEventOutput(this.subscriptions, subscriptionId);
        this.broadcaster.add((ChunkedOutput)eventOutput);
        this.eventOutputs.put(subscriptionId, eventOutput);
        URI uri = this.uriInfo.getBaseUriBuilder().path(PATH_SITEMAPS).path(SEGMENT_EVENTS).path(subscriptionId).build(new Object[0]);
        this.logger.debug("Client from IP {} requested new subscription => got id {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        return Response.created((URI)uri);
    }

    @GET
    @Path(value="events/{subscriptionid: [a-zA-Z_0-9-]*}/")
    @Produces(value={"text/event-stream"})
    @ApiOperation(value="Get sitemap events.", response=EventOutput.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Page not linked to the subscription."), @ApiResponse(code=404, message="Subscription not found.")})
    public Object getSitemapEvents(@PathParam(value="subscriptionid") @ApiParam(value="subscription id") String subscriptionId, @QueryParam(value="sitemap") @ApiParam(value="sitemap name", required=false) String sitemapname, @QueryParam(value="pageid") @ApiParam(value="page id", required=false) String pageId) {
        EventOutput eventOutput = this.eventOutputs.get(subscriptionId);
        if (!this.subscriptions.exists(subscriptionId) || eventOutput == null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)("Subscription id " + subscriptionId + " does not exist."));
        }
        if (sitemapname != null && pageId != null) {
            this.subscriptions.setPageId(subscriptionId, sitemapname, pageId);
        }
        if (this.subscriptions.getSitemapName(subscriptionId) == null || this.subscriptions.getPageId(subscriptionId) == null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.BAD_REQUEST, null, (String)("Subscription id " + subscriptionId + " is not yet linked to a sitemap/page."));
        }
        this.logger.debug("Client from IP {} requested sitemap event stream for subscription {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        this.response.addHeader(X_ACCEL_BUFFERING_HEADER, "no");
        return eventOutput;
    }

    private PageDTO getPageBean(String sitemapName, String pageId, URI uri, Locale locale, boolean timeout) {
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                EList children = this.itemUIRegistry.getChildren(sitemap);
                return this.createPageBean(sitemapName, sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout);
            }
            Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
            if (pageWidget instanceof LinkableWidget) {
                EList children = this.itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                PageDTO pageBean = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(pageWidget), this.itemUIRegistry.getCategory(pageWidget), pageId, (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout);
                EObject parentPage = pageWidget.eContainer();
                while (parentPage instanceof Frame) {
                    parentPage = parentPage.eContainer();
                }
                if (parentPage instanceof Widget) {
                    String parentId = this.itemUIRegistry.getWidgetId((Widget)parentPage);
                    pageBean.parent = this.getPageBean(sitemapName, parentId, uri, locale, timeout);
                    pageBean.parent.widgets = null;
                    pageBean.parent.parent = null;
                } else if (parentPage instanceof Sitemap) {
                    pageBean.parent = this.getPageBean(sitemapName, sitemap.getName(), uri, locale, timeout);
                    pageBean.parent.widgets = null;
                }
                return pageBean;
            }
            if (this.logger.isDebugEnabled()) {
                if (pageWidget == null) {
                    this.logger.debug("Received HTTP GET request at '{}' for the unknown page id '{}'.", (Object)uri, (Object)pageId);
                } else {
                    this.logger.debug("Received HTTP GET request at '{}' for the page id '{}'. This id refers to a non-linkable widget and is therefore no valid page id.", (Object)uri, (Object)pageId);
                }
            }
            throw new WebApplicationException(404);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)uri, (Object)sitemapName);
        throw new WebApplicationException(404);
    }

    public Collection<SitemapDTO> getSitemapBeans(URI uri) {
        LinkedList<SitemapDTO> beans = new LinkedList<SitemapDTO>();
        HashSet<String> names = new HashSet<String>();
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)UriBuilder.fromUri((URI)uri).build(new Object[0]).toASCIIString());
        for (SitemapProvider provider : this.sitemapProviders) {
            for (String modelName : provider.getSitemapNames()) {
                Sitemap sitemap = provider.getSitemap(modelName);
                if (sitemap == null) continue;
                if (!names.contains(modelName)) {
                    names.add(modelName);
                    SitemapDTO bean = new SitemapDTO();
                    bean.name = modelName;
                    bean.icon = sitemap.getIcon();
                    bean.label = sitemap.getLabel();
                    bean.link = UriBuilder.fromUri((URI)uri).path(bean.name).build(new Object[0]).toASCIIString();
                    bean.homepage = new PageDTO();
                    bean.homepage.link = String.valueOf(bean.link) + "/" + sitemap.getName();
                    beans.add(bean);
                    continue;
                }
                this.logger.warn("Found duplicate sitemap name '{}' - ignoring it. Please check your configuration.", (Object)modelName);
            }
        }
        return beans;
    }

    public SitemapDTO getSitemapBean(String sitemapname, URI uri, Locale locale) {
        Sitemap sitemap = this.getSitemap(sitemapname);
        if (sitemap != null) {
            return this.createSitemapBean(sitemapname, sitemap, uri, locale);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)this.uriInfo.getPath(), (Object)sitemapname);
        throw new WebApplicationException(404);
    }

    private SitemapDTO createSitemapBean(String sitemapName, Sitemap sitemap, URI uri, Locale locale) {
        SitemapDTO bean = new SitemapDTO();
        bean.name = sitemapName;
        bean.icon = sitemap.getIcon();
        bean.label = sitemap.getLabel();
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(bean.name).build(new Object[0]).toASCIIString();
        bean.homepage = this.createPageBean(sitemap.getName(), sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)this.itemUIRegistry.getChildren(sitemap), true, false, uri, locale, false);
        return bean;
    }

    private PageDTO createPageBean(String sitemapName, String title, String icon, String pageId, EList<Widget> children, boolean drillDown, boolean isLeaf, URI uri, Locale locale, boolean timeout) {
        PageDTO bean = new PageDTO();
        bean.timeout = timeout;
        bean.id = pageId;
        bean.title = title;
        bean.icon = icon;
        bean.leaf = isLeaf;
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(sitemapName).path(pageId).build(new Object[0]).toASCIIString();
        if (children != null) {
            for (Widget widget : children) {
                String widgetId;
                WidgetDTO subWidget = this.createWidgetBean(sitemapName, widget, drillDown, uri, widgetId = this.itemUIRegistry.getWidgetId(widget), locale);
                if (subWidget == null) continue;
                bean.widgets.add(subWidget);
            }
        } else {
            bean.widgets = null;
        }
        return bean;
    }

    private WidgetDTO createWidgetBean(String sitemapName, Widget widget, boolean drillDown, URI uri, String widgetId, Locale locale) {
        MappingDTO mappingBean;
        if (!this.itemUIRegistry.getVisiblity(widget)) {
            return null;
        }
        WidgetDTO bean = new WidgetDTO();
        if (widget.getItem() != null) {
            try {
                Item item = this.itemUIRegistry.getItem(widget.getItem());
                String widgetTypeName = widget.eClass().getInstanceTypeName().substring(widget.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
                boolean isMapview = "mapview".equalsIgnoreCase(widgetTypeName);
                Predicate<Item> itemFilter = i -> i.getType().equals("Location");
                bean.item = EnrichedItemDTOMapper.map((Item)item, (boolean)isMapview, itemFilter, (URI)UriBuilder.fromUri((URI)uri).build(new Object[0]), (Locale)locale);
                bean.state = this.itemUIRegistry.getState(widget).toFullString();
                if (bean.state != null && bean.state.equals(bean.item.state)) {
                    bean.state = null;
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("{}", (Object)e.getMessage());
            }
        }
        bean.widgetId = widgetId;
        bean.icon = this.itemUIRegistry.getCategory(widget);
        bean.labelcolor = this.itemUIRegistry.getLabelColor(widget);
        bean.valuecolor = this.itemUIRegistry.getValueColor(widget);
        bean.label = this.itemUIRegistry.getLabel(widget);
        bean.type = widget.eClass().getName();
        if (widget instanceof LinkableWidget) {
            LinkableWidget linkableWidget = (LinkableWidget)widget;
            EList children = this.itemUIRegistry.getChildren(linkableWidget);
            if (widget instanceof Frame) {
                for (Widget child : children) {
                    String wID;
                    WidgetDTO subWidget = this.createWidgetBean(sitemapName, child, drillDown, uri, wID = this.itemUIRegistry.getWidgetId(child), locale);
                    if (subWidget == null) continue;
                    bean.widgets.add(subWidget);
                }
            } else if (children.size() > 0) {
                String pageName = this.itemUIRegistry.getWidgetId((Widget)linkableWidget);
                bean.linkedPage = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(widget), this.itemUIRegistry.getCategory(widget), pageName, (EList<Widget>)(drillDown ? children : null), drillDown, this.isLeaf((EList<Widget>)children), uri, locale, false);
            }
        }
        if (widget instanceof Switch) {
            Switch switchWidget = (Switch)widget;
            for (Mapping mapping : switchWidget.getMappings()) {
                mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.label = mapping.getLabel();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Selection) {
            Selection selectionWidget = (Selection)widget;
            for (Mapping mapping : selectionWidget.getMappings()) {
                mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.label = mapping.getLabel();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Slider) {
            Slider sliderWidget = (Slider)widget;
            bean.sendFrequency = sliderWidget.getFrequency();
            bean.switchSupport = sliderWidget.isSwitchEnabled();
        }
        if (widget instanceof List) {
            List listWidget = (List)widget;
            bean.separator = listWidget.getSeparator();
        }
        if (widget instanceof Image) {
            bean.url = this.buildProxyUrl(sitemapName, widget, uri);
            Image imageWidget = (Image)widget;
            if (imageWidget.getRefresh() > 0) {
                bean.refresh = imageWidget.getRefresh();
            }
        }
        if (widget instanceof Video) {
            Video videoWidget = (Video)widget;
            if (videoWidget.getEncoding() != null) {
                bean.encoding = videoWidget.getEncoding();
            }
            bean.url = videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls") ? videoWidget.getUrl() : this.buildProxyUrl(sitemapName, (Widget)videoWidget, uri);
        }
        if (widget instanceof Webview) {
            Webview webViewWidget = (Webview)widget;
            bean.url = webViewWidget.getUrl();
            bean.height = webViewWidget.getHeight();
        }
        if (widget instanceof Mapview) {
            Mapview mapViewWidget = (Mapview)widget;
            bean.height = mapViewWidget.getHeight();
        }
        if (widget instanceof Chart) {
            Chart chartWidget = (Chart)widget;
            bean.service = chartWidget.getService();
            bean.period = chartWidget.getPeriod();
            bean.legend = chartWidget.getLegend();
            if (chartWidget.getRefresh() > 0) {
                bean.refresh = chartWidget.getRefresh();
            }
        }
        if (widget instanceof Setpoint) {
            Setpoint setpointWidget = (Setpoint)widget;
            bean.minValue = setpointWidget.getMinValue();
            bean.maxValue = setpointWidget.getMaxValue();
            bean.step = setpointWidget.getStep();
        }
        return bean;
    }

    private String buildProxyUrl(String sitemapName, Widget widget, URI uri) {
        String wId = this.itemUIRegistry.getWidgetId(widget);
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() >= 0) {
            sb.append(":").append(uri.getPort());
        }
        sb.append("/proxy?sitemap=").append(sitemapName).append(".sitemap&widgetId=").append(wId);
        return sb.toString();
    }

    private boolean isLeaf(EList<Widget> children) {
        for (Widget w : children) {
            LinkableWidget linkableWidget;
            if (!(w instanceof Frame ? this.isLeaf((EList<Widget>)((Frame)w).getChildren()) : w instanceof LinkableWidget && this.itemUIRegistry.getChildren(linkableWidget = (LinkableWidget)w).size() > 0)) continue;
            return false;
        }
        return true;
    }

    private Sitemap getSitemap(String sitemapname) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapname);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    private boolean blockUnlessChangeOccurs(String sitemapname, String pageId) {
        boolean timeout = false;
        Sitemap sitemap = this.getSitemap(sitemapname);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                EList children = this.itemUIRegistry.getChildren(sitemap);
                timeout = this.waitForChanges((EList<Widget>)children);
            } else {
                Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget) {
                    EList children = this.itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                    timeout = this.waitForChanges((EList<Widget>)children);
                }
            }
        }
        return timeout;
    }

    private boolean waitForChanges(EList<Widget> widgets) {
        long startTime = new Date().getTime();
        boolean timeout = false;
        BlockingStateChangeListener listener = new BlockingStateChangeListener();
        Set<GenericItem> items = this.getAllItems(widgets);
        for (GenericItem item : items) {
            item.addStateChangeListener((StateChangeListener)listener);
        }
        while (!listener.hasChangeOccurred() && !timeout) {
            timeout = new Date().getTime() - startTime > 30000L;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                timeout = true;
                break;
            }
        }
        for (GenericItem item : items) {
            item.removeStateChangeListener((StateChangeListener)listener);
        }
        return timeout;
    }

    private Set<GenericItem> getAllItems(EList<Widget> widgets) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        if (this.itemUIRegistry != null) {
            for (Widget widget : widgets) {
                boolean skipWidget = false;
                if (widget instanceof Chart) {
                    Chart chartWidget = (Chart)widget;
                    skipWidget = chartWidget.getRefresh() > 0;
                }
                String itemName = widget.getItem();
                if (!skipWidget && itemName != null) {
                    try {
                        Item item = this.itemUIRegistry.getItem(itemName);
                        if (item instanceof GenericItem) {
                            items.add((GenericItem)item);
                        }
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                }
                if (widget instanceof Frame) {
                    items.addAll(this.getAllItems((EList<Widget>)((Frame)widget).getChildren()));
                }
                items.addAll(this.getItemsInVisibilityCond((EList<VisibilityRule>)widget.getVisibility()));
                items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getLabelColor()));
                items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getValueColor()));
            }
        }
        return items;
    }

    private Set<GenericItem> getItemsInVisibilityCond(EList<VisibilityRule> ruleList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (VisibilityRule rule : ruleList) {
            String itemName = rule.getItem();
            if (itemName == null) continue;
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                if (!(item instanceof GenericItem)) continue;
                items.add((GenericItem)item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        return items;
    }

    private Set<GenericItem> getItemsInColorCond(EList<ColorArray> colorList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (ColorArray color : colorList) {
            String itemName = color.getItem();
            if (itemName == null) continue;
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                if (!(item instanceof GenericItem)) continue;
                items.add((GenericItem)item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        return items;
    }

    @Override
    public void onEvent(SitemapEvent event) {
        OutboundEvent.Builder eventBuilder = new OutboundEvent.Builder();
        OutboundEvent outboundEvent = eventBuilder.name("event").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)event).build();
        this.broadcaster.broadcast((Object)outboundEvent);
    }

    @Override
    public void onRelease(String subscriptionId) {
        this.logger.debug("SSE connection for subscription {} has been released.", (Object)subscriptionId);
        EventOutput eventOutput = this.eventOutputs.remove(subscriptionId);
        if (eventOutput != null) {
            this.broadcaster.remove((ChunkedOutput)eventOutput);
        }
    }

    public void onClose(ChunkedOutput<OutboundEvent> event) {
        if (event instanceof SitemapEventOutput) {
            SitemapEventOutput sitemapEvent = (SitemapEventOutput)event;
            this.logger.debug("SSE connection for subscription {} has been closed.", (Object)sitemapEvent.getSubscriptionId());
            this.subscriptions.removeSubscription(sitemapEvent.getSubscriptionId());
            EventOutput eventOutput = this.eventOutputs.remove(sitemapEvent.getSubscriptionId());
            if (eventOutput != null) {
                this.broadcaster.remove((ChunkedOutput)eventOutput);
            }
        }
    }

    public void onException(ChunkedOutput<OutboundEvent> event, Exception e) {
    }

    public boolean isSatisfied() {
        return this.itemUIRegistry != null && this.subscriptions != null && this.localeService != null;
    }

    private static class BlockingStateChangeListener
    implements StateChangeListener {
        private boolean changed = false;

        private BlockingStateChangeListener() {
        }

        public void stateChanged(Item item, State oldState, State newState) {
            this.changed = true;
        }

        public boolean hasChangeOccurred() {
            return this.changed;
        }

        public void stateUpdated(Item item, State state) {
        }
    }
}

