/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.AttributeValueType;

public class BlueGigaAttributeValueEvent
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 4;
    public static int COMMAND_METHOD = 5;
    private int connection;
    private int attHandle;
    private AttributeValueType type;
    private int[] value;

    public BlueGigaAttributeValueEvent(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.connection = this.deserializeUInt8();
        this.attHandle = this.deserializeUInt16();
        this.type = this.deserializeAttributeValueType();
        this.value = this.deserializeUInt8Array();
    }

    public int getConnection() {
        return this.connection;
    }

    public int getAttHandle() {
        return this.attHandle;
    }

    public AttributeValueType getType() {
        return this.type;
    }

    public int[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaAttributeValueEvent [connection=");
        builder.append(this.connection);
        builder.append(", attHandle=");
        builder.append(this.attHandle);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", value=");
        int c = 0;
        while (c < this.value.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.value[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

