/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.AttributeChangeReason;

public class BlueGigaValueEvent
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 2;
    public static int COMMAND_METHOD = 0;
    private int connection;
    private AttributeChangeReason reason;
    private int handle;
    private int offset;
    private int[] value;

    public BlueGigaValueEvent(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.connection = this.deserializeUInt8();
        this.reason = this.deserializeAttributeChangeReason();
        this.handle = this.deserializeUInt16();
        this.offset = this.deserializeUInt16();
        this.value = this.deserializeUInt8Array();
    }

    public int getConnection() {
        return this.connection;
    }

    public AttributeChangeReason getReason() {
        return this.reason;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaValueEvent [connection=");
        builder.append(this.connection);
        builder.append(", reason=");
        builder.append((Object)this.reason);
        builder.append(", handle=");
        builder.append(this.handle);
        builder.append(", offset=");
        builder.append(this.offset);
        builder.append(", value=");
        int c = 0;
        while (c < this.value.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.value[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

