/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir;

import java.util.HashMap;
import java.util.Map;

public enum EirFlags {
    UNKNOWN(-1),
    LE_LIMITED_DISCOVERABLE_MODE(0),
    LE_GENERAL_DISCOVERABLE_MODE(1),
    BR_EDR_NOT_SUPPORTED(2),
    SIMULTANEOUS_LE_BDR_CONTROLLER(3),
    SIMULTANEOUS_LE_BDR_HOST(4),
    BIT5(5),
    BIT6(6),
    BIT7(7),
    BIT8(8),
    BIT9(9),
    BIT10(10),
    BIT11(11),
    BIT12(12),
    BIT13(13),
    BIT14(14),
    BIT15(15);

    private static Map<Integer, EirFlags> codeMapping;
    private int key;

    private EirFlags(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, EirFlags>();
        EirFlags[] eirFlagsArray = EirFlags.values();
        int n = eirFlagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EirFlags s = eirFlagsArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static EirFlags getEirFlag(int eirFlag) {
        if (codeMapping == null) {
            EirFlags.initMapping();
        }
        if (codeMapping.get(eirFlag) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(eirFlag);
    }

    public int getKey() {
        return this.key;
    }
}

