/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum ConnectionStatusFlag {
    UNKNOWN(-1),
    CONNECTION_CONNECTED(1),
    CONNECTION_ENCRYPTED(2),
    CONNECTION_COMPLETED(4),
    CONNECTION_PARAMETERS_CHANGE(8);

    private static Map<Integer, ConnectionStatusFlag> codeMapping;
    private int key;

    private ConnectionStatusFlag(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, ConnectionStatusFlag>();
        ConnectionStatusFlag[] connectionStatusFlagArray = ConnectionStatusFlag.values();
        int n = connectionStatusFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionStatusFlag s = connectionStatusFlagArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static ConnectionStatusFlag getConnectionStatusFlag(int connectionStatusFlag) {
        if (codeMapping == null) {
            ConnectionStatusFlag.initMapping();
        }
        if (codeMapping.get(connectionStatusFlag) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(connectionStatusFlag);
    }

    public int getKey() {
        return this.key;
    }
}

