/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum GapConnectableMode {
    UNKNOWN(-1),
    GAP_NON_CONNECTABLE(0),
    GAP_DIRECTED_CONNECTABLE(1),
    GAP_UNDIRECTED_CONNECTABLE(2),
    GAP_SCANNABLE_NON_CONNECTABLE(3);

    private static Map<Integer, GapConnectableMode> codeMapping;
    private int key;

    private GapConnectableMode(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, GapConnectableMode>();
        GapConnectableMode[] gapConnectableModeArray = GapConnectableMode.values();
        int n = gapConnectableModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GapConnectableMode s = gapConnectableModeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static GapConnectableMode getGapConnectableMode(int gapConnectableMode) {
        if (codeMapping == null) {
            GapConnectableMode.initMapping();
        }
        if (codeMapping.get(gapConnectableMode) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(gapConnectableMode);
    }

    public int getKey() {
        return this.key;
    }
}

