/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum ScanResponseType {
    UNKNOWN(-1),
    CONNECTABLE_ADVERTISEMENT(0),
    NON_CONNECTABLE_ADVERTISEMENT(2),
    SCAN_RESPONSE(4),
    DISCOVERABLE_ADVERTISEMENT(6);

    private static Map<Integer, ScanResponseType> codeMapping;
    private int key;

    private ScanResponseType(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, ScanResponseType>();
        ScanResponseType[] scanResponseTypeArray = ScanResponseType.values();
        int n = scanResponseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScanResponseType s = scanResponseTypeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static ScanResponseType getScanResponseType(int scanResponseType) {
        if (codeMapping == null) {
            ScanResponseType.initMapping();
        }
        if (codeMapping.get(scanResponseType) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(scanResponseType);
    }

    public int getKey() {
        return this.key;
    }
}

