/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt.internal;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnectionConfig;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.eclipse.smarthome.io.transport.mqtt.internal.MqttServiceImpl;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, service={MqttBrokerConnectionServiceInstance.class}, configurationPid="org.eclipse.smarthome.mqttbroker")
@NonNullByDefault
public class MqttBrokerConnectionServiceInstance {
    private final Logger logger = LoggerFactory.getLogger(MqttBrokerConnectionServiceInstance.class);
    private @Nullable MqttBrokerConnection connection;
    private @Nullable MqttService mqttService;

    @Reference
    public void setMqttService(MqttService service) {
        this.mqttService = service;
    }

    public void unsetMqttService(MqttService service) {
        this.mqttService = null;
    }

    @Modified
    public void modified(@Nullable Map<String, Object> configMap) {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (configMap == null || configMap.isEmpty() || this.mqttService == null) {
            return;
        }
        @NonNull MqttServiceImpl service = (MqttServiceImpl)this.mqttService;
        MqttBrokerConnectionConfig config = (MqttBrokerConnectionConfig)new Configuration(configMap).as(MqttBrokerConnectionConfig.class);
        try {
            MqttBrokerConnection c;
            String brokerID = config.getBrokerID();
            if (StringUtils.isBlank((String)brokerID) || brokerID == null) {
                this.logger.warn("Ignore invalid broker connection configuration: {}", (Object)config);
                return;
            }
            this.connection = c = service.addBrokerConnection(brokerID, config);
            if (c == null) {
                this.logger.warn("Ignore existing broker connection configuration for: {}", (Object)brokerID);
                return;
            }
            c.start();
        }
        catch (IllegalArgumentException | ConfigurationException e) {
            this.logger.warn("MqttBroker connection configuration faulty: {}", (Object)e.getMessage());
        }
        catch (MqttException e) {
            this.logger.warn("MqttBroker start failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Activate
    public void activate(@Nullable Map<String, Object> config) {
        this.logger.debug("MQTT Broker connection service started...");
        this.modified(config);
    }

    @Deactivate
    public void deactivate() {
        if (this.connection != null) {
            this.connection.stop();
        }
        this.connection = null;
    }
}

