/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.smarthome.model.ide.contentassist.antlr.internal.InternalSitemapParser;
import org.eclipse.smarthome.model.services.SitemapGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class SitemapParser
extends AbstractContentAssistParser {
    @Inject
    private NameMappings nameMappings;
    @Inject
    private SitemapGrammarAccess grammarAccess;

    protected InternalSitemapParser createParser() {
        InternalSitemapParser result = new InternalSitemapParser(null);
        result.setGrammarAccess(this.grammarAccess);
        return result;
    }

    protected String getRuleName(AbstractElement element) {
        return this.nameMappings.getRuleName(element);
    }

    protected String[] getInitialHiddenTokens() {
        return new String[]{"RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT"};
    }

    public SitemapGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    public void setGrammarAccess(SitemapGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }

    public NameMappings getNameMappings() {
        return this.nameMappings;
    }

    public void setNameMappings(NameMappings nameMappings) {
        this.nameMappings = nameMappings;
    }

    @Singleton
    public static final class NameMappings {
        private final Map<AbstractElement, String> mappings;

        @Inject
        public NameMappings(SitemapGrammarAccess grammarAccess) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            NameMappings.init((ImmutableMap.Builder<AbstractElement, String>)builder, grammarAccess);
            this.mappings = builder.build();
        }

        public String getRuleName(AbstractElement element) {
            return this.mappings.get(element);
        }

        private static void init(ImmutableMap.Builder<AbstractElement, String> builder, SitemapGrammarAccess grammarAccess) {
            builder.put((Object)grammarAccess.getWidgetAccess().getAlternatives(), (Object)"rule__Widget__Alternatives");
            builder.put((Object)grammarAccess.getNonLinkableWidgetAccess().getAlternatives(), (Object)"rule__NonLinkableWidget__Alternatives");
            builder.put((Object)grammarAccess.getLinkableWidgetAccess().getAlternatives_0(), (Object)"rule__LinkableWidget__Alternatives_0");
            builder.put((Object)grammarAccess.getFrameAccess().getLabelAlternatives_2_1_1_0(), (Object)"rule__Frame__LabelAlternatives_2_1_1_0");
            builder.put((Object)grammarAccess.getTextAccess().getLabelAlternatives_2_1_1_0(), (Object)"rule__Text__LabelAlternatives_2_1_1_0");
            builder.put((Object)grammarAccess.getGroupAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Group__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getImageAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Image__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getVideoAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Video__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getChartAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Chart__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getWebviewAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Webview__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getSwitchAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Switch__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getMapviewAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Mapview__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getSliderAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Slider__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getSelectionAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Selection__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getListAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__List__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getSetpointAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Setpoint__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Colorpicker__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getDefaultAccess().getLabelAlternatives_1_1_1_0(), (Object)"rule__Default__LabelAlternatives_1_1_1_0");
            builder.put((Object)grammarAccess.getMappingAccess().getLabelAlternatives_2_0(), (Object)"rule__Mapping__LabelAlternatives_2_0");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getConditionAlternatives_1_0(), (Object)"rule__VisibilityRule__ConditionAlternatives_1_0");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getSignAlternatives_2_0(), (Object)"rule__VisibilityRule__SignAlternatives_2_0");
            builder.put((Object)grammarAccess.getIconAccess().getAlternatives(), (Object)"rule__Icon__Alternatives");
            builder.put((Object)grammarAccess.getColorArrayAccess().getConditionAlternatives_0_1_0(), (Object)"rule__ColorArray__ConditionAlternatives_0_1_0");
            builder.put((Object)grammarAccess.getColorArrayAccess().getSignAlternatives_0_2_0(), (Object)"rule__ColorArray__SignAlternatives_0_2_0");
            builder.put((Object)grammarAccess.getCommandAccess().getAlternatives(), (Object)"rule__Command__Alternatives");
            builder.put((Object)grammarAccess.getNumberAccess().getAlternatives_1(), (Object)"rule__Number__Alternatives_1");
            builder.put((Object)grammarAccess.getXStateAccess().getAlternatives(), (Object)"rule__XState__Alternatives");
            builder.put((Object)grammarAccess.getBOOLEAN_OBJECTAccess().getAlternatives(), (Object)"rule__BOOLEAN_OBJECT__Alternatives");
            builder.put((Object)grammarAccess.getSitemapModelAccess().getGroup(), (Object)"rule__SitemapModel__Group__0");
            builder.put((Object)grammarAccess.getSitemapAccess().getGroup(), (Object)"rule__Sitemap__Group__0");
            builder.put((Object)grammarAccess.getSitemapAccess().getGroup_1(), (Object)"rule__Sitemap__Group_1__0");
            builder.put((Object)grammarAccess.getSitemapAccess().getGroup_2(), (Object)"rule__Sitemap__Group_2__0");
            builder.put((Object)grammarAccess.getLinkableWidgetAccess().getGroup(), (Object)"rule__LinkableWidget__Group__0");
            builder.put((Object)grammarAccess.getLinkableWidgetAccess().getGroup_1(), (Object)"rule__LinkableWidget__Group_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup(), (Object)"rule__Frame__Group__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_0(), (Object)"rule__Frame__Group_2_0__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_1(), (Object)"rule__Frame__Group_2_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_2(), (Object)"rule__Frame__Group_2_2__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_3(), (Object)"rule__Frame__Group_2_3__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_3_1(), (Object)"rule__Frame__Group_2_3_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_3_1_1(), (Object)"rule__Frame__Group_2_3_1_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_4(), (Object)"rule__Frame__Group_2_4__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_4_1(), (Object)"rule__Frame__Group_2_4_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_4_1_1(), (Object)"rule__Frame__Group_2_4_1_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_5(), (Object)"rule__Frame__Group_2_5__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_5_1(), (Object)"rule__Frame__Group_2_5_1__0");
            builder.put((Object)grammarAccess.getFrameAccess().getGroup_2_5_1_1(), (Object)"rule__Frame__Group_2_5_1_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup(), (Object)"rule__Text__Group__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_0(), (Object)"rule__Text__Group_2_0__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_1(), (Object)"rule__Text__Group_2_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_2(), (Object)"rule__Text__Group_2_2__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_3(), (Object)"rule__Text__Group_2_3__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_3_1(), (Object)"rule__Text__Group_2_3_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_3_1_1(), (Object)"rule__Text__Group_2_3_1_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_4(), (Object)"rule__Text__Group_2_4__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_4_1(), (Object)"rule__Text__Group_2_4_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_4_1_1(), (Object)"rule__Text__Group_2_4_1_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_5(), (Object)"rule__Text__Group_2_5__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_5_1(), (Object)"rule__Text__Group_2_5_1__0");
            builder.put((Object)grammarAccess.getTextAccess().getGroup_2_5_1_1(), (Object)"rule__Text__Group_2_5_1_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup(), (Object)"rule__Group__Group__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_0(), (Object)"rule__Group__Group_1_0__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_1(), (Object)"rule__Group__Group_1_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_2(), (Object)"rule__Group__Group_1_2__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_3(), (Object)"rule__Group__Group_1_3__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_3_1(), (Object)"rule__Group__Group_1_3_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_3_1_1(), (Object)"rule__Group__Group_1_3_1_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_4(), (Object)"rule__Group__Group_1_4__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_4_1(), (Object)"rule__Group__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_4_1_1(), (Object)"rule__Group__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_5(), (Object)"rule__Group__Group_1_5__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_5_1(), (Object)"rule__Group__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getGroupAccess().getGroup_1_5_1_1(), (Object)"rule__Group__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup(), (Object)"rule__Image__Group__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_0(), (Object)"rule__Image__Group_1_0__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_1(), (Object)"rule__Image__Group_1_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_2(), (Object)"rule__Image__Group_1_2__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_3(), (Object)"rule__Image__Group_1_3__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_4(), (Object)"rule__Image__Group_1_4__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_5(), (Object)"rule__Image__Group_1_5__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_5_1(), (Object)"rule__Image__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_5_1_1(), (Object)"rule__Image__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_6(), (Object)"rule__Image__Group_1_6__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_6_1(), (Object)"rule__Image__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_6_1_1(), (Object)"rule__Image__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_7(), (Object)"rule__Image__Group_1_7__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_7_1(), (Object)"rule__Image__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_7_1_1(), (Object)"rule__Image__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_8(), (Object)"rule__Image__Group_1_8__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_8_1(), (Object)"rule__Image__Group_1_8_1__0");
            builder.put((Object)grammarAccess.getImageAccess().getGroup_1_8_1_1(), (Object)"rule__Image__Group_1_8_1_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup(), (Object)"rule__Video__Group__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_0(), (Object)"rule__Video__Group_1_0__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_1(), (Object)"rule__Video__Group_1_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_2(), (Object)"rule__Video__Group_1_2__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_3(), (Object)"rule__Video__Group_1_3__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_4(), (Object)"rule__Video__Group_1_4__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_5(), (Object)"rule__Video__Group_1_5__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_5_1(), (Object)"rule__Video__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_5_1_1(), (Object)"rule__Video__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_6(), (Object)"rule__Video__Group_1_6__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_6_1(), (Object)"rule__Video__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_6_1_1(), (Object)"rule__Video__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_7(), (Object)"rule__Video__Group_1_7__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_7_1(), (Object)"rule__Video__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getVideoAccess().getGroup_1_7_1_1(), (Object)"rule__Video__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup(), (Object)"rule__Chart__Group__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_0(), (Object)"rule__Chart__Group_1_0__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_1(), (Object)"rule__Chart__Group_1_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_2(), (Object)"rule__Chart__Group_1_2__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_3(), (Object)"rule__Chart__Group_1_3__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_4(), (Object)"rule__Chart__Group_1_4__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_5(), (Object)"rule__Chart__Group_1_5__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_6(), (Object)"rule__Chart__Group_1_6__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_7(), (Object)"rule__Chart__Group_1_7__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_7_1(), (Object)"rule__Chart__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_7_1_1(), (Object)"rule__Chart__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_8(), (Object)"rule__Chart__Group_1_8__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_8_1(), (Object)"rule__Chart__Group_1_8_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_8_1_1(), (Object)"rule__Chart__Group_1_8_1_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_9(), (Object)"rule__Chart__Group_1_9__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_9_1(), (Object)"rule__Chart__Group_1_9_1__0");
            builder.put((Object)grammarAccess.getChartAccess().getGroup_1_9_1_1(), (Object)"rule__Chart__Group_1_9_1_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup(), (Object)"rule__Webview__Group__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_0(), (Object)"rule__Webview__Group_1_0__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_1(), (Object)"rule__Webview__Group_1_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_2(), (Object)"rule__Webview__Group_1_2__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_3(), (Object)"rule__Webview__Group_1_3__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_4(), (Object)"rule__Webview__Group_1_4__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_5(), (Object)"rule__Webview__Group_1_5__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_5_1(), (Object)"rule__Webview__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_5_1_1(), (Object)"rule__Webview__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_6(), (Object)"rule__Webview__Group_1_6__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_6_1(), (Object)"rule__Webview__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_6_1_1(), (Object)"rule__Webview__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_7(), (Object)"rule__Webview__Group_1_7__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_7_1(), (Object)"rule__Webview__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getWebviewAccess().getGroup_1_7_1_1(), (Object)"rule__Webview__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup(), (Object)"rule__Switch__Group__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_0(), (Object)"rule__Switch__Group_1_0__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_1(), (Object)"rule__Switch__Group_1_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_2(), (Object)"rule__Switch__Group_1_2__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_3(), (Object)"rule__Switch__Group_1_3__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_3_2(), (Object)"rule__Switch__Group_1_3_2__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_4(), (Object)"rule__Switch__Group_1_4__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_4_1(), (Object)"rule__Switch__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_4_1_1(), (Object)"rule__Switch__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_5(), (Object)"rule__Switch__Group_1_5__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_5_1(), (Object)"rule__Switch__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_5_1_1(), (Object)"rule__Switch__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_6(), (Object)"rule__Switch__Group_1_6__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_6_1(), (Object)"rule__Switch__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getSwitchAccess().getGroup_1_6_1_1(), (Object)"rule__Switch__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup(), (Object)"rule__Mapview__Group__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_0(), (Object)"rule__Mapview__Group_1_0__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_1(), (Object)"rule__Mapview__Group_1_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_2(), (Object)"rule__Mapview__Group_1_2__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_3(), (Object)"rule__Mapview__Group_1_3__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_4(), (Object)"rule__Mapview__Group_1_4__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_4_1(), (Object)"rule__Mapview__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_4_1_1(), (Object)"rule__Mapview__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_5(), (Object)"rule__Mapview__Group_1_5__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_5_1(), (Object)"rule__Mapview__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_5_1_1(), (Object)"rule__Mapview__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_6(), (Object)"rule__Mapview__Group_1_6__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_6_1(), (Object)"rule__Mapview__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getMapviewAccess().getGroup_1_6_1_1(), (Object)"rule__Mapview__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup(), (Object)"rule__Slider__Group__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_0(), (Object)"rule__Slider__Group_1_0__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_1(), (Object)"rule__Slider__Group_1_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_2(), (Object)"rule__Slider__Group_1_2__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_3(), (Object)"rule__Slider__Group_1_3__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_5(), (Object)"rule__Slider__Group_1_5__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_5_1(), (Object)"rule__Slider__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_5_1_1(), (Object)"rule__Slider__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_6(), (Object)"rule__Slider__Group_1_6__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_6_1(), (Object)"rule__Slider__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_6_1_1(), (Object)"rule__Slider__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_7(), (Object)"rule__Slider__Group_1_7__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_7_1(), (Object)"rule__Slider__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getSliderAccess().getGroup_1_7_1_1(), (Object)"rule__Slider__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup(), (Object)"rule__Selection__Group__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_0(), (Object)"rule__Selection__Group_1_0__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_1(), (Object)"rule__Selection__Group_1_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_2(), (Object)"rule__Selection__Group_1_2__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_3(), (Object)"rule__Selection__Group_1_3__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_3_2(), (Object)"rule__Selection__Group_1_3_2__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_4(), (Object)"rule__Selection__Group_1_4__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_4_1(), (Object)"rule__Selection__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_4_1_1(), (Object)"rule__Selection__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_5(), (Object)"rule__Selection__Group_1_5__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_5_1(), (Object)"rule__Selection__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_5_1_1(), (Object)"rule__Selection__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_6(), (Object)"rule__Selection__Group_1_6__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_6_1(), (Object)"rule__Selection__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getSelectionAccess().getGroup_1_6_1_1(), (Object)"rule__Selection__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup(), (Object)"rule__List__Group__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_0(), (Object)"rule__List__Group_1_0__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_1(), (Object)"rule__List__Group_1_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_2(), (Object)"rule__List__Group_1_2__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_2_0(), (Object)"rule__List__Group_1_2_0__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_2_1(), (Object)"rule__List__Group_1_2_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_3(), (Object)"rule__List__Group_1_3__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_3_1(), (Object)"rule__List__Group_1_3_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_3_1_1(), (Object)"rule__List__Group_1_3_1_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_4(), (Object)"rule__List__Group_1_4__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_4_1(), (Object)"rule__List__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_4_1_1(), (Object)"rule__List__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_5(), (Object)"rule__List__Group_1_5__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_5_1(), (Object)"rule__List__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getListAccess().getGroup_1_5_1_1(), (Object)"rule__List__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup(), (Object)"rule__Setpoint__Group__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_0(), (Object)"rule__Setpoint__Group_1_0__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_1(), (Object)"rule__Setpoint__Group_1_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_2(), (Object)"rule__Setpoint__Group_1_2__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_3(), (Object)"rule__Setpoint__Group_1_3__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_4(), (Object)"rule__Setpoint__Group_1_4__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_5(), (Object)"rule__Setpoint__Group_1_5__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_6(), (Object)"rule__Setpoint__Group_1_6__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_6_1(), (Object)"rule__Setpoint__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_6_1_1(), (Object)"rule__Setpoint__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_7(), (Object)"rule__Setpoint__Group_1_7__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_7_1(), (Object)"rule__Setpoint__Group_1_7_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_7_1_1(), (Object)"rule__Setpoint__Group_1_7_1_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_8(), (Object)"rule__Setpoint__Group_1_8__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_8_1(), (Object)"rule__Setpoint__Group_1_8_1__0");
            builder.put((Object)grammarAccess.getSetpointAccess().getGroup_1_8_1_1(), (Object)"rule__Setpoint__Group_1_8_1_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup(), (Object)"rule__Colorpicker__Group__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_0(), (Object)"rule__Colorpicker__Group_1_0__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_1(), (Object)"rule__Colorpicker__Group_1_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_2(), (Object)"rule__Colorpicker__Group_1_2__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_3(), (Object)"rule__Colorpicker__Group_1_3__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_4(), (Object)"rule__Colorpicker__Group_1_4__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_4_1(), (Object)"rule__Colorpicker__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_4_1_1(), (Object)"rule__Colorpicker__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_5(), (Object)"rule__Colorpicker__Group_1_5__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_5_1(), (Object)"rule__Colorpicker__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_5_1_1(), (Object)"rule__Colorpicker__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_6(), (Object)"rule__Colorpicker__Group_1_6__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_6_1(), (Object)"rule__Colorpicker__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getGroup_1_6_1_1(), (Object)"rule__Colorpicker__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup(), (Object)"rule__Default__Group__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_0(), (Object)"rule__Default__Group_1_0__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_1(), (Object)"rule__Default__Group_1_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_2(), (Object)"rule__Default__Group_1_2__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_3(), (Object)"rule__Default__Group_1_3__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_4(), (Object)"rule__Default__Group_1_4__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_4_1(), (Object)"rule__Default__Group_1_4_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_4_1_1(), (Object)"rule__Default__Group_1_4_1_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_5(), (Object)"rule__Default__Group_1_5__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_5_1(), (Object)"rule__Default__Group_1_5_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_5_1_1(), (Object)"rule__Default__Group_1_5_1_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_6(), (Object)"rule__Default__Group_1_6__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_6_1(), (Object)"rule__Default__Group_1_6_1__0");
            builder.put((Object)grammarAccess.getDefaultAccess().getGroup_1_6_1_1(), (Object)"rule__Default__Group_1_6_1_1__0");
            builder.put((Object)grammarAccess.getMappingAccess().getGroup(), (Object)"rule__Mapping__Group__0");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getGroup(), (Object)"rule__VisibilityRule__Group__0");
            builder.put((Object)grammarAccess.getColorArrayAccess().getGroup(), (Object)"rule__ColorArray__Group__0");
            builder.put((Object)grammarAccess.getColorArrayAccess().getGroup_0(), (Object)"rule__ColorArray__Group_0__0");
            builder.put((Object)grammarAccess.getNumberAccess().getGroup(), (Object)"rule__Number__Group__0");
            builder.put((Object)grammarAccess.getSitemapAccess().getNameAssignment_0(), (Object)"rule__Sitemap__NameAssignment_0");
            builder.put((Object)grammarAccess.getSitemapAccess().getLabelAssignment_1_1(), (Object)"rule__Sitemap__LabelAssignment_1_1");
            builder.put((Object)grammarAccess.getSitemapAccess().getIconAssignment_2_1(), (Object)"rule__Sitemap__IconAssignment_2_1");
            builder.put((Object)grammarAccess.getSitemapAccess().getChildrenAssignment_4(), (Object)"rule__Sitemap__ChildrenAssignment_4");
            builder.put((Object)grammarAccess.getLinkableWidgetAccess().getChildrenAssignment_1_1(), (Object)"rule__LinkableWidget__ChildrenAssignment_1_1");
            builder.put((Object)grammarAccess.getFrameAccess().getItemAssignment_2_0_1(), (Object)"rule__Frame__ItemAssignment_2_0_1");
            builder.put((Object)grammarAccess.getFrameAccess().getLabelAssignment_2_1_1(), (Object)"rule__Frame__LabelAssignment_2_1_1");
            builder.put((Object)grammarAccess.getFrameAccess().getIconAssignment_2_2_1(), (Object)"rule__Frame__IconAssignment_2_2_1");
            builder.put((Object)grammarAccess.getFrameAccess().getLabelColorAssignment_2_3_1_0(), (Object)"rule__Frame__LabelColorAssignment_2_3_1_0");
            builder.put((Object)grammarAccess.getFrameAccess().getLabelColorAssignment_2_3_1_1_1(), (Object)"rule__Frame__LabelColorAssignment_2_3_1_1_1");
            builder.put((Object)grammarAccess.getFrameAccess().getValueColorAssignment_2_4_1_0(), (Object)"rule__Frame__ValueColorAssignment_2_4_1_0");
            builder.put((Object)grammarAccess.getFrameAccess().getValueColorAssignment_2_4_1_1_1(), (Object)"rule__Frame__ValueColorAssignment_2_4_1_1_1");
            builder.put((Object)grammarAccess.getFrameAccess().getVisibilityAssignment_2_5_1_0(), (Object)"rule__Frame__VisibilityAssignment_2_5_1_0");
            builder.put((Object)grammarAccess.getFrameAccess().getVisibilityAssignment_2_5_1_1_1(), (Object)"rule__Frame__VisibilityAssignment_2_5_1_1_1");
            builder.put((Object)grammarAccess.getTextAccess().getItemAssignment_2_0_1(), (Object)"rule__Text__ItemAssignment_2_0_1");
            builder.put((Object)grammarAccess.getTextAccess().getLabelAssignment_2_1_1(), (Object)"rule__Text__LabelAssignment_2_1_1");
            builder.put((Object)grammarAccess.getTextAccess().getIconAssignment_2_2_1(), (Object)"rule__Text__IconAssignment_2_2_1");
            builder.put((Object)grammarAccess.getTextAccess().getLabelColorAssignment_2_3_1_0(), (Object)"rule__Text__LabelColorAssignment_2_3_1_0");
            builder.put((Object)grammarAccess.getTextAccess().getLabelColorAssignment_2_3_1_1_1(), (Object)"rule__Text__LabelColorAssignment_2_3_1_1_1");
            builder.put((Object)grammarAccess.getTextAccess().getValueColorAssignment_2_4_1_0(), (Object)"rule__Text__ValueColorAssignment_2_4_1_0");
            builder.put((Object)grammarAccess.getTextAccess().getValueColorAssignment_2_4_1_1_1(), (Object)"rule__Text__ValueColorAssignment_2_4_1_1_1");
            builder.put((Object)grammarAccess.getTextAccess().getVisibilityAssignment_2_5_1_0(), (Object)"rule__Text__VisibilityAssignment_2_5_1_0");
            builder.put((Object)grammarAccess.getTextAccess().getVisibilityAssignment_2_5_1_1_1(), (Object)"rule__Text__VisibilityAssignment_2_5_1_1_1");
            builder.put((Object)grammarAccess.getGroupAccess().getItemAssignment_1_0_1(), (Object)"rule__Group__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getGroupAccess().getLabelAssignment_1_1_1(), (Object)"rule__Group__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getGroupAccess().getIconAssignment_1_2_1(), (Object)"rule__Group__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getGroupAccess().getLabelColorAssignment_1_3_1_0(), (Object)"rule__Group__LabelColorAssignment_1_3_1_0");
            builder.put((Object)grammarAccess.getGroupAccess().getLabelColorAssignment_1_3_1_1_1(), (Object)"rule__Group__LabelColorAssignment_1_3_1_1_1");
            builder.put((Object)grammarAccess.getGroupAccess().getValueColorAssignment_1_4_1_0(), (Object)"rule__Group__ValueColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getGroupAccess().getValueColorAssignment_1_4_1_1_1(), (Object)"rule__Group__ValueColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getGroupAccess().getVisibilityAssignment_1_5_1_0(), (Object)"rule__Group__VisibilityAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getGroupAccess().getVisibilityAssignment_1_5_1_1_1(), (Object)"rule__Group__VisibilityAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getImageAccess().getItemAssignment_1_0_1(), (Object)"rule__Image__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getImageAccess().getLabelAssignment_1_1_1(), (Object)"rule__Image__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getImageAccess().getIconAssignment_1_2_1(), (Object)"rule__Image__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getImageAccess().getUrlAssignment_1_3_1(), (Object)"rule__Image__UrlAssignment_1_3_1");
            builder.put((Object)grammarAccess.getImageAccess().getRefreshAssignment_1_4_1(), (Object)"rule__Image__RefreshAssignment_1_4_1");
            builder.put((Object)grammarAccess.getImageAccess().getLabelColorAssignment_1_5_1_0(), (Object)"rule__Image__LabelColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getImageAccess().getLabelColorAssignment_1_5_1_1_1(), (Object)"rule__Image__LabelColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getImageAccess().getValueColorAssignment_1_6_1_0(), (Object)"rule__Image__ValueColorAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getImageAccess().getValueColorAssignment_1_6_1_1_1(), (Object)"rule__Image__ValueColorAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getImageAccess().getIconColorAssignment_1_7_1_0(), (Object)"rule__Image__IconColorAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getImageAccess().getIconColorAssignment_1_7_1_1_1(), (Object)"rule__Image__IconColorAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getImageAccess().getVisibilityAssignment_1_8_1_0(), (Object)"rule__Image__VisibilityAssignment_1_8_1_0");
            builder.put((Object)grammarAccess.getImageAccess().getVisibilityAssignment_1_8_1_1_1(), (Object)"rule__Image__VisibilityAssignment_1_8_1_1_1");
            builder.put((Object)grammarAccess.getVideoAccess().getItemAssignment_1_0_1(), (Object)"rule__Video__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getVideoAccess().getLabelAssignment_1_1_1(), (Object)"rule__Video__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getVideoAccess().getIconAssignment_1_2_1(), (Object)"rule__Video__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getVideoAccess().getUrlAssignment_1_3_1(), (Object)"rule__Video__UrlAssignment_1_3_1");
            builder.put((Object)grammarAccess.getVideoAccess().getEncodingAssignment_1_4_1(), (Object)"rule__Video__EncodingAssignment_1_4_1");
            builder.put((Object)grammarAccess.getVideoAccess().getLabelColorAssignment_1_5_1_0(), (Object)"rule__Video__LabelColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getVideoAccess().getLabelColorAssignment_1_5_1_1_1(), (Object)"rule__Video__LabelColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getVideoAccess().getValueColorAssignment_1_6_1_0(), (Object)"rule__Video__ValueColorAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getVideoAccess().getValueColorAssignment_1_6_1_1_1(), (Object)"rule__Video__ValueColorAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getVideoAccess().getVisibilityAssignment_1_7_1_0(), (Object)"rule__Video__VisibilityAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getVideoAccess().getVisibilityAssignment_1_7_1_1_1(), (Object)"rule__Video__VisibilityAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getChartAccess().getItemAssignment_1_0_1(), (Object)"rule__Chart__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getChartAccess().getLabelAssignment_1_1_1(), (Object)"rule__Chart__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getChartAccess().getIconAssignment_1_2_1(), (Object)"rule__Chart__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getChartAccess().getServiceAssignment_1_3_1(), (Object)"rule__Chart__ServiceAssignment_1_3_1");
            builder.put((Object)grammarAccess.getChartAccess().getRefreshAssignment_1_4_1(), (Object)"rule__Chart__RefreshAssignment_1_4_1");
            builder.put((Object)grammarAccess.getChartAccess().getPeriodAssignment_1_5_1(), (Object)"rule__Chart__PeriodAssignment_1_5_1");
            builder.put((Object)grammarAccess.getChartAccess().getLegendAssignment_1_6_1(), (Object)"rule__Chart__LegendAssignment_1_6_1");
            builder.put((Object)grammarAccess.getChartAccess().getLabelColorAssignment_1_7_1_0(), (Object)"rule__Chart__LabelColorAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getChartAccess().getLabelColorAssignment_1_7_1_1_1(), (Object)"rule__Chart__LabelColorAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getChartAccess().getValueColorAssignment_1_8_1_0(), (Object)"rule__Chart__ValueColorAssignment_1_8_1_0");
            builder.put((Object)grammarAccess.getChartAccess().getValueColorAssignment_1_8_1_1_1(), (Object)"rule__Chart__ValueColorAssignment_1_8_1_1_1");
            builder.put((Object)grammarAccess.getChartAccess().getVisibilityAssignment_1_9_1_0(), (Object)"rule__Chart__VisibilityAssignment_1_9_1_0");
            builder.put((Object)grammarAccess.getChartAccess().getVisibilityAssignment_1_9_1_1_1(), (Object)"rule__Chart__VisibilityAssignment_1_9_1_1_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getItemAssignment_1_0_1(), (Object)"rule__Webview__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getLabelAssignment_1_1_1(), (Object)"rule__Webview__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getIconAssignment_1_2_1(), (Object)"rule__Webview__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getHeightAssignment_1_3_1(), (Object)"rule__Webview__HeightAssignment_1_3_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getUrlAssignment_1_4_1(), (Object)"rule__Webview__UrlAssignment_1_4_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getLabelColorAssignment_1_5_1_0(), (Object)"rule__Webview__LabelColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getWebviewAccess().getLabelColorAssignment_1_5_1_1_1(), (Object)"rule__Webview__LabelColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getValueColorAssignment_1_6_1_0(), (Object)"rule__Webview__ValueColorAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getWebviewAccess().getValueColorAssignment_1_6_1_1_1(), (Object)"rule__Webview__ValueColorAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getVisibilityAssignment_1_7_1_0(), (Object)"rule__Webview__VisibilityAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getWebviewAccess().getVisibilityAssignment_1_7_1_1_1(), (Object)"rule__Webview__VisibilityAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getItemAssignment_1_0_1(), (Object)"rule__Switch__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getLabelAssignment_1_1_1(), (Object)"rule__Switch__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getIconAssignment_1_2_1(), (Object)"rule__Switch__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getMappingsAssignment_1_3_1(), (Object)"rule__Switch__MappingsAssignment_1_3_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getMappingsAssignment_1_3_2_1(), (Object)"rule__Switch__MappingsAssignment_1_3_2_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getLabelColorAssignment_1_4_1_0(), (Object)"rule__Switch__LabelColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getSwitchAccess().getLabelColorAssignment_1_4_1_1_1(), (Object)"rule__Switch__LabelColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getValueColorAssignment_1_5_1_0(), (Object)"rule__Switch__ValueColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getSwitchAccess().getValueColorAssignment_1_5_1_1_1(), (Object)"rule__Switch__ValueColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getVisibilityAssignment_1_6_1_0(), (Object)"rule__Switch__VisibilityAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getSwitchAccess().getVisibilityAssignment_1_6_1_1_1(), (Object)"rule__Switch__VisibilityAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getItemAssignment_1_0_1(), (Object)"rule__Mapview__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getLabelAssignment_1_1_1(), (Object)"rule__Mapview__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getIconAssignment_1_2_1(), (Object)"rule__Mapview__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getHeightAssignment_1_3_1(), (Object)"rule__Mapview__HeightAssignment_1_3_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getLabelColorAssignment_1_4_1_0(), (Object)"rule__Mapview__LabelColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getMapviewAccess().getLabelColorAssignment_1_4_1_1_1(), (Object)"rule__Mapview__LabelColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getValueColorAssignment_1_5_1_0(), (Object)"rule__Mapview__ValueColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getMapviewAccess().getValueColorAssignment_1_5_1_1_1(), (Object)"rule__Mapview__ValueColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getVisibilityAssignment_1_6_1_0(), (Object)"rule__Mapview__VisibilityAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getMapviewAccess().getVisibilityAssignment_1_6_1_1_1(), (Object)"rule__Mapview__VisibilityAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getSliderAccess().getItemAssignment_1_0_1(), (Object)"rule__Slider__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getSliderAccess().getLabelAssignment_1_1_1(), (Object)"rule__Slider__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getSliderAccess().getIconAssignment_1_2_1(), (Object)"rule__Slider__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getSliderAccess().getFrequencyAssignment_1_3_1(), (Object)"rule__Slider__FrequencyAssignment_1_3_1");
            builder.put((Object)grammarAccess.getSliderAccess().getSwitchEnabledAssignment_1_4(), (Object)"rule__Slider__SwitchEnabledAssignment_1_4");
            builder.put((Object)grammarAccess.getSliderAccess().getLabelColorAssignment_1_5_1_0(), (Object)"rule__Slider__LabelColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getSliderAccess().getLabelColorAssignment_1_5_1_1_1(), (Object)"rule__Slider__LabelColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getSliderAccess().getValueColorAssignment_1_6_1_0(), (Object)"rule__Slider__ValueColorAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getSliderAccess().getValueColorAssignment_1_6_1_1_1(), (Object)"rule__Slider__ValueColorAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getSliderAccess().getVisibilityAssignment_1_7_1_0(), (Object)"rule__Slider__VisibilityAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getSliderAccess().getVisibilityAssignment_1_7_1_1_1(), (Object)"rule__Slider__VisibilityAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getItemAssignment_1_0_1(), (Object)"rule__Selection__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getLabelAssignment_1_1_1(), (Object)"rule__Selection__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getIconAssignment_1_2_1(), (Object)"rule__Selection__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getMappingsAssignment_1_3_1(), (Object)"rule__Selection__MappingsAssignment_1_3_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getMappingsAssignment_1_3_2_1(), (Object)"rule__Selection__MappingsAssignment_1_3_2_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getLabelColorAssignment_1_4_1_0(), (Object)"rule__Selection__LabelColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getSelectionAccess().getLabelColorAssignment_1_4_1_1_1(), (Object)"rule__Selection__LabelColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getValueColorAssignment_1_5_1_0(), (Object)"rule__Selection__ValueColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getSelectionAccess().getValueColorAssignment_1_5_1_1_1(), (Object)"rule__Selection__ValueColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getVisibilityAssignment_1_6_1_0(), (Object)"rule__Selection__VisibilityAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getSelectionAccess().getVisibilityAssignment_1_6_1_1_1(), (Object)"rule__Selection__VisibilityAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getListAccess().getItemAssignment_1_0_1(), (Object)"rule__List__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getListAccess().getLabelAssignment_1_1_1(), (Object)"rule__List__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getListAccess().getIconAssignment_1_2_0_1(), (Object)"rule__List__IconAssignment_1_2_0_1");
            builder.put((Object)grammarAccess.getListAccess().getSeparatorAssignment_1_2_1_1(), (Object)"rule__List__SeparatorAssignment_1_2_1_1");
            builder.put((Object)grammarAccess.getListAccess().getLabelColorAssignment_1_3_1_0(), (Object)"rule__List__LabelColorAssignment_1_3_1_0");
            builder.put((Object)grammarAccess.getListAccess().getLabelColorAssignment_1_3_1_1_1(), (Object)"rule__List__LabelColorAssignment_1_3_1_1_1");
            builder.put((Object)grammarAccess.getListAccess().getValueColorAssignment_1_4_1_0(), (Object)"rule__List__ValueColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getListAccess().getValueColorAssignment_1_4_1_1_1(), (Object)"rule__List__ValueColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getListAccess().getVisibilityAssignment_1_5_1_0(), (Object)"rule__List__VisibilityAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getListAccess().getVisibilityAssignment_1_5_1_1_1(), (Object)"rule__List__VisibilityAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getItemAssignment_1_0_1(), (Object)"rule__Setpoint__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getLabelAssignment_1_1_1(), (Object)"rule__Setpoint__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getIconAssignment_1_2_1(), (Object)"rule__Setpoint__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getMinValueAssignment_1_3_1(), (Object)"rule__Setpoint__MinValueAssignment_1_3_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getMaxValueAssignment_1_4_1(), (Object)"rule__Setpoint__MaxValueAssignment_1_4_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getStepAssignment_1_5_1(), (Object)"rule__Setpoint__StepAssignment_1_5_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getLabelColorAssignment_1_6_1_0(), (Object)"rule__Setpoint__LabelColorAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getSetpointAccess().getLabelColorAssignment_1_6_1_1_1(), (Object)"rule__Setpoint__LabelColorAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getValueColorAssignment_1_7_1_0(), (Object)"rule__Setpoint__ValueColorAssignment_1_7_1_0");
            builder.put((Object)grammarAccess.getSetpointAccess().getValueColorAssignment_1_7_1_1_1(), (Object)"rule__Setpoint__ValueColorAssignment_1_7_1_1_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getVisibilityAssignment_1_8_1_0(), (Object)"rule__Setpoint__VisibilityAssignment_1_8_1_0");
            builder.put((Object)grammarAccess.getSetpointAccess().getVisibilityAssignment_1_8_1_1_1(), (Object)"rule__Setpoint__VisibilityAssignment_1_8_1_1_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getItemAssignment_1_0_1(), (Object)"rule__Colorpicker__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getLabelAssignment_1_1_1(), (Object)"rule__Colorpicker__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getIconAssignment_1_2_1(), (Object)"rule__Colorpicker__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getFrequencyAssignment_1_3_1(), (Object)"rule__Colorpicker__FrequencyAssignment_1_3_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getLabelColorAssignment_1_4_1_0(), (Object)"rule__Colorpicker__LabelColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getLabelColorAssignment_1_4_1_1_1(), (Object)"rule__Colorpicker__LabelColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getValueColorAssignment_1_5_1_0(), (Object)"rule__Colorpicker__ValueColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getValueColorAssignment_1_5_1_1_1(), (Object)"rule__Colorpicker__ValueColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getVisibilityAssignment_1_6_1_0(), (Object)"rule__Colorpicker__VisibilityAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getColorpickerAccess().getVisibilityAssignment_1_6_1_1_1(), (Object)"rule__Colorpicker__VisibilityAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getItemAssignment_1_0_1(), (Object)"rule__Default__ItemAssignment_1_0_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getLabelAssignment_1_1_1(), (Object)"rule__Default__LabelAssignment_1_1_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getIconAssignment_1_2_1(), (Object)"rule__Default__IconAssignment_1_2_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getHeightAssignment_1_3_1(), (Object)"rule__Default__HeightAssignment_1_3_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getLabelColorAssignment_1_4_1_0(), (Object)"rule__Default__LabelColorAssignment_1_4_1_0");
            builder.put((Object)grammarAccess.getDefaultAccess().getLabelColorAssignment_1_4_1_1_1(), (Object)"rule__Default__LabelColorAssignment_1_4_1_1_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getValueColorAssignment_1_5_1_0(), (Object)"rule__Default__ValueColorAssignment_1_5_1_0");
            builder.put((Object)grammarAccess.getDefaultAccess().getValueColorAssignment_1_5_1_1_1(), (Object)"rule__Default__ValueColorAssignment_1_5_1_1_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getVisibilityAssignment_1_6_1_0(), (Object)"rule__Default__VisibilityAssignment_1_6_1_0");
            builder.put((Object)grammarAccess.getDefaultAccess().getVisibilityAssignment_1_6_1_1_1(), (Object)"rule__Default__VisibilityAssignment_1_6_1_1_1");
            builder.put((Object)grammarAccess.getMappingAccess().getCmdAssignment_0(), (Object)"rule__Mapping__CmdAssignment_0");
            builder.put((Object)grammarAccess.getMappingAccess().getLabelAssignment_2(), (Object)"rule__Mapping__LabelAssignment_2");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getItemAssignment_0(), (Object)"rule__VisibilityRule__ItemAssignment_0");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getConditionAssignment_1(), (Object)"rule__VisibilityRule__ConditionAssignment_1");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getSignAssignment_2(), (Object)"rule__VisibilityRule__SignAssignment_2");
            builder.put((Object)grammarAccess.getVisibilityRuleAccess().getStateAssignment_3(), (Object)"rule__VisibilityRule__StateAssignment_3");
            builder.put((Object)grammarAccess.getColorArrayAccess().getItemAssignment_0_0(), (Object)"rule__ColorArray__ItemAssignment_0_0");
            builder.put((Object)grammarAccess.getColorArrayAccess().getConditionAssignment_0_1(), (Object)"rule__ColorArray__ConditionAssignment_0_1");
            builder.put((Object)grammarAccess.getColorArrayAccess().getSignAssignment_0_2(), (Object)"rule__ColorArray__SignAssignment_0_2");
            builder.put((Object)grammarAccess.getColorArrayAccess().getStateAssignment_0_3(), (Object)"rule__ColorArray__StateAssignment_0_3");
            builder.put((Object)grammarAccess.getColorArrayAccess().getArgAssignment_1(), (Object)"rule__ColorArray__ArgAssignment_1");
            builder.put((Object)grammarAccess.getFrameAccess().getUnorderedGroup_2(), (Object)"rule__Frame__UnorderedGroup_2");
            builder.put((Object)grammarAccess.getTextAccess().getUnorderedGroup_2(), (Object)"rule__Text__UnorderedGroup_2");
            builder.put((Object)grammarAccess.getGroupAccess().getUnorderedGroup_1(), (Object)"rule__Group__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getImageAccess().getUnorderedGroup_1(), (Object)"rule__Image__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getVideoAccess().getUnorderedGroup_1(), (Object)"rule__Video__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getChartAccess().getUnorderedGroup_1(), (Object)"rule__Chart__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getWebviewAccess().getUnorderedGroup_1(), (Object)"rule__Webview__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getSwitchAccess().getUnorderedGroup_1(), (Object)"rule__Switch__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getMapviewAccess().getUnorderedGroup_1(), (Object)"rule__Mapview__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getSliderAccess().getUnorderedGroup_1(), (Object)"rule__Slider__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getSelectionAccess().getUnorderedGroup_1(), (Object)"rule__Selection__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getListAccess().getUnorderedGroup_1(), (Object)"rule__List__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getSetpointAccess().getUnorderedGroup_1(), (Object)"rule__Setpoint__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getColorpickerAccess().getUnorderedGroup_1(), (Object)"rule__Colorpicker__UnorderedGroup_1");
            builder.put((Object)grammarAccess.getDefaultAccess().getUnorderedGroup_1(), (Object)"rule__Default__UnorderedGroup_1");
        }
    }
}

