/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxFilterCriteria;
import org.eclipse.smarthome.config.discovery.inbox.InboxListener;
import org.eclipse.smarthome.config.discovery.inbox.InboxPredicates;
import org.eclipse.smarthome.config.discovery.inbox.events.InboxEventFactory;
import org.eclipse.smarthome.config.discovery.internal.DiscoveryResultImpl;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingRegistryChangeListener;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={Inbox.class})
public final class PersistentInbox
implements Inbox,
DiscoveryListener,
ThingRegistryChangeListener {
    private final Logger logger = LoggerFactory.getLogger(PersistentInbox.class);
    private final Set<InboxListener> listeners = new CopyOnWriteArraySet<InboxListener>();
    @NonNullByDefault(value={})
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private ManagedThingProvider managedThingProvider;
    @NonNullByDefault(value={})
    private ThingTypeRegistry thingTypeRegistry;
    @NonNullByDefault(value={})
    private ConfigDescriptionRegistry configDescRegistry;
    @NonNullByDefault(value={})
    private StorageService storageService;
    @NonNullByDefault(value={})
    private volatile Storage<DiscoveryResult> discoveryResultStorage;
    private final Map<DiscoveryResult, Class<?>> resultDiscovererMap = new ConcurrentHashMap();
    @NonNullByDefault(value={})
    private ScheduledFuture<?> timeToLiveChecker;
    private @Nullable EventPublisher eventPublisher;
    private final List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();

    @Override
    public @Nullable Thing approve(ThingUID thingUID, @Nullable String label) {
        if (thingUID == null) {
            throw new IllegalArgumentException("Thing UID must not be null");
        }
        List results = this.stream().filter(InboxPredicates.forThingUID(thingUID)).collect(Collectors.toList());
        if (results.isEmpty()) {
            throw new IllegalArgumentException("No Thing with UID " + thingUID.getAsString() + " in inbox");
        }
        DiscoveryResult result = (DiscoveryResult)results.get(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, Object> configParams = new HashMap<String, Object>();
        this.getPropsAndConfigParams(result, properties, configParams);
        Configuration config = new Configuration(configParams);
        ThingTypeUID thingTypeUID = result.getThingTypeUID();
        Thing newThing = ThingFactory.createThing((ThingUID)thingUID, (Configuration)config, properties, (ThingUID)result.getBridgeUID(), (ThingTypeUID)thingTypeUID, this.thingHandlerFactories);
        if (newThing == null) {
            this.logger.warn("Cannot create thing. No binding found that supports creating a thing of type {}.", (Object)thingTypeUID);
            return null;
        }
        if (label != null && !label.isEmpty()) {
            newThing.setLabel(label);
        } else {
            newThing.setLabel(result.getLabel());
        }
        this.addThingSafely(newThing);
        return newThing;
    }

    @Override
    public synchronized boolean add(@Nullable DiscoveryResult discoveryResult) throws IllegalStateException {
        if (discoveryResult == null) {
            return false;
        }
        DiscoveryResult result = discoveryResult;
        ThingUID thingUID = result.getThingUID();
        Thing thing = this.thingRegistry.get(thingUID);
        if (thing == null) {
            DiscoveryResult inboxResult = this.get(thingUID);
            if (inboxResult == null) {
                this.discoveryResultStorage.put(result.getThingUID().toString(), (Object)result);
                this.notifyListeners(result, EventType.added);
                this.logger.info("Added new thing '{}' to inbox.", (Object)thingUID);
                return true;
            }
            if (inboxResult instanceof DiscoveryResultImpl) {
                DiscoveryResultImpl resultImpl = (DiscoveryResultImpl)inboxResult;
                resultImpl.synchronize(result);
                this.discoveryResultStorage.put(result.getThingUID().toString(), (Object)resultImpl);
                this.notifyListeners(resultImpl, EventType.updated);
                this.logger.debug("Updated discovery result for '{}'.", (Object)thingUID);
                return true;
            }
            this.logger.warn("Cannot synchronize result with implementation class '{}'.", (Object)inboxResult.getClass().getName());
        } else {
            this.logger.debug("Discovery result with thing '{}' not added as inbox entry. It is already present as thing in the ThingRegistry.", (Object)thingUID);
            boolean updated = this.synchronizeConfiguration(result.getThingTypeUID(), result.getProperties(), thing.getConfiguration());
            if (updated) {
                this.logger.debug("The configuration for thing '{}' is updated...", (Object)thingUID);
                this.managedThingProvider.update((Identifiable)thing);
            }
        }
        return false;
    }

    private boolean synchronizeConfiguration(ThingTypeUID thingTypeUID, Map<String, Object> properties, Configuration config) {
        boolean configUpdated = false;
        Set<Map.Entry<String, Object>> propertySet = properties.entrySet();
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        List<ConfigDescriptionParameter> configDescParams = this.getConfigDescParams(thingType);
        for (Map.Entry<String, Object> propertyEntry : propertySet) {
            ConfigDescriptionParameter configDescParam;
            Object normalizedValue;
            String propertyKey = propertyEntry.getKey();
            Object propertyValue = propertyEntry.getValue();
            if (!config.containsKey(propertyKey) || Objects.equals(normalizedValue = ConfigUtil.normalizeType((Object)propertyValue, (ConfigDescriptionParameter)(configDescParam = this.getConfigDescriptionParam(configDescParams, propertyKey))), config.get(propertyKey))) continue;
            config.put(propertyKey, normalizedValue);
            configUpdated = true;
        }
        return configUpdated;
    }

    private @Nullable ConfigDescriptionParameter getConfigDescriptionParam(List<ConfigDescriptionParameter> configDescParams, String paramName) {
        for (ConfigDescriptionParameter configDescriptionParameter : configDescParams) {
            if (!configDescriptionParameter.getName().equals(paramName)) continue;
            return configDescriptionParameter;
        }
        return null;
    }

    @Override
    public void addInboxListener(@Nullable InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<DiscoveryResult> get(@Nullable InboxFilterCriteria criteria) throws IllegalStateException {
        ArrayList<DiscoveryResult> filteredEntries = new ArrayList<DiscoveryResult>();
        for (DiscoveryResult discoveryResult : this.discoveryResultStorage.getValues()) {
            if (discoveryResult == null || !this.matchFilter(discoveryResult, criteria)) continue;
            filteredEntries.add(discoveryResult);
        }
        return filteredEntries;
    }

    @Override
    public List<DiscoveryResult> getAll() {
        return this.stream().collect(Collectors.toList());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NonNullByDefault(value={})
    public Stream<DiscoveryResult> stream() {
        Storage<DiscoveryResult> discoveryResultStorage = this.discoveryResultStorage;
        if (discoveryResultStorage == null) {
            ScheduledFuture<?> timeToLiveChecker = this.timeToLiveChecker;
            this.logger.error("The OSGi lifecycle has been violated (storage: {}, ttl checker cancelled: {}).", this.discoveryResultStorage == null ? "null" : this.discoveryResultStorage, timeToLiveChecker == null ? "null" : Boolean.valueOf(timeToLiveChecker.isCancelled()));
            return Stream.empty();
        }
        @Nullable Collection values = discoveryResultStorage.getValues();
        if (values == null) {
            this.logger.warn("The storage service violates the nullness requirements (get values must not return null) (storage class: {}).", discoveryResultStorage.getClass());
            return Stream.empty();
        }
        return values.stream().filter(Objects::nonNull);
    }

    @Override
    public synchronized boolean remove(@Nullable ThingUID thingUID) throws IllegalStateException {
        DiscoveryResult discoveryResult;
        if (thingUID != null && (discoveryResult = this.get(thingUID)) != null) {
            if (!this.isInRegistry(thingUID)) {
                this.removeResultsForBridge(thingUID);
            }
            this.resultDiscovererMap.remove(discoveryResult);
            this.discoveryResultStorage.remove(thingUID.toString());
            this.notifyListeners(discoveryResult, EventType.removed);
            return true;
        }
        return false;
    }

    @Override
    public void removeInboxListener(@Nullable InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        if (this.add(result)) {
            this.resultDiscovererMap.put(result, source.getClass());
        }
    }

    @Override
    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        this.remove(thingUID);
    }

    @Override
    public @Nullable Collection<ThingUID> removeOlderResults(DiscoveryService source, long timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        HashSet<ThingUID> removedThings = new HashSet<ThingUID>();
        for (DiscoveryResult discoveryResult : this.getAll()) {
            Class<?> discoverer = this.resultDiscovererMap.get(discoveryResult);
            if (thingTypeUIDs == null || !thingTypeUIDs.contains(discoveryResult.getThingTypeUID()) || discoveryResult.getTimestamp() >= timestamp || discoverer != null && source.getClass() != discoverer) continue;
            ThingUID thingUID = discoveryResult.getThingUID();
            if (bridgeUID != null && !bridgeUID.equals((Object)discoveryResult.getBridgeUID())) continue;
            removedThings.add(thingUID);
            this.remove(thingUID);
            this.logger.debug("Removed {} from inbox because it was older than {}", (Object)thingUID, (Object)new Date(timestamp));
        }
        return removedThings;
    }

    public void added(Thing thing) {
        if (this.remove(thing.getUID())) {
            this.logger.debug("Discovery result removed from inbox, because it was added as a Thing to the ThingRegistry.");
        }
    }

    public void removed(Thing thing) {
        if (thing instanceof Bridge) {
            this.removeResultsForBridge(thing.getUID());
        }
    }

    public void updated(Thing oldThing, Thing thing) {
    }

    @Override
    public void setFlag(ThingUID thingUID, @Nullable DiscoveryResultFlag flag) {
        DiscoveryResult result = this.get(thingUID);
        if (result instanceof DiscoveryResultImpl) {
            DiscoveryResultImpl resultImpl = (DiscoveryResultImpl)result;
            resultImpl.setFlag(flag == null ? DiscoveryResultFlag.NEW : flag);
            this.discoveryResultStorage.put(resultImpl.getThingUID().toString(), (Object)resultImpl);
            this.notifyListeners(resultImpl, EventType.updated);
        } else {
            this.logger.warn("Cannot set flag for result of instance type '{}'", (Object)result.getClass().getName());
        }
    }

    private @Nullable DiscoveryResult get(ThingUID thingUID) {
        if (thingUID != null) {
            return (DiscoveryResult)this.discoveryResultStorage.get(thingUID.toString());
        }
        return null;
    }

    private boolean matchFilter(DiscoveryResult discoveryResult, @Nullable InboxFilterCriteria criteria) {
        if (criteria != null) {
            String bindingId = criteria.getBindingId();
            if (bindingId != null && !bindingId.isEmpty() && !discoveryResult.getBindingId().equals(bindingId)) {
                return false;
            }
            ThingTypeUID thingTypeUID = criteria.getThingTypeUID();
            if (thingTypeUID != null && !discoveryResult.getThingTypeUID().equals((Object)thingTypeUID)) {
                return false;
            }
            ThingUID thingUID = criteria.getThingUID();
            if (thingUID != null && !discoveryResult.getThingUID().equals((Object)thingUID)) {
                return false;
            }
            DiscoveryResultFlag flag = criteria.getFlag();
            if (flag != null && discoveryResult.getFlag() != flag) {
                return false;
            }
        }
        return true;
    }

    private void notifyListeners(DiscoveryResult result, EventType type) {
        DiscoveryResult resultForEvent;
        for (InboxListener listener : this.listeners) {
            try {
                switch (type) {
                    case added: {
                        listener.thingAdded(this, result);
                        break;
                    }
                    case removed: {
                        listener.thingRemoved(this, result);
                        break;
                    }
                    case updated: {
                        listener.thingUpdated(this, result);
                    }
                }
            }
            catch (Exception ex) {
                String errorMessage = String.format("Cannot notify the InboxListener '%s' about a Thing %s event!", listener.getClass().getName(), type.name());
                this.logger.error(errorMessage, (Throwable)ex);
            }
        }
        if (type == EventType.removed) {
            resultForEvent = result;
        } else {
            resultForEvent = this.get(result.getThingUID());
            if (resultForEvent == null) {
                return;
            }
        }
        this.postEvent(resultForEvent, type);
    }

    private void postEvent(DiscoveryResult result, EventType eventType) {
        if (this.eventPublisher != null) {
            try {
                switch (eventType) {
                    case added: {
                        this.eventPublisher.post((Event)InboxEventFactory.createAddedEvent(result));
                        break;
                    }
                    case removed: {
                        this.eventPublisher.post((Event)InboxEventFactory.createRemovedEvent(result));
                        break;
                    }
                    case updated: {
                        this.eventPublisher.post((Event)InboxEventFactory.createUpdatedEvent(result));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not post event of type '{}'.", (Object)eventType.name(), (Object)ex);
            }
        }
    }

    private boolean isInRegistry(ThingUID thingUID) {
        return this.thingRegistry.get(thingUID) != null;
    }

    private void removeResultsForBridge(ThingUID bridgeUID) {
        for (ThingUID thingUID : this.getResultsForBridge(bridgeUID)) {
            DiscoveryResult discoveryResult = this.get(thingUID);
            if (discoveryResult == null) continue;
            this.discoveryResultStorage.remove(thingUID.toString());
            this.notifyListeners(discoveryResult, EventType.removed);
        }
    }

    private List<ThingUID> getResultsForBridge(ThingUID bridgeUID) {
        ArrayList<ThingUID> thingsForBridge = new ArrayList<ThingUID>();
        for (DiscoveryResult result : this.discoveryResultStorage.getValues()) {
            if (!bridgeUID.equals((Object)result.getBridgeUID())) continue;
            thingsForBridge.add(result.getThingUID());
        }
        return thingsForBridge;
    }

    private void getPropsAndConfigParams(DiscoveryResult discoveryResult, Map<String, String> props, Map<String, Object> configParams) {
        List<ConfigDescriptionParameter> configDescParams = this.getConfigDescParams(discoveryResult);
        Set<String> paramNames = this.getConfigDescParamNames(configDescParams);
        Map<String, Object> resultProps = discoveryResult.getProperties();
        for (String resultKey : resultProps.keySet()) {
            if (paramNames.contains(resultKey)) {
                ConfigDescriptionParameter param = this.getConfigDescriptionParam(configDescParams, resultKey);
                Object normalizedValue = ConfigUtil.normalizeType((Object)resultProps.get(resultKey), (ConfigDescriptionParameter)param);
                configParams.put(resultKey, normalizedValue);
                continue;
            }
            props.put(resultKey, String.valueOf(resultProps.get(resultKey)));
        }
    }

    private Set<String> getConfigDescParamNames(List<ConfigDescriptionParameter> configDescParams) {
        HashSet<String> paramNames = new HashSet<String>();
        if (configDescParams != null) {
            for (ConfigDescriptionParameter param : configDescParams) {
                paramNames.add(param.getName());
            }
        }
        return paramNames;
    }

    private List<ConfigDescriptionParameter> getConfigDescParams(DiscoveryResult discoveryResult) {
        ThingType thingType = this.thingTypeRegistry.getThingType(discoveryResult.getThingTypeUID());
        return this.getConfigDescParams(thingType);
    }

    private List<ConfigDescriptionParameter> getConfigDescParams(ThingType thingType) {
        URI descURI;
        ConfigDescription desc;
        if (thingType != null && thingType.getConfigDescriptionURI() != null && (desc = this.configDescRegistry.getConfigDescription(descURI = thingType.getConfigDescriptionURI())) != null) {
            return desc.getParameters();
        }
        return Collections.emptyList();
    }

    private void addThingSafely(Thing thing) {
        ThingUID thingUID = thing.getUID();
        if (this.thingRegistry.get(thingUID) != null) {
            this.thingRegistry.remove(thingUID);
        }
        this.thingRegistry.add((Identifiable)thing);
    }

    protected void activate(ComponentContext componentContext) {
        this.timeToLiveChecker = ThreadPoolManager.getScheduledPool((String)"discovery").scheduleWithFixedDelay(new TimeToLiveCheckingThread(this), 0L, 30L, TimeUnit.SECONDS);
        this.discoveryServiceRegistry.addDiscoveryListener(this);
    }

    void setTimeToLiveCheckingInterval(int interval) {
        this.timeToLiveChecker.cancel(true);
        this.timeToLiveChecker = ThreadPoolManager.getScheduledPool((String)"discovery").scheduleWithFixedDelay(new TimeToLiveCheckingThread(this), 0L, interval, TimeUnit.SECONDS);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.discoveryServiceRegistry.removeDiscoveryListener(this);
        this.listeners.clear();
        this.timeToLiveChecker.cancel(true);
    }

    @Reference
    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
        this.thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    @Reference
    protected void setManagedThingProvider(ManagedThingProvider thingProvider) {
        this.managedThingProvider = thingProvider;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.thingRegistry = null;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider thingProvider) {
        this.managedThingProvider = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setStorageService(StorageService storageService) {
        if (this.storageService != storageService) {
            this.storageService = storageService;
            this.discoveryResultStorage = storageService.getStorage(DiscoveryResult.class.getName(), this.getClass().getClassLoader());
        }
    }

    protected void unsetStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
            this.discoveryResultStorage = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    private static enum EventType {
        added,
        removed,
        updated;

    }

    private class TimeToLiveCheckingThread
    implements Runnable {
        private final PersistentInbox inbox;

        public TimeToLiveCheckingThread(PersistentInbox inbox) {
            this.inbox = inbox;
        }

        @Override
        public void run() {
            long now = new Date().getTime();
            for (DiscoveryResult result : this.inbox.getAll()) {
                if (!this.isResultExpired(result, now)) continue;
                PersistentInbox.this.logger.debug("Inbox entry for thing {} is expired and will be removed", (Object)result.getThingUID());
                PersistentInbox.this.remove(result.getThingUID());
            }
        }

        private boolean isResultExpired(DiscoveryResult result, long now) {
            if (result.getTimeToLive() == -1L) {
                return false;
            }
            return result.getTimestamp() + result.getTimeToLive() * 1000L < now;
        }
    }
}

