/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.core.dto.ActionTypeDTOMapper;
import org.eclipse.smarthome.automation.core.dto.ConditionTypeDTOMapper;
import org.eclipse.smarthome.automation.core.dto.TriggerTypeDTOMapper;
import org.eclipse.smarthome.automation.dto.CompositeActionTypeDTO;
import org.eclipse.smarthome.automation.dto.CompositeConditionTypeDTO;
import org.eclipse.smarthome.automation.dto.CompositeTriggerTypeDTO;
import org.eclipse.smarthome.automation.dto.ModuleTypeDTO;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.parser.gson.internal.AbstractGSONParser;
import org.eclipse.smarthome.automation.parser.gson.internal.ModuleTypeParsingContainer;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.TriggerType;

public class ModuleTypeGSONParser
extends AbstractGSONParser<ModuleType> {
    public Set<ModuleType> parse(InputStreamReader reader) throws ParsingException {
        try {
            ModuleTypeParsingContainer mtContainer = (ModuleTypeParsingContainer)gson.fromJson((Reader)reader, ModuleTypeParsingContainer.class);
            HashSet<ModuleType> result = new HashSet<ModuleType>();
            this.addAll(result, mtContainer.triggers);
            this.addAll(result, mtContainer.conditions);
            this.addAll(result, mtContainer.actions);
            return result;
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(1, null, (Throwable)e));
        }
    }

    @Override
    public void serialize(Set<ModuleType> dataObjects, OutputStreamWriter writer) throws Exception {
        Map<String, List<? extends ModuleType>> map = this.createMapByType(dataObjects);
        gson.toJson(map, (Appendable)writer);
    }

    private void addAll(Set<ModuleType> result, List<? extends ModuleTypeDTO> moduleTypes) {
        if (moduleTypes != null) {
            for (ModuleTypeDTO moduleTypeDTO : moduleTypes) {
                if (moduleTypeDTO instanceof CompositeTriggerTypeDTO) {
                    result.add((ModuleType)TriggerTypeDTOMapper.map((CompositeTriggerTypeDTO)((CompositeTriggerTypeDTO)moduleTypeDTO)));
                    continue;
                }
                if (moduleTypeDTO instanceof CompositeConditionTypeDTO) {
                    result.add((ModuleType)ConditionTypeDTOMapper.map((CompositeConditionTypeDTO)((CompositeConditionTypeDTO)moduleTypeDTO)));
                    continue;
                }
                if (!(moduleTypeDTO instanceof CompositeActionTypeDTO)) continue;
                result.add((ModuleType)ActionTypeDTOMapper.map((CompositeActionTypeDTO)((CompositeActionTypeDTO)moduleTypeDTO)));
            }
        }
    }

    private Map<String, List<? extends ModuleType>> createMapByType(Set<ModuleType> dataObjects) {
        HashMap<String, List<? extends ModuleType>> map = new HashMap<String, List<? extends ModuleType>>();
        ArrayList<TriggerType> triggers = new ArrayList<TriggerType>();
        ArrayList<ConditionType> conditions = new ArrayList<ConditionType>();
        ArrayList<ActionType> actions = new ArrayList<ActionType>();
        for (ModuleType moduleType : dataObjects) {
            if (moduleType instanceof TriggerType) {
                triggers.add((TriggerType)moduleType);
                continue;
            }
            if (moduleType instanceof ConditionType) {
                conditions.add((ConditionType)moduleType);
                continue;
            }
            if (!(moduleType instanceof ActionType)) continue;
            actions.add((ActionType)moduleType);
        }
        map.put("triggers", triggers);
        map.put("conditions", conditions);
        map.put("actions", actions);
        return map;
    }
}

