/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.javasound.internal;

import java.io.IOException;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioStream;

public class JavaSoundInputStream
extends AudioStream {
    private final TargetDataLine input;
    private final AudioFormat format;

    public JavaSoundInputStream(TargetDataLine input, AudioFormat format) {
        this.format = format;
        this.input = input;
        this.input.start();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int bytesRead = this.read(b);
        if (-1 == bytesRead) {
            return bytesRead;
        }
        Byte bb = new Byte(b[0]);
        return bb.intValue();
    }

    public int read(byte[] b) throws IOException {
        return this.input.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    public void close() throws IOException {
        this.input.close();
    }

    public AudioFormat getFormat() {
        return this.format;
    }
}

