/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private final Logger logger = LoggerFactory.getLogger(TestServer.class);
    private Server server;
    private final String host;
    private final int port;
    private final int timeout;
    private final ServletHolder servletHolder;

    public TestServer(String host, int port, int timeout, ServletHolder servletHolder) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.servletHolder = servletHolder;
    }

    public CompletableFuture<Boolean> startServer() {
        final CompletableFuture<Boolean> serverStarted = new CompletableFuture<Boolean>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TestServer.this.server = new Server();
                ServletHandler handler = new ServletHandler();
                handler.addServletWithMapping(TestServer.this.servletHolder, "/*");
                TestServer.this.server.setHandler((Handler)handler);
                ServerConnector http = new ServerConnector(TestServer.this.server);
                http.setHost(TestServer.this.host);
                http.setPort(TestServer.this.port);
                http.setIdleTimeout((long)TestServer.this.timeout);
                TestServer.this.server.addConnector((Connector)http);
                try {
                    TestServer.this.server.start();
                    serverStarted.complete(true);
                    TestServer.this.server.join();
                }
                catch (InterruptedException ex) {
                    TestServer.this.logger.error("Server got interrupted", (Throwable)ex);
                    serverStarted.completeExceptionally(ex);
                    return;
                }
                catch (Exception e) {
                    TestServer.this.logger.error("Error in starting the server", (Throwable)e);
                    serverStarted.completeExceptionally(e);
                    return;
                }
            }
        });
        thread.start();
        return serverStarted;
    }

    public void stopServer() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.logger.error("Error in stopping the server", (Throwable)e);
            return;
        }
    }
}

