/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.mqttembeddedbroker.internal;

import io.moquette.server.Server;
import io.moquette.server.config.IConfig;
import io.moquette.server.config.MemoryConfig;
import io.moquette.spi.security.IAuthorizator;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.config.core.ConfigurableService;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.io.mqttembeddedbroker.internal.EmbeddedBrokerService;
import org.eclipse.smarthome.io.mqttembeddedbroker.internal.MqttEmbeddedBrokerDetectStart;
import org.eclipse.smarthome.io.mqttembeddedbroker.internal.MqttEmbeddedBrokerMetrics;
import org.eclipse.smarthome.io.mqttembeddedbroker.internal.MqttEmbeddedBrokerUserAuthenticator;
import org.eclipse.smarthome.io.mqttembeddedbroker.internal.ServiceConfiguration;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.eclipse.smarthome.io.transport.mqtt.MqttServiceObserver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EmbeddedBrokerService.class}, configurationPid="org.eclipse.smarthome.mqttembeddedbroker", property={"service.pid=org.eclipse.smarthome.mqttembeddedbroker", "service.config.description.uri=mqtt:mqttembeddedbroker", "service.config.category=MQTT", "service.config.label=MQTT Embedded Broker"})
@NonNullByDefault
public class EmbeddedBrokerServiceImpl
implements EmbeddedBrokerService,
ConfigurableService,
MqttConnectionObserver,
MqttServiceObserver,
MqttEmbeddedBrokerDetectStart.MqttEmbeddedBrokerStartedListener {
    private @Nullable MqttService service;
    protected @Nullable Server server;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedBrokerServiceImpl.class);
    protected MqttEmbeddedBrokerDetectStart detectStart = new MqttEmbeddedBrokerDetectStart(this);
    protected MqttEmbeddedBrokerMetrics metrics = new MqttEmbeddedBrokerMetrics(new BrokerMetricsListenerEx());
    private @Nullable MqttBrokerConnection connection;

    @Reference
    public void setMqttService(MqttService service) {
        this.service = service;
    }

    public void unsetMqttService(MqttService service) {
        this.service = service;
    }

    @Activate
    public void activate(Map<String, Object> data) throws IOException {
        this.initialize((ServiceConfiguration)new Configuration(data).as(ServiceConfiguration.class));
    }

    public void initialize(ServiceConfiguration config) throws IOException {
        int port = config.port == null ? (config.port = Integer.valueOf(config.secure != false ? 8883 : 1883)) : config.port;
        this.connection = this.service.getBrokerConnection("embedded-mqtt-broker");
        if (this.connection != null) {
            this.connection.stop();
            this.service.removeBrokerConnection("embedded-mqtt-broker");
        }
        this.connection = new MqttBrokerConnection("127.0.0.1", config.port, config.secure.booleanValue(), "embedded-mqtt-broker");
        this.connection.addConnectionObserver((MqttConnectionObserver)this);
        if (config.username != null) {
            this.connection.setCredentials(config.username, config.password);
        }
        this.startEmbeddedServer(port, config.secure, config.username, config.password, config.persistenceFile);
    }

    @Deactivate
    public void deactivate() {
        MqttBrokerConnection connection;
        if (this.service != null) {
            this.service.removeBrokersListener((MqttServiceObserver)this);
        }
        if ((connection = this.connection) == null) {
            if (this.server != null) {
                this.server.stopServer();
            }
            this.server = null;
            return;
        }
        connection.removeConnectionObserver((MqttConnectionObserver)this);
        try {
            ((CompletableFuture)connection.stop().thenRun(() -> {
                if (this.server != null) {
                    this.server.stopServer();
                    this.server = null;
                }
            })).get(300L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
        connection = null;
    }

    public void brokerAdded(String brokerID, MqttBrokerConnection broker) {
    }

    public void brokerRemoved(String brokerID, MqttBrokerConnection broker) {
        if (broker == this.connection) {
            this.service.addBrokerConnection(brokerID, broker);
        }
    }

    @Override
    public void startEmbeddedServer(@Nullable Integer portParam, boolean secure, @Nullable String username, @Nullable String password, String persistenceFilenameParam) throws IOException {
        int port;
        String persistenceFilename = persistenceFilenameParam;
        Server server = new Server();
        Properties properties = new Properties();
        properties.put("host", "0.0.0.0");
        if (secure) {
            port = portParam == null ? (port = 8883) : portParam;
            properties.put("ssl_port", Integer.toString(port));
            properties.put("port", "disabled");
            properties.put("key_manager_password", "esheshesh");
        } else {
            port = portParam == null ? (port = 1883) : portParam;
            properties.put("port", Integer.toString(port));
        }
        MqttEmbeddedBrokerUserAuthenticator authentificator = null;
        if (username != null && password != null && username.length() > 0 && password.length() > 0) {
            properties.put("allow_anonymous", (Object)false);
            properties.put("authenticator_class", MqttEmbeddedBrokerUserAuthenticator.class.getName());
            authentificator = new MqttEmbeddedBrokerUserAuthenticator(username, password.getBytes());
        } else {
            properties.put("allow_anonymous", (Object)true);
        }
        if (!persistenceFilename.isEmpty()) {
            if (!Paths.get(persistenceFilename, new String[0]).isAbsolute()) {
                persistenceFilename = Paths.get(ConfigConstants.getUserDataFolder(), new String[0]).toAbsolutePath().resolve(persistenceFilename).toString();
            }
            properties.put("persistent_store", persistenceFilename);
        }
        IAuthorizator authorizer = null;
        server.startServer((IConfig)new MemoryConfig(properties), null, null, authentificator, authorizer);
        this.server = server;
        this.metrics.setServer(server);
        ScheduledThreadPoolExecutor s = new ScheduledThreadPoolExecutor(1);
        this.detectStart.startBrokerStartedDetection(port, s);
    }

    @Override
    public void stopEmbeddedServer() {
        if (this.server != null) {
            this.server.stopServer();
            this.server = null;
        }
        this.detectStart.stopBrokerStartDetection();
        this.metrics.resetServer();
    }

    protected boolean serverConfirmsEmbeddedClient() {
        return this.server != null && this.server.getConnectionsManager().isConnected("embedded-mqtt-broker");
    }

    public void connectionStateChanged(MqttConnectionState state, @Nullable Throwable error) {
        if (state == MqttConnectionState.CONNECTED) {
            this.logger.debug("Embedded broker connection connected");
        } else if (error == null) {
            this.logger.warn("Embedded broker offline - Reason unknown");
        } else {
            this.logger.warn("Embedded broker offline", error);
        }
        if (state != MqttConnectionState.CONNECTED && state != MqttConnectionState.CONNECTING) {
            this.stopEmbeddedServer();
        }
    }

    @Override
    public void mqttEmbeddedBrokerStarted(boolean timeout) {
        MqttBrokerConnection connection = this.connection;
        MqttService service = this.service;
        if (connection == null || service == null) {
            return;
        }
        service.addBrokerConnection("embedded-mqtt-broker", connection);
        ((CompletableFuture)connection.start().exceptionally(e -> {
            this.connectionStateChanged(MqttConnectionState.DISCONNECTED, (Throwable)e);
            return false;
        })).thenAccept(v -> {
            if (!v.booleanValue()) {
                this.connectionStateChanged(MqttConnectionState.DISCONNECTED, new TimeoutException("Timeout"));
            }
        });
    }

    @Override
    public @Nullable MqttBrokerConnection getConnection() {
        return this.connection;
    }

    @NonNullByDefault(value={})
    class BrokerMetricsListenerEx
    implements MqttEmbeddedBrokerMetrics.BrokerMetricsListener {
        BrokerMetricsListenerEx() {
        }

        @Override
        public void connectedClientIDs(Collection<String> clientIDs) {
            EmbeddedBrokerServiceImpl.this.logger.debug("Connected clients: {}", (Object)clientIDs.stream().collect(Collectors.joining(", ")));
        }
    }
}

