/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.smarthome.binding.tradfri.internal.CoapCallback;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriCoapClient
extends CoapClient {
    private static final int TIMEOUT = 2000;
    private static final int DEFAULT_DELAY_MILLIS = 600;
    private final Logger logger = LoggerFactory.getLogger(TradfriCoapClient.class);
    private final LinkedList<PayloadCallbackPair> commandsQueue = new LinkedList();
    private Future<?> job;

    public TradfriCoapClient(URI uri) {
        super(uri);
        this.setTimeout(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands() {
        while (true) {
            try {
                while (true) {
                    LinkedList<PayloadCallbackPair> linkedList = this.commandsQueue;
                    synchronized (linkedList) {
                        PayloadCallbackPair payloadCallbackPair = this.commandsQueue.poll();
                        if (payloadCallbackPair == null) {
                            return;
                        }
                        this.logger.debug("CoAP PUT request\nuri: {}\npayload: {}", (Object)this.getURI(), (Object)payloadCallbackPair.payload);
                        this.put(new TradfriCoapHandler(payloadCallbackPair.callback), payloadCallbackPair.payload, 0);
                    }
                    Thread.sleep(600L);
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("commandExecutorThread was interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public CoapObserveRelation startObserve(CoapCallback callback) {
        return this.observe(new TradfriCoapHandler(callback));
    }

    public CompletableFuture<String> asyncGet() {
        this.logger.debug("CoAP GET request\nuri: {}", (Object)this.getURI());
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.get(new TradfriCoapHandler(future));
        return future;
    }

    public void asyncGet(CoapCallback callback) {
        this.logger.debug("CoAP GET request\nuri: {}", (Object)this.getURI());
        this.get(new TradfriCoapHandler(callback));
    }

    public void asyncPut(String payload, CoapCallback callback, ScheduledExecutorService scheduler) {
        this.asyncPut(new PayloadCallbackPair(payload, callback), scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncPut(PayloadCallbackPair payloadCallbackPair, ScheduledExecutorService scheduler) {
        LinkedList<PayloadCallbackPair> linkedList = this.commandsQueue;
        synchronized (linkedList) {
            if (this.commandsQueue.isEmpty()) {
                this.commandsQueue.offer(payloadCallbackPair);
                if (this.job == null || this.job.isDone()) {
                    this.job = scheduler.submit(() -> this.executeCommands());
                }
            } else {
                this.commandsQueue.offer(payloadCallbackPair);
            }
        }
    }

    public void shutdown() {
        if (this.job != null) {
            this.job.cancel(true);
        }
        super.shutdown();
    }

    public final class PayloadCallbackPair {
        public final String payload;
        public final CoapCallback callback;

        public PayloadCallbackPair(String payload, CoapCallback callback) {
            this.payload = payload;
            this.callback = callback;
        }
    }
}

