/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal.discovery;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.binding.tradfri.TradfriBindingConstants;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriGatewayHandler;
import org.eclipse.smarthome.binding.tradfri.internal.DeviceUpdateListener;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriDiscoveryService
extends AbstractDiscoveryService
implements DeviceUpdateListener {
    private final Logger logger = LoggerFactory.getLogger(TradfriDiscoveryService.class);
    private final TradfriGatewayHandler handler;
    private static final String REMOTE_CONTROLLER_MODEL = "TRADFRI remote control";
    private static final String[] COLOR_TEMP_MODELS = new String[]{"TRADFRI bulb E27 WS opal 980lm", "TRADFRI bulb E27 WS clear 950lm", "TRADFRI bulb GU10 WS 400lm", "TRADFRI bulb E14 WS opal 400lm", "FLOALT panel WS 30x30", "FLOALT panel WS 60x60", "FLOALT panel WS 30x90", "TRADFRI bulb E12 WS opal 400lm"};
    private static final String COLOR_MODELS_IDENTIFIER = "CWS";

    public TradfriDiscoveryService(TradfriGatewayHandler bridgeHandler) {
        super(Stream.concat(TradfriBindingConstants.SUPPORTED_LIGHT_TYPES_UIDS.stream(), TradfriBindingConstants.SUPPORTED_CONTROLLER_TYPES_UIDS.stream()).collect(Collectors.toSet()), 10, true);
        this.handler = bridgeHandler;
    }

    protected void startScan() {
        this.handler.startScan();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    public void activate() {
        this.handler.registerDeviceUpdateListener(this);
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime());
        this.handler.unregisterDeviceUpdateListener(this);
    }

    @Override
    public void onUpdate(String instanceId, JsonObject data) {
        ThingUID bridge = this.handler.getThing().getUID();
        try {
            if (data.has("9003")) {
                ThingTypeUID thingType;
                int id = data.get("9003").getAsInt();
                String type = data.get("5750").getAsString();
                JsonObject deviceInfo = data.get("3").getAsJsonObject();
                String model = deviceInfo.get("1").getAsString();
                ThingUID thingId = null;
                if ("2".equals(type) && data.has("3311")) {
                    JsonObject state = data.get("3311").getAsJsonArray().get(0).getAsJsonObject();
                    ThingTypeUID thingType2 = null;
                    if (model != null && model.contains(COLOR_MODELS_IDENTIFIER)) {
                        thingType2 = TradfriBindingConstants.THING_TYPE_COLOR_LIGHT;
                    }
                    if (thingType2 == null && (state.has("5706") || model != null && Arrays.asList(COLOR_TEMP_MODELS).contains(model))) {
                        thingType2 = TradfriBindingConstants.THING_TYPE_COLOR_TEMP_LIGHT;
                    }
                    if (thingType2 == null) {
                        thingType2 = TradfriBindingConstants.THING_TYPE_DIMMABLE_LIGHT;
                    }
                    thingId = new ThingUID(thingType2, bridge, Integer.toString(id));
                } else if ("3".equals(type) && data.has("3312")) {
                    thingType = TradfriBindingConstants.THING_TYPE_ONOFF_PLUG;
                    thingId = new ThingUID(thingType, bridge, Integer.toString(id));
                } else if ("0".equals(type) && data.has("15009")) {
                    thingType = model != null && REMOTE_CONTROLLER_MODEL.equals(model) ? TradfriBindingConstants.THING_TYPE_REMOTE_CONTROL : TradfriBindingConstants.THING_TYPE_DIMMER;
                    thingId = new ThingUID(thingType, bridge, Integer.toString(id));
                } else if ("4".equals(type) && data.has("3300")) {
                    thingId = new ThingUID(TradfriBindingConstants.THING_TYPE_MOTION_SENSOR, bridge, Integer.toString(id));
                }
                if (thingId == null) {
                    this.logger.debug("Ignoring unknown device on TRADFRI gateway:\n\ttype : {}\n\tmodel: {}\n\tinfo : {}", new Object[]{type, model, deviceInfo.getAsString()});
                    return;
                }
                String label = data.get("9001").getAsString();
                HashMap<String, Object> properties = new HashMap<String, Object>(1);
                properties.put("id", id);
                properties.put("modelId", model);
                if (deviceInfo.get("0") != null) {
                    properties.put("vendor", deviceInfo.get("0").getAsString());
                }
                if (deviceInfo.get("3") != null) {
                    properties.put("firmwareVersion", deviceInfo.get("3").getAsString());
                }
                this.logger.debug("Adding device {} to inbox", (Object)thingId);
                DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingId).withBridge(bridge).withLabel(label).withProperties(properties).withRepresentationProperty("id").build();
                this.thingDiscovered(discoveryResult);
            }
        }
        catch (JsonSyntaxException e) {
            this.logger.debug("JSON error during discovery: {}", (Object)e.getMessage());
        }
    }
}

