/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.security.RolesAllowed;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.io.rest.sse.internal.SseEventOutput;
import org.eclipse.smarthome.io.rest.sse.internal.util.SseUtil;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;
import org.osgi.service.component.annotations.Component;

@Path(value="events")
@RolesAllowed(value={"user"})
@Singleton
@Api(value="events", hidden=true)
@Component(immediate=true, service={SseResource.class})
public class SseResource {
    public static final String PATH_EVENTS = "events";
    private static final String X_ACCEL_BUFFERING_HEADER = "X-Accel-Buffering";
    private final SseBroadcaster broadcaster;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletResponse response;
    @Context
    private HttpServletRequest request;

    public SseResource() {
        this.broadcaster = new SseBroadcaster();
    }

    @GET
    @Produces(value={"text/event-stream"})
    @ApiOperation(value="Get all events.", response=EventOutput.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Topic is empty or contains invalid characters")})
    public Object getEvents(@QueryParam(value="topics") @ApiParam(value="topics") String eventFilter) throws IOException, InterruptedException {
        if (!SseUtil.isValidTopicFilter(eventFilter)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SseEventOutput eventOutput = new SseEventOutput(eventFilter);
        this.broadcaster.add((ChunkedOutput)eventOutput);
        this.response.addHeader(X_ACCEL_BUFFERING_HEADER, "no");
        if (!SseUtil.SERVLET3_SUPPORT) {
            this.response.addHeader("Content-Encoding", "identity");
            this.response.setStatus(200);
            this.response.setContentType("text/event-stream");
            this.response.flushBuffer();
            SseUtil.enableBlockingSse();
        }
        return eventOutput;
    }

    public void broadcastEvent(final Event event) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                SseResource.this.broadcaster.broadcast((Object)SseUtil.buildEvent(event));
            }
        });
    }
}

