/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={AutoUpdateManager.class}, configurationPid="org.eclipse.smarthome.autoupdate", configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class AutoUpdateManager {
    private static final String AUTOUPDATE_KEY = "autoupdate";
    protected static final String EVENT_SOURCE = "org.eclipse.smarthome.core.autoupdate";
    protected static final String EVENT_SOURCE_OPTIMISTIC = "org.eclipse.smarthome.core.autoupdate.optimistic";
    protected static final String PROPERTY_ENABLED = "enabled";
    protected static final String PROPERTY_SEND_OPTIMISTIC_UPDATES = "sendOptimisticUpdates";
    private final Logger logger = LoggerFactory.getLogger(AutoUpdateManager.class);
    @NonNullByDefault(value={})
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private EventPublisher eventPublisher;
    @NonNullByDefault(value={})
    private MetadataRegistry metadataRegistry;
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;
    private boolean enabled = true;
    private boolean sendOptimisticUpdates = false;

    @Activate
    protected void activate(Map<String, @Nullable Object> configuration) {
        this.modified(configuration);
    }

    @Modified
    protected void modified(Map<String, @Nullable Object> configuration) {
        Object valueSendOptimisticUpdates;
        Object valueEnabled = configuration.get(PROPERTY_ENABLED);
        if (valueEnabled != null) {
            this.enabled = Boolean.parseBoolean(valueEnabled.toString());
        }
        if ((valueSendOptimisticUpdates = configuration.get(PROPERTY_SEND_OPTIMISTIC_UPDATES)) != null) {
            this.sendOptimisticUpdates = Boolean.parseBoolean(valueSendOptimisticUpdates.toString());
        }
    }

    public void receiveCommand(ItemCommandEvent commandEvent, Item item) {
        if (!this.enabled) {
            return;
        }
        String itemName = commandEvent.getItemName();
        Command command = commandEvent.getItemCommand();
        if (command instanceof State) {
            State state = (State)command;
            Recommendation autoUpdate = this.shouldAutoUpdate(itemName);
            MetadataKey key = new MetadataKey(AUTOUPDATE_KEY, itemName);
            Metadata metadata = (Metadata)this.metadataRegistry.get((Object)key);
            if (metadata != null && !metadata.getValue().trim().isEmpty()) {
                boolean override = Boolean.parseBoolean(metadata.getValue());
                if (override) {
                    this.logger.trace("Auto update strategy {} overriden by item metadata to REQUIRED", (Object)autoUpdate);
                    autoUpdate = Recommendation.REQUIRED;
                } else {
                    this.logger.trace("Auto update strategy {} overriden by item metadata to DONT", (Object)autoUpdate);
                    autoUpdate = Recommendation.DONT;
                }
            }
            switch (autoUpdate) {
                case REQUIRED: {
                    this.logger.trace("Automatically updating item '{}' because no channel is linked", (Object)itemName);
                    this.postUpdate(item, state, EVENT_SOURCE);
                    break;
                }
                case RECOMMENDED: {
                    this.logger.trace("Automatically updating item '{}' because no channel does it", (Object)itemName);
                    this.postUpdate(item, state, EVENT_SOURCE);
                    break;
                }
                case OPTIMISTIC: {
                    this.logger.trace("Optimistically updating item '{}'", (Object)itemName);
                    this.postPrediction(item, state, false);
                    if (!this.sendOptimisticUpdates) break;
                    this.postUpdate(item, state, EVENT_SOURCE_OPTIMISTIC);
                    break;
                }
                case DONT: {
                    this.logger.trace("Won't update item '{}' as it was vetoed.", (Object)itemName);
                    break;
                }
                case REVERT: {
                    this.logger.trace("Sending current item state to revert controls '{}'", (Object)itemName);
                    this.postPrediction(item, item.getState(), true);
                }
            }
        }
    }

    private Recommendation shouldAutoUpdate(String itemName) {
        Thing thing;
        Recommendation ret = Recommendation.REQUIRED;
        ArrayList<ChannelUID> linkedChannelUIDs = new ArrayList<ChannelUID>();
        for (ItemChannelLink link : this.itemChannelLinkRegistry.getAll()) {
            if (!link.getItemName().equals(itemName)) continue;
            linkedChannelUIDs.add(link.getLinkedUID());
        }
        ArrayList<ChannelUID> onlineChannelUIDs = new ArrayList<ChannelUID>();
        for (ChannelUID channelUID : linkedChannelUIDs) {
            thing = this.thingRegistry.get(channelUID.getThingUID());
            if (thing == null || thing.getChannel(channelUID.getId()) == null || thing.getHandler() == null || !ThingStatus.ONLINE.equals((Object)thing.getStatus())) continue;
            onlineChannelUIDs.add(channelUID);
        }
        if (!linkedChannelUIDs.isEmpty() && onlineChannelUIDs.isEmpty()) {
            return Recommendation.REVERT;
        }
        block7: for (ChannelUID channelUID : onlineChannelUIDs) {
            thing = this.thingRegistry.get(channelUID.getThingUID());
            if (thing == null) continue;
            AutoUpdatePolicy policy = AutoUpdatePolicy.DEFAULT;
            Channel channel = thing.getChannel(channelUID.getId());
            if (channel != null) {
                AutoUpdatePolicy channelpolicy = channel.getAutoUpdatePolicy();
                if (channelpolicy != null) {
                    policy = channelpolicy;
                } else {
                    ChannelType channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID());
                    if (channelType != null && channelType.getAutoUpdatePolicy() != null) {
                        policy = channelType.getAutoUpdatePolicy();
                    }
                }
            }
            switch (policy) {
                case VETO: {
                    ret = Recommendation.DONT;
                    break;
                }
                case DEFAULT: {
                    if (ret != Recommendation.REQUIRED && ret != Recommendation.RECOMMENDED) continue block7;
                    ret = Recommendation.OPTIMISTIC;
                    break;
                }
                case RECOMMEND: {
                    if (ret != Recommendation.REQUIRED) break;
                    ret = Recommendation.RECOMMENDED;
                }
            }
        }
        return ret;
    }

    private void postUpdate(Item item, State newState, String origin) {
        boolean isAccepted = this.isAcceptedState(newState, item);
        if (isAccepted) {
            this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)newState, (String)origin));
        } else {
            this.logger.debug("Received update of a not accepted type ({}) for item {}", (Object)newState.getClass().getSimpleName(), (Object)item.getName());
        }
    }

    private void postPrediction(Item item, State predictedState, boolean isConfirmation) {
        boolean isAccepted = this.isAcceptedState(predictedState, item);
        if (isAccepted) {
            this.eventPublisher.post((Event)ItemEventFactory.createStatePredictedEvent((String)item.getName(), (State)predictedState, (boolean)isConfirmation));
        } else {
            this.logger.debug("Received prediction of a not accepted type ({}) for item {}", (Object)predictedState.getClass().getSimpleName(), (Object)item.getName());
        }
    }

    private boolean isAcceptedState(State newState, Item item) {
        boolean isAccepted = false;
        if (item.getAcceptedDataTypes().contains(newState.getClass())) {
            isAccepted = true;
        } else {
            for (Class state : item.getAcceptedDataTypes()) {
                try {
                    if (state.isEnum() || !state.newInstance().getClass().isAssignableFrom(newState.getClass())) continue;
                    isAccepted = true;
                    break;
                }
                catch (InstantiationException e) {
                    this.logger.warn("InstantiationException on {}", (Object)e.getMessage(), (Object)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("IllegalAccessException on {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return isAccepted;
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    private static enum Recommendation {
        REQUIRED,
        RECOMMENDED,
        OPTIMISTIC,
        DONT,
        REVERT;

    }
}

