/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.firmware;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.firmware.FirmwareProvider;
import org.eclipse.smarthome.core.thing.firmware.FirmwareRegistry;
import org.eclipse.smarthome.core.thing.internal.firmware.ParameterChecks;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={FirmwareRegistry.class})
@NonNullByDefault
public final class FirmwareRegistryImpl
implements FirmwareRegistry {
    private final Logger logger = LoggerFactory.getLogger(FirmwareRegistryImpl.class);
    private final List<FirmwareProvider> firmwareProviders = new CopyOnWriteArrayList<FirmwareProvider>();
    @NonNullByDefault(value={})
    private LocaleProvider localeProvider;

    @Override
    public @Nullable Firmware getFirmware(Thing thing, String firmwareVersion) {
        return this.getFirmware(thing, firmwareVersion, this.localeProvider.getLocale());
    }

    @Override
    public @Nullable Firmware getFirmware(Thing thing, String firmwareVersion, @Nullable Locale locale) {
        ParameterChecks.checkNotNull(thing, "Thing");
        ParameterChecks.checkNotNullOrEmpty(firmwareVersion, "Firmware version");
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Firmware firmware = firmwareProvider.getFirmware(thing, firmwareVersion, loc);
                if (firmware == null || !firmware.isSuitableFor(thing)) continue;
                return firmware;
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception occurred for firmware provider {} while getting firmware with version {} for thing {}", new Object[]{firmwareProvider.getClass().getSimpleName(), firmwareVersion, thing.getThingTypeUID(), e});
            }
        }
        return null;
    }

    @Override
    public @Nullable Firmware getLatestFirmware(Thing thing) {
        return this.getLatestFirmware(thing, this.localeProvider.getLocale());
    }

    @Override
    public @Nullable Firmware getLatestFirmware(Thing thing, @Nullable Locale locale) {
        Optional<Firmware> first;
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        Collection<Firmware> firmwares = this.getFirmwares(thing, loc);
        if (firmwares != null && (first = firmwares.stream().findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    @Override
    public Collection<Firmware> getFirmwares(Thing thing) {
        return this.getFirmwares(thing, this.localeProvider.getLocale());
    }

    @Override
    public Collection<Firmware> getFirmwares(Thing thing, @Nullable Locale locale) {
        ParameterChecks.checkNotNull(thing, "Thing");
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        TreeSet firmwares = new TreeSet();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Set<Firmware> result = firmwareProvider.getFirmwares(thing, loc);
                if (result == null) continue;
                List suitableFirmwares = result.stream().filter(firmware -> firmware.isSuitableFor(thing)).collect(Collectors.toList());
                firmwares.addAll(suitableFirmwares);
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception occurred for firmware provider {} while getting firmwares for thing {}.", new Object[]{firmwareProvider.getClass().getSimpleName(), thing.getUID(), e});
            }
        }
        return Collections.unmodifiableCollection(firmwares);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.add(firmwareProvider);
    }

    protected void removeFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.remove(firmwareProvider);
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }
}

