/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.AbstractLink;

public abstract class AbstractLinkRegistry<L extends AbstractLink, P extends Provider<L>>
extends AbstractRegistry<L, String, P> {
    private final ReentrantReadWriteLock toLinkLock = new ReentrantReadWriteLock();
    private final Map<String, Set<L>> itemNameToLink = new HashMap<String, Set<L>>();
    private final Map<UID, Set<L>> linkedUidToLink = new HashMap<UID, Set<L>>();

    protected AbstractLinkRegistry(Class<P> providerClazz) {
        super(providerClazz);
    }

    protected void onAddElement(L element) {
        super.onAddElement(element);
        this.toLinkAdded(element);
    }

    protected void onRemoveElement(L element) {
        super.onRemoveElement(element);
        this.toLinkRemoved(element);
    }

    protected void onUpdateElement(L oldElement, L element) {
        super.onUpdateElement(oldElement, element);
        this.toLinkRemoved(oldElement);
        this.toLinkAdded(element);
    }

    private void toLinkAdded(L element) {
        String itemName = ((AbstractLink)element).getItemName();
        UID linkedUid = ((AbstractLink)element).getLinkedUID();
        this.toLinkLock.writeLock().lock();
        try {
            Set<L> set = this.itemNameToLink.get(itemName);
            if (set == null) {
                set = new HashSet<L>();
                this.itemNameToLink.put(itemName, set);
            }
            set.add(element);
            set = this.linkedUidToLink.get((Object)linkedUid);
            if (set == null) {
                set = new HashSet<L>();
                this.linkedUidToLink.put(linkedUid, set);
            }
            set.add(element);
        }
        finally {
            this.toLinkLock.writeLock().unlock();
        }
    }

    private void toLinkRemoved(L element) {
        String itemName = ((AbstractLink)element).getItemName();
        UID linkedUid = ((AbstractLink)element).getLinkedUID();
        this.toLinkLock.writeLock().lock();
        try {
            Set<L> set = this.itemNameToLink.get(itemName);
            if (set != null) {
                set.remove(element);
                if (set.isEmpty()) {
                    this.itemNameToLink.remove(itemName);
                }
            }
            if ((set = this.linkedUidToLink.get((Object)linkedUid)) != null) {
                set.remove(element);
                if (set.isEmpty()) {
                    this.linkedUidToLink.remove((Object)linkedUid);
                }
            }
        }
        finally {
            this.toLinkLock.writeLock().unlock();
        }
    }

    public boolean isLinked(String itemName, UID uid) {
        this.toLinkLock.readLock().lock();
        try {
            Set<L> forItemName = this.itemNameToLink.get(itemName);
            Set<L> forLinkedUID = this.linkedUidToLink.get((Object)uid);
            if (forItemName == null || forLinkedUID == null) {
                return false;
            }
            boolean bl = forItemName.parallelStream().anyMatch(forLinkedUID::contains);
            return bl;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }

    public boolean isLinked(String itemName) {
        this.toLinkLock.readLock().lock();
        try {
            boolean bl = this.itemNameToLink.get(itemName) != null;
            return bl;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }

    public boolean isLinked(UID uid) {
        this.toLinkLock.readLock().lock();
        try {
            boolean bl = this.linkedUidToLink.get((Object)uid) != null;
            return bl;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }

    public Set<String> getLinkedItemNames(UID uid) {
        this.toLinkLock.readLock().lock();
        try {
            Set<L> forLinkedUID = this.linkedUidToLink.get((Object)uid);
            if (forLinkedUID == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = forLinkedUID.parallelStream().map(link -> link.getItemName()).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }

    public Set<L> getLinks(UID uid) {
        this.toLinkLock.readLock().lock();
        try {
            Set<L> forLinkedUID = this.linkedUidToLink.get((Object)uid);
            HashSet<L> hashSet = forLinkedUID != null ? new HashSet<L>(forLinkedUID) : Collections.emptySet();
            return hashSet;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }

    public Set<L> getLinks(String itemName) {
        this.toLinkLock.readLock().lock();
        try {
            Set<L> forLinkedUID = this.itemNameToLink.get(itemName);
            HashSet<L> hashSet = forLinkedUID != null ? new HashSet<L>(forLinkedUID) : Collections.emptySet();
            return hashSet;
        }
        finally {
            this.toLinkLock.readLock().unlock();
        }
    }
}

