/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import org.eclipse.smarthome.binding.hue.internal.Command;
import org.eclipse.smarthome.binding.hue.internal.ConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.Util;

public class BridgeConfigUpdate
extends ConfigUpdate {
    public BridgeConfigUpdate setProxyPort(Integer port) {
        if (port != null && port < 0) {
            throw new IllegalArgumentException("Invalid value for port");
        }
        this.commands.add(new Command("proxyport", port == null ? 0 : port));
        return this;
    }

    public BridgeConfigUpdate setName(String name) {
        if (Util.stringSize(name) < 4 || Util.stringSize(name) > 16) {
            throw new IllegalArgumentException("Bridge name must be between 4 and 16 characters long");
        }
        this.commands.add(new Command("name", name));
        return this;
    }

    public BridgeConfigUpdate setProxyAddress(String ip) {
        if (ip != null && Util.stringSize(ip) > 40) {
            throw new IllegalArgumentException("Bridge proxy address can be at most 40 characters long");
        }
        this.commands.add(new Command("proxyaddress", ip == null ? "none" : ip));
        return this;
    }

    public BridgeConfigUpdate setLinkButton(boolean pressed) {
        this.commands.add(new Command("linkbutton", pressed));
        return this;
    }

    public BridgeConfigUpdate setIPAddress(String ip) {
        this.commands.add(new Command("ipaddress", ip));
        return this;
    }

    public BridgeConfigUpdate setNetworkMask(String netmask) {
        this.commands.add(new Command("netmask", netmask));
        return this;
    }

    public BridgeConfigUpdate setGateway(String ip) {
        this.commands.add(new Command("gateway", ip));
        return this;
    }

    public BridgeConfigUpdate setDHCP(boolean enabled) {
        this.commands.add(new Command("dhcp", enabled));
        return this;
    }
}

