/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.discovery.HueLightDiscoveryService;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.HueLightHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.DimmerSwitchHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.LightLevelHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.PresenceHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.TemperatureHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(service={ThingHandlerFactory.class}, configurationPid="binding.hue")
public class HueThingHandlerFactory
extends BaseThingHandlerFactory {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.unmodifiableSet(Stream.of(HueBridgeHandler.SUPPORTED_THING_TYPES.stream(), HueLightHandler.SUPPORTED_THING_TYPES.stream(), DimmerSwitchHandler.SUPPORTED_THING_TYPES.stream(), PresenceHandler.SUPPORTED_THING_TYPES.stream(), TemperatureHandler.SUPPORTED_THING_TYPES.stream(), LightLevelHandler.SUPPORTED_THING_TYPES.stream()).flatMap(i -> i).collect(Collectors.toSet()));
    private final Map<ThingUID, @Nullable ServiceRegistration<?>> discoveryServiceRegs = new HashMap();

    public @Nullable Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, @Nullable ThingUID thingUID, @Nullable ThingUID bridgeUID) {
        if (HueBridgeHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return super.createThing(thingTypeUID, configuration, thingUID, null);
        }
        if (HueLightHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            ThingUID hueLightUID = this.getLightUID(thingTypeUID, thingUID, configuration, bridgeUID);
            return super.createThing(thingTypeUID, configuration, hueLightUID, bridgeUID);
        }
        if (DimmerSwitchHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID) || PresenceHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID) || TemperatureHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID) || LightLevelHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            ThingUID hueSensorUID = this.getSensorUID(thingTypeUID, thingUID, configuration, bridgeUID);
            return super.createThing(thingTypeUID, configuration, hueSensorUID, bridgeUID);
        }
        throw new IllegalArgumentException("The thing type " + thingTypeUID + " is not supported by the hue binding.");
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    private ThingUID getLightUID(ThingTypeUID thingTypeUID, @Nullable ThingUID thingUID, Configuration configuration, @Nullable ThingUID bridgeUID) {
        if (thingUID != null) {
            return thingUID;
        }
        return this.getThingUID(thingTypeUID, configuration.get("lightId").toString(), bridgeUID);
    }

    private ThingUID getSensorUID(ThingTypeUID thingTypeUID, @Nullable ThingUID thingUID, Configuration configuration, @Nullable ThingUID bridgeUID) {
        if (thingUID != null) {
            return thingUID;
        }
        return this.getThingUID(thingTypeUID, configuration.get("sensorId").toString(), bridgeUID);
    }

    private ThingUID getThingUID(ThingTypeUID thingTypeUID, String id, @Nullable ThingUID bridgeUID) {
        if (bridgeUID != null) {
            return new ThingUID(thingTypeUID, id, new String[]{bridgeUID.getId()});
        }
        return new ThingUID(thingTypeUID, id);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        if (HueBridgeHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            HueBridgeHandler handler = new HueBridgeHandler((Bridge)thing);
            this.registerLightDiscoveryService(handler);
            return handler;
        }
        if (HueLightHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new HueLightHandler(thing);
        }
        if (DimmerSwitchHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new DimmerSwitchHandler(thing);
        }
        if (PresenceHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new PresenceHandler(thing);
        }
        if (TemperatureHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new TemperatureHandler(thing);
        }
        if (LightLevelHandler.SUPPORTED_THING_TYPES.contains(thing.getThingTypeUID())) {
            return new LightLevelHandler(thing);
        }
        return null;
    }

    private synchronized void registerLightDiscoveryService(HueBridgeHandler bridgeHandler) {
        HueLightDiscoveryService discoveryService = new HueLightDiscoveryService(bridgeHandler);
        discoveryService.activate();
        this.discoveryServiceRegs.put(bridgeHandler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof HueBridgeHandler && (serviceReg = this.discoveryServiceRegs.remove(thingHandler.getThing().getUID())) != null) {
            HueLightDiscoveryService service = (HueLightDiscoveryService)this.bundleContext.getService(serviceReg.getReference());
            serviceReg.unregister();
            if (service != null) {
                service.deactivate();
            }
        }
    }
}

