/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullHueObject;
import org.eclipse.smarthome.binding.hue.internal.FullLight;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.HueLightHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStatusListener;
import org.eclipse.smarthome.binding.hue.internal.handler.SensorStatusListener;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.DimmerSwitchHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.LightLevelHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.PresenceHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.sensors.TemperatureHandler;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HueLightDiscoveryService
extends AbstractDiscoveryService
implements LightStatusListener,
SensorStatusListener {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.unmodifiableSet(Stream.of(HueLightHandler.SUPPORTED_THING_TYPES.stream(), DimmerSwitchHandler.SUPPORTED_THING_TYPES.stream(), PresenceHandler.SUPPORTED_THING_TYPES.stream(), TemperatureHandler.SUPPORTED_THING_TYPES.stream(), LightLevelHandler.SUPPORTED_THING_TYPES.stream()).flatMap(i -> i).collect(Collectors.toSet()));
    private final Logger logger = LoggerFactory.getLogger(HueLightDiscoveryService.class);
    private static final int SEARCH_TIME = 10;
    private static final Map<String, @Nullable String> TYPE_TO_ZIGBEE_ID_MAP = Stream.of(new AbstractMap.SimpleEntry<String, String>("on_off_light", "0000"), new AbstractMap.SimpleEntry<String, String>("on_off_plug_in_unit", "0010"), new AbstractMap.SimpleEntry<String, String>("dimmable_light", "0100"), new AbstractMap.SimpleEntry<String, String>("dimmable_plug_in_unit", "0110"), new AbstractMap.SimpleEntry<String, String>("color_light", "0200"), new AbstractMap.SimpleEntry<String, String>("extended_color_light", "0210"), new AbstractMap.SimpleEntry<String, String>("color_temperature_light", "0220"), new AbstractMap.SimpleEntry<String, String>("zllswitch", "0820"), new AbstractMap.SimpleEntry<String, String>("zllpresence", "0107"), new AbstractMap.SimpleEntry<String, String>("zlltemperature", "0302"), new AbstractMap.SimpleEntry<String, String>("zlllightlevel", "0106")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    private final HueBridgeHandler hueBridgeHandler;

    public HueLightDiscoveryService(HueBridgeHandler hueBridgeHandler) {
        super(10);
        this.hueBridgeHandler = hueBridgeHandler;
    }

    public void activate() {
        this.hueBridgeHandler.registerLightStatusListener(this);
        this.hueBridgeHandler.registerSensorStatusListener(this);
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime(), this.hueBridgeHandler.getThing().getUID());
        this.hueBridgeHandler.unregisterLightStatusListener(this);
        this.hueBridgeHandler.unregisterSensorStatusListener(this);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return SUPPORTED_THING_TYPES;
    }

    public void startScan() {
        List<FullLight> lights = this.hueBridgeHandler.getFullLights();
        for (FullLight l : lights) {
            this.onLightAddedInternal(l);
        }
        List<FullSensor> sensors = this.hueBridgeHandler.getFullSensors();
        for (FullSensor s : sensors) {
            this.onSensorAddedInternal(s);
        }
        this.hueBridgeHandler.startSearch();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    @Override
    public void onLightAdded(@Nullable HueBridge bridge, FullLight light) {
        this.onLightAddedInternal(light);
    }

    private void onLightAddedInternal(FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        ThingTypeUID thingTypeUID = this.getThingTypeUID(light);
        String modelId = light.getModelID().replaceAll("[^a-zA-Z0-9_]", "_");
        if (thingUID != null && thingTypeUID != null) {
            ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("lightId", light.getId());
            properties.put("modelId", modelId);
            String uniqueID = light.getUniqueID();
            if (uniqueID != null) {
                properties.put("uniqueId", uniqueID);
            }
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withThingType(thingTypeUID).withProperties(properties).withBridge(bridgeUID).withRepresentationProperty("uniqueId").withLabel(light.getName()).build();
            this.thingDiscovered(discoveryResult);
        } else {
            this.logger.debug("discovered unsupported light of type '{}' and model '{}' with id {}", new Object[]{light.getType(), modelId, light.getId()});
        }
    }

    @Override
    public void onLightRemoved(@Nullable HueBridge bridge, FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            this.thingRemoved(thingUID);
        }
    }

    @Override
    public void onLightStateChanged(@Nullable HueBridge bridge, FullLight light) {
    }

    private @Nullable ThingUID getThingUID(FullHueObject hueObject) {
        ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
        ThingTypeUID thingTypeUID = this.getThingTypeUID(hueObject);
        if (thingTypeUID != null && this.getSupportedThingTypes().contains(thingTypeUID)) {
            return new ThingUID(thingTypeUID, bridgeUID, hueObject.getId());
        }
        return null;
    }

    private @Nullable ThingTypeUID getThingTypeUID(FullHueObject hueObject) {
        String thingTypeId = TYPE_TO_ZIGBEE_ID_MAP.get(hueObject.getType().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase());
        return thingTypeId != null ? new ThingTypeUID("hue", thingTypeId) : null;
    }

    @Override
    public void onSensorAdded(@Nullable HueBridge bridge, FullSensor sensor) {
        this.onSensorAddedInternal(sensor);
    }

    private void onSensorAddedInternal(FullSensor sensor) {
        ThingUID thingUID = this.getThingUID(sensor);
        ThingTypeUID thingTypeUID = this.getThingTypeUID(sensor);
        String modelId = sensor.getModelID().replaceAll("[^a-zA-Z0-9_]", "_");
        if (thingUID != null && thingTypeUID != null) {
            ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("sensorId", sensor.getId());
            properties.put("modelId", modelId);
            String uniqueID = sensor.getUniqueID();
            if (uniqueID != null) {
                properties.put("uniqueId", uniqueID);
            }
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withThingType(thingTypeUID).withProperties(properties).withBridge(bridgeUID).withRepresentationProperty("uniqueId").withLabel(sensor.getName()).build();
            this.thingDiscovered(discoveryResult);
        } else {
            this.logger.debug("discovered unsupported sensor of type '{}' and model '{}' with id {}", new Object[]{sensor.getType(), modelId, sensor.getId()});
        }
    }

    @Override
    public void onSensorRemoved(@Nullable HueBridge bridge, FullSensor sensor) {
        ThingUID thingUID = this.getThingUID(sensor);
        if (thingUID != null) {
            this.thingRemoved(thingUID);
        }
    }

    @Override
    public void onSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor) {
    }
}

