/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler.sensors;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.LightLevelConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.SensorConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.handler.HueSensorHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class LightLevelHandler
extends HueSensorHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_LIGHT_LEVEL_SENSOR);

    public LightLevelHandler(Thing thing) {
        super(thing);
    }

    @Override
    protected SensorConfigUpdate doConfigurationUpdate(Map<String, Object> configurationParameters) {
        LightLevelConfigUpdate configUpdate = new LightLevelConfigUpdate();
        if (configurationParameters.containsKey("ledindication")) {
            configUpdate.setLedIndication(Boolean.TRUE.equals(configurationParameters.get("ledindication")));
        }
        if (configurationParameters.containsKey("tholddark")) {
            configUpdate.setThresholdDark(Integer.parseInt(String.valueOf(configurationParameters.get("tholddark"))));
        }
        if (configurationParameters.containsKey("tholdoffset")) {
            configUpdate.setThresholdOffset(Integer.parseInt(String.valueOf(configurationParameters.get("tholdoffset"))));
        }
        return configUpdate;
    }

    @Override
    protected void doSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor, Configuration config) {
        Object daylight;
        Object dark;
        Object lightLevel = sensor.getState().get("lightlevel");
        if (lightLevel != null) {
            BigDecimal value = new BigDecimal(String.valueOf(lightLevel));
            this.updateState("light_level", (State)new DecimalType(value));
            double lux = Math.pow(10.0, value.subtract(BigDecimal.ONE).divide(new BigDecimal(10000)).doubleValue());
            this.updateState("illuminance", (State)new QuantityType((Number)lux, SmartHomeUnits.LUX));
        }
        if ((dark = sensor.getState().get("dark")) != null) {
            boolean value = Boolean.parseBoolean(String.valueOf(dark));
            this.updateState("dark", (State)(value ? OnOffType.ON : OnOffType.OFF));
        }
        if ((daylight = sensor.getState().get("daylight")) != null) {
            boolean value = Boolean.parseBoolean(String.valueOf(daylight));
            this.updateState("daylight", (State)(value ? OnOffType.ON : OnOffType.OFF));
        }
        if (sensor.getConfig().containsKey("ledindication")) {
            config.put("ledindication", sensor.getConfig().get("tholddark"));
        }
        if (sensor.getConfig().containsKey("tholddark")) {
            config.put("tholddark", sensor.getConfig().get("tholddark"));
        }
        if (sensor.getConfig().containsKey("tholdoffset")) {
            config.put("tholdoffset", sensor.getConfig().get("tholdoffset"));
        }
    }
}

