/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler.sensors;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.PresenceConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.SensorConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.handler.HueSensorHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class PresenceHandler
extends HueSensorHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_PRESENCE_SENSOR);

    public PresenceHandler(Thing thing) {
        super(thing);
    }

    @Override
    protected SensorConfigUpdate doConfigurationUpdate(Map<String, Object> configurationParameters) {
        PresenceConfigUpdate configUpdate = new PresenceConfigUpdate();
        if (configurationParameters.containsKey("ledindication")) {
            configUpdate.setLedIndication(Boolean.TRUE.equals(configurationParameters.get("ledindication")));
        }
        if (configurationParameters.containsKey("sensitivity")) {
            configUpdate.setSensitivity(Integer.parseInt(String.valueOf(configurationParameters.get("sensitivity"))));
        }
        return configUpdate;
    }

    @Override
    protected void doSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor, Configuration config) {
        Object presence = sensor.getState().get("presence");
        if (presence != null) {
            boolean value = Boolean.parseBoolean(String.valueOf(presence));
            this.updateState("presence", (State)(value ? OnOffType.ON : OnOffType.OFF));
        }
        if (sensor.getConfig().containsKey("ledindication")) {
            config.put("ledindication", sensor.getConfig().get("tholddark"));
        }
        if (sensor.getConfig().containsKey("sensitivity")) {
            config.put("sensitivity", sensor.getConfig().get("sensitivity"));
        }
        if (sensor.getConfig().containsKey("sensitivitymax")) {
            config.put("sensitivitymax", sensor.getConfig().get("sensitivitymax"));
        }
    }
}

