/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.config.core.Configuration;

public class ConfigurationSerializer
implements JsonSerializer<Configuration> {
    public JsonElement serialize(Configuration src, Type typeOfSrc, JsonSerializationContext context) {
        Set<String> kyes;
        JsonObject result = null;
        if (src != null && (kyes = src.keySet()).size() > 0) {
            result = new JsonObject();
            for (String propName : kyes) {
                Object value = src.get(propName);
                if (value instanceof List) {
                    JsonArray array = new JsonArray();
                    for (Object element : (List)value) {
                        array.add((JsonElement)this.serializePrimitive(element));
                    }
                    result.add(propName, (JsonElement)array);
                    continue;
                }
                result.add(propName, (JsonElement)this.serializePrimitive(value));
            }
        }
        return result;
    }

    private JsonPrimitive serializePrimitive(Object primitive) {
        if (primitive instanceof String) {
            return new JsonPrimitive((String)primitive);
        }
        if (primitive instanceof Number) {
            return new JsonPrimitive((Number)primitive);
        }
        if (primitive instanceof Boolean) {
            return new JsonPrimitive((Boolean)primitive);
        }
        return null;
    }
}

