/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepositoryImpl
implements ModelRepository {
    private final Logger logger = LoggerFactory.getLogger(ModelRepositoryImpl.class);
    private final ResourceSet resourceSet;
    private final List<ModelRepositoryChangeListener> listeners = new CopyOnWriteArrayList<ModelRepositoryChangeListener>();

    public ModelRepositoryImpl() {
        SynchronizedXtextResourceSet xtextResourceSet = new SynchronizedXtextResourceSet();
        xtextResourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        this.resourceSet = xtextResourceSet;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EObject getModel(String name) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block5: {
                Resource resource = this.getResource(name);
                if (resource == null) break block5;
                if (resource.getContents().size() > 0) {
                    return (EObject)resource.getContents().get(0);
                }
                this.logger.warn("Configuration model '{}' is either empty or cannot be parsed correctly!", (Object)name);
                this.resourceSet.getResources().remove((Object)resource);
                return null;
            }
            this.logger.trace("Configuration model '{}' can not be found", (Object)name);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addOrRefreshModel(String name, InputStream originalInputStream) {
        Resource resource = null;
        try {
            ResourceSet resourceSet;
            ByteArrayInputStream inputStream = null;
            if (originalInputStream != null) {
                byte[] bytes = IOUtils.toByteArray((InputStream)originalInputStream);
                String validationResult = this.validateModel(name, new ByteArrayInputStream(bytes));
                if (validationResult != null) {
                    this.logger.warn("Configuration model '{}' has errors, therefore ignoring it: {}", (Object)name, (Object)validationResult);
                    this.removeModel(name);
                    return false;
                }
                inputStream = new ByteArrayInputStream(bytes);
            }
            if ((resource = this.getResource(name)) == null) {
                resourceSet = this.resourceSet;
                synchronized (resourceSet) {
                    resource = this.getResource(name);
                    if (resource != null) return false;
                    Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("*");
                    resource = this.resourceSet.createResource(URI.createURI((String)name));
                    if (resource == null) {
                        this.logger.warn("Ignoring file '{}' as we do not have a parser for it.", (Object)name);
                        return false;
                    }
                    this.logger.info("Loading model '{}'", (Object)name);
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put(XtextResource.OPTION_ENCODING, "UTF-8");
                    if (inputStream == null) {
                        this.logger.warn("Resource '{}' not found. You have to pass an inputStream to create the resource.", (Object)name);
                        return false;
                    }
                    resource.load((InputStream)inputStream, options);
                    this.notifyListeners(name, EventType.ADDED);
                    return true;
                }
            }
            resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                resource.unload();
                this.logger.info("Refreshing model '{}'", (Object)name);
                if (inputStream != null) {
                    resource.load((InputStream)inputStream, Collections.EMPTY_MAP);
                } else {
                    resource.load(Collections.EMPTY_MAP);
                }
                this.notifyListeners(name, EventType.MODIFIED);
                return true;
            }
        }
        catch (IOException e) {
            this.logger.warn("Configuration model '{}' cannot be parsed correctly!", (Object)name, (Object)e);
            if (resource == null) return false;
            this.resourceSet.getResources().remove((Object)resource);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeModel(String name) {
        Resource resource = this.getResource(name);
        if (resource != null) {
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                this.notifyListeners(name, EventType.REMOVED);
                this.resourceSet.getResources().remove((Object)resource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getAllModelNamesOfType(String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            return resourceListCopy.stream().filter(input -> input != null && input.getURI().lastSegment().contains(".") && input.isLoaded() && modelType.equalsIgnoreCase(input.getURI().fileExtension())).map(from -> from.getURI().path()).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadAllModelsOfType(String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            for (Resource resource : resourceListCopy) {
                if (resource == null || !resource.getURI().lastSegment().contains(".") || !resource.isLoaded() || !modelType.equalsIgnoreCase(resource.getURI().fileExtension())) continue;
                XtextResource xtextResource = (XtextResource)resource;
                this.logger.debug("Refreshing resource '{}'", (Object)resource.getURI().lastSegment());
                xtextResource.update(1, 0, "");
                this.notifyListeners(resource.getURI().lastSegment(), EventType.MODIFIED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> removeAllModelsOfType(String modelType) {
        HashSet<String> ret = new HashSet<String>();
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            for (Resource resource : resourceListCopy) {
                if (resource == null || !resource.getURI().lastSegment().contains(".") || !resource.isLoaded() || !modelType.equalsIgnoreCase(resource.getURI().fileExtension())) continue;
                this.logger.debug("Removing resource '{}'", (Object)resource.getURI().lastSegment());
                ret.add(resource.getURI().lastSegment());
                this.resourceSet.getResources().remove((Object)resource);
                this.notifyListeners(resource.getURI().lastSegment(), EventType.REMOVED);
            }
        }
        return ret;
    }

    @Override
    public void addModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    private Resource getResource(String name) {
        return this.resourceSet.getResource(URI.createURI((String)name), false);
    }

    private String validateModel(String name, InputStream inputStream) throws IOException {
        block10: {
            Resource resource = this.resourceSet.createResource(URI.createURI((String)("tmp_" + name)));
            try {
                resource.load(inputStream, Collections.EMPTY_MAP);
                StringBuilder criticalErrors = new StringBuilder();
                LinkedList<String> warnings = new LinkedList<String>();
                if (resource == null || resource.getContents().isEmpty()) break block10;
                for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                    criticalErrors.append(MessageFormat.format("[{0},{1}]: {2}\n", Integer.toString(diagnostic.getLine()), Integer.toString(diagnostic.getColumn()), diagnostic.getMessage()));
                }
                if (criticalErrors.length() > 0) {
                    String string = criticalErrors.toString();
                    return string;
                }
                try {
                    Resource.Diagnostic diagnostic;
                    diagnostic = Diagnostician.INSTANCE.validate((EObject)resource.getContents().get(0));
                    for (Diagnostic d : diagnostic.getChildren()) {
                        warnings.add(d.getMessage());
                    }
                    if (warnings.size() > 0) {
                        this.logger.info("Validation issues found in configuration model '{}', using it anyway:\n{}", (Object)name, (Object)StringUtils.join(warnings, (String)"\n"));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.logger.debug("Validation of '{}' skipped due to internal errors.", (Object)name);
                }
            }
            finally {
                this.resourceSet.getResources().remove((Object)resource);
            }
        }
        return null;
    }

    private void notifyListeners(String name, EventType type) {
        for (ModelRepositoryChangeListener listener : this.listeners) {
            listener.modelChanged(name, type);
        }
    }
}

