/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.id;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceUUID {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceUUID.class);
    static final String UUID_FILE_NAME = "uuid";
    static String uuid = null;

    public static synchronized String get() {
        if (uuid == null) {
            try {
                File file = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + UUID_FILE_NAME);
                if (!file.exists()) {
                    uuid = UUID.randomUUID().toString();
                    InstanceUUID.writeFile(file, uuid);
                } else {
                    uuid = InstanceUUID.readFirstLine(file);
                    if (StringUtils.isNotEmpty((String)uuid)) {
                        LOGGER.debug("UUID '{}' has been restored from file '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                    } else {
                        uuid = UUID.randomUUID().toString();
                        LOGGER.warn("UUID file '{}' has no content, rewriting it now with '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                        InstanceUUID.writeFile(file, uuid);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed writing instance uuid file: {}", (Object)e.getMessage());
                return null;
            }
        }
        return uuid;
    }

    private static void writeFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.write((String)content, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String readFirstLine(File file) {
        List lines = null;
        try {
            lines = IOUtils.readLines((InputStream)new FileInputStream(file));
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed reading the UUID file '{}': {}", (Object)file.getAbsolutePath(), (Object)ioe.getMessage());
        }
        return lines != null && lines.size() > 0 ? (String)lines.get(0) : "";
    }
}

