/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluez;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompletionStatus;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDescriptor;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothService;
import org.eclipse.smarthome.binding.bluetooth.bluez.handler.BlueZBridgeHandler;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothConnectionStatusNotification;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothScanNotification;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tinyb.BluetoothException;
import tinyb.BluetoothGattCharacteristic;
import tinyb.BluetoothGattDescriptor;
import tinyb.BluetoothGattService;

public class BlueZBluetoothDevice
extends BluetoothDevice {
    private tinyb.BluetoothDevice device;
    private final Logger logger = LoggerFactory.getLogger(BlueZBluetoothDevice.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"bluetooth");

    public BlueZBluetoothDevice(BlueZBridgeHandler adapter, BluetoothAddress address, String name) {
        super((BluetoothAdapter)adapter, address);
        this.name = name;
        this.logger.debug("Creating BlueZ device with address '{}'", (Object)address);
    }

    public BlueZBluetoothDevice(BlueZBridgeHandler adapter, tinyb.BluetoothDevice tinybDevice) {
        super((BluetoothAdapter)adapter, new BluetoothAddress(tinybDevice.getAddress()));
        this.name = tinybDevice.getName();
        this.device = tinybDevice;
    }

    public synchronized void initialize() {
        this.scheduler.submit(() -> {
            if (this.device == null) {
                tinyb.BluetoothDevice tinybDevice = this.findTinybDevice(this.address.toString());
                if (tinybDevice != null) {
                    this.device = tinybDevice;
                    this.enableNotifications();
                }
            } else {
                this.enableNotifications();
            }
        });
    }

    public synchronized void updateTinybDevice(tinyb.BluetoothDevice tinybDevice) {
        tinyb.BluetoothDevice dev;
        if (this.device != null && !tinybDevice.equals((Object)this.device)) {
            this.disableNotifications();
        }
        if (this.device == null || !tinybDevice.equals((Object)this.device)) {
            this.device = tinybDevice;
            this.enableNotifications();
        }
        if ((dev = this.device) != null) {
            this.rssi = dev.getRSSI();
            this.txPower = dev.getTxPower();
            if (dev.getConnected()) {
                this.connectionState = BluetoothDevice.ConnectionState.CONNECTED;
            }
        }
        this.refreshServices();
    }

    private @Nullable tinyb.BluetoothDevice findTinybDevice(String address) {
        Collection<tinyb.BluetoothDevice> deviceList = ((BlueZBridgeHandler)this.getAdapter()).getTinyBDevices();
        this.logger.trace("Searching for '{}' in {} devices.", (Object)address, (Object)deviceList.size());
        return deviceList.stream().filter(d -> d.getAddress().equals(address)).findFirst().orElse(null);
    }

    private void enableNotifications() {
        this.logger.debug("Enabling notifications for device '{}'", (Object)this.device.getAddress());
        this.device.enableRSSINotifications(n -> {
            this.rssi = (int)n;
            BluetoothScanNotification notification = new BluetoothScanNotification();
            notification.setRssi((int)n.shortValue());
            this.notifyListeners(BluetoothDevice.BluetoothEventType.SCAN_RECORD, new Object[]{notification});
        });
        this.device.enableManufacturerDataNotifications(n -> {
            for (Map.Entry entry : n.entrySet()) {
                BluetoothScanNotification notification = new BluetoothScanNotification();
                byte[] data = new byte[((byte[])entry.getValue()).length + 2];
                data[0] = (byte)((Short)entry.getKey() & 0xFF);
                data[1] = (byte)((Short)entry.getKey() >>> 8);
                System.arraycopy(entry.getValue(), 0, data, 2, ((byte[])entry.getValue()).length);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received manufacturer data for '{}': {}", (Object)this.address, (Object)HexUtils.bytesToHex((byte[])data, (CharSequence)" "));
                }
                notification.setManufacturerData(data);
                this.notifyListeners(BluetoothDevice.BluetoothEventType.SCAN_RECORD, new Object[]{notification});
            }
        });
        this.device.enableConnectedNotifications(connected -> {
            this.connectionState = connected != false ? BluetoothDevice.ConnectionState.CONNECTED : BluetoothDevice.ConnectionState.DISCONNECTED;
            this.logger.debug("Connection state of '{}' changed to {}", (Object)this.address, (Object)this.connectionState);
            this.notifyListeners(BluetoothDevice.BluetoothEventType.CONNECTION_STATE, new Object[]{new BluetoothConnectionStatusNotification(this.connectionState)});
        });
        this.device.enableServicesResolvedNotifications(resolved -> {
            this.logger.debug("Received services resolved event for '{}': {}", (Object)this.address, resolved);
            if (resolved.booleanValue()) {
                this.refreshServices();
                this.notifyListeners(BluetoothDevice.BluetoothEventType.SERVICES_DISCOVERED, new Object[0]);
            }
        });
        this.device.enableServiceDataNotifications(data -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received service data for '{}':", (Object)this.address);
                for (Map.Entry entry : data.entrySet()) {
                    this.logger.debug("{} : {}", entry.getKey(), (Object)HexUtils.bytesToHex((byte[])((byte[])entry.getValue()), (CharSequence)" "));
                }
            }
        });
    }

    private void disableNotifications() {
        this.logger.debug("Disabling notifications for device '{}'", (Object)this.device.getAddress());
        this.device.disableBlockedNotifications();
        this.device.disableManufacturerDataNotifications();
        this.device.disablePairedNotifications();
        this.device.disableRSSINotifications();
        this.device.disableServiceDataNotifications();
        this.device.disableTrustedNotifications();
    }

    protected void refreshServices() {
        if (this.device.getServices().size() > this.getServices().size()) {
            for (BluetoothGattService tinybService : this.device.getServices()) {
                BluetoothService service = new BluetoothService(UUID.fromString(tinybService.getUUID()), tinybService.getPrimary());
                for (BluetoothGattCharacteristic tinybCharacteristic : tinybService.getCharacteristics()) {
                    BluetoothCharacteristic characteristic = new BluetoothCharacteristic(UUID.fromString(tinybCharacteristic.getUUID()), 0);
                    for (BluetoothGattDescriptor tinybDescriptor : tinybCharacteristic.getDescriptors()) {
                        BluetoothDescriptor descriptor = new BluetoothDescriptor(characteristic, UUID.fromString(tinybDescriptor.getUUID()));
                        characteristic.addDescriptor(descriptor);
                    }
                    service.addCharacteristic(characteristic);
                }
                this.addService(service);
            }
            this.notifyListeners(BluetoothDevice.BluetoothEventType.SERVICES_DISCOVERED, new Object[0]);
        }
    }

    public boolean connect() {
        if (this.device != null && !this.device.getConnected()) {
            try {
                return this.device.connect();
            }
            catch (BluetoothException e) {
                if ("Timeout was reached".equals(e.getMessage())) {
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CONNECTION_STATE, new Object[]{new BluetoothConnectionStatusNotification(BluetoothDevice.ConnectionState.DISCONNECTED)});
                }
                if (e.getMessage() != null && e.getMessage().contains("Protocol not available")) {
                    this.logger.warn("Bluetooth device '{}' does not allow a connection.", (Object)this.device.getAddress());
                }
                this.logger.debug("Exception occurred when trying to connect device '{}': {}", (Object)this.device.getAddress(), (Object)e.getMessage());
            }
        }
        return false;
    }

    public boolean disconnect() {
        if (this.device != null && this.device.getConnected()) {
            this.logger.debug("Disconnecting '{}'", (Object)this.address);
            try {
                return this.device.disconnect();
            }
            catch (BluetoothException e) {
                this.logger.debug("Exception occurred when trying to disconnect device '{}': {}", (Object)this.device.getAddress(), (Object)e.getMessage());
            }
        }
        return false;
    }

    public boolean readCharacteristic(BluetoothCharacteristic characteristic) {
        if (this.device == null) {
            throw new IllegalStateException("TinyB device is not yet set");
        }
        BluetoothGattCharacteristic c = this.getTinybCharacteristicByUUID(characteristic.getUuid().toString());
        this.scheduler.submit(() -> {
            try {
                byte[] value = c.readValue();
                characteristic.setValue(value);
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_READ_COMPLETE, new Object[]{characteristic, BluetoothCompletionStatus.SUCCESS});
            }
            catch (BluetoothException e) {
                this.logger.debug("Exception occurred when trying to read characteristic '{}': {}", (Object)characteristic.getUuid(), (Object)e.getMessage());
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_READ_COMPLETE, new Object[]{characteristic, BluetoothCompletionStatus.ERROR});
            }
        });
        return true;
    }

    public boolean writeCharacteristic(BluetoothCharacteristic characteristic) {
        if (this.device == null) {
            throw new IllegalStateException("TinyB device is not yet set");
        }
        BluetoothGattCharacteristic c = this.getTinybCharacteristicByUUID(characteristic.getUuid().toString());
        this.scheduler.submit(() -> {
            try {
                BluetoothCompletionStatus successStatus = c.writeValue(characteristic.getByteValue()) ? BluetoothCompletionStatus.SUCCESS : BluetoothCompletionStatus.ERROR;
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_WRITE_COMPLETE, new Object[]{characteristic, successStatus});
            }
            catch (BluetoothException e) {
                this.logger.debug("Exception occurred when trying to read characteristic '{}': {}", (Object)characteristic.getUuid(), (Object)e.getMessage());
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_WRITE_COMPLETE, new Object[]{characteristic, BluetoothCompletionStatus.ERROR});
            }
        });
        return true;
    }

    public boolean enableNotifications(BluetoothCharacteristic characteristic) {
        if (this.device == null || !this.device.getConnected()) {
            throw new IllegalStateException("TinyB device is not set or not connected");
        }
        BluetoothGattCharacteristic c = this.getTinybCharacteristicByUUID(characteristic.getUuid().toString());
        if (c != null) {
            try {
                c.enableValueNotifications(value -> {
                    this.logger.debug("Received new value '{}' for characteristic '{}' of device '{}'", new Object[]{value, characteristic.getUuid(), this.address});
                    characteristic.setValue(value);
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_UPDATED, new Object[]{characteristic});
                });
            }
            catch (BluetoothException e) {
                if (e.getMessage().contains("Already notifying")) {
                    return false;
                }
                if (e.getMessage().contains("In Progress")) {
                    this.scheduler.schedule(() -> this.enableNotifications(characteristic), 10L, TimeUnit.SECONDS);
                }
                this.logger.warn("Exception occurred while activating notifications on '{}'", (Object)this.address, (Object)e);
            }
            return true;
        }
        this.logger.warn("Characteristic '{}' is missing on device '{}'.", (Object)characteristic.getUuid(), (Object)this.address);
        return false;
    }

    public boolean disableNotifications(BluetoothCharacteristic characteristic) {
        if (this.device == null || !this.device.getConnected()) {
            throw new IllegalStateException("TinyB device is not set or not connected");
        }
        BluetoothGattCharacteristic c = this.getTinybCharacteristicByUUID(characteristic.getUuid().toString());
        if (c != null) {
            c.disableValueNotifications();
            return true;
        }
        this.logger.warn("Characteristic '{}' is missing on device '{}'.", (Object)characteristic.getUuid(), (Object)this.address);
        return false;
    }

    public boolean enableNotifications(BluetoothDescriptor descriptor) {
        if (this.device == null || !this.device.getConnected()) {
            throw new IllegalStateException("TinyB device is not set or not connected");
        }
        BluetoothGattDescriptor d = this.getTinybDescriptorByUUID(descriptor.getUuid().toString());
        if (d != null) {
            d.enableValueNotifications(value -> {
                this.logger.debug("Received new value '{}' for descriptor '{}' of device '{}'", new Object[]{value, descriptor.getUuid(), this.address});
                descriptor.setValue(value);
                this.notifyListeners(BluetoothDevice.BluetoothEventType.DESCRIPTOR_UPDATED, new Object[]{descriptor});
            });
            return true;
        }
        this.logger.warn("Descriptor '{}' is missing on device '{}'.", (Object)descriptor.getUuid(), (Object)this.address);
        return false;
    }

    public boolean disableNotifications(BluetoothDescriptor descriptor) {
        if (this.device == null) {
            throw new IllegalStateException("TinyB device is not yet set");
        }
        BluetoothGattDescriptor d = this.getTinybDescriptorByUUID(descriptor.getUuid().toString());
        if (d != null) {
            d.disableValueNotifications();
            return true;
        }
        this.logger.warn("Descriptor '{}' is missing on device '{}'.", (Object)descriptor.getUuid(), (Object)this.address);
        return false;
    }

    private BluetoothGattCharacteristic getTinybCharacteristicByUUID(String uuid) {
        for (BluetoothGattService service : this.device.getServices()) {
            for (BluetoothGattCharacteristic c : service.getCharacteristics()) {
                if (!c.getUUID().equals(uuid)) continue;
                return c;
            }
        }
        return null;
    }

    private BluetoothGattDescriptor getTinybDescriptorByUUID(String uuid) {
        for (BluetoothGattService service : this.device.getServices()) {
            for (BluetoothGattCharacteristic c : service.getCharacteristics()) {
                for (BluetoothGattDescriptor d : c.getDescriptors()) {
                    if (!d.getUUID().equals(uuid)) continue;
                    return d;
                }
            }
        }
        return null;
    }

    public void dispose() {
        this.disableNotifications();
    }
}

