/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.smarthome.automation.module.script.ScriptEngineFactory;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineFactory.class})
public class NashornScriptEngineFactory
implements ScriptEngineFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ScriptEngineManager engineManager = new ScriptEngineManager();

    @Override
    public List<String> getLanguages() {
        return Arrays.asList("js", "javascript", "application/javascript");
    }

    @Override
    public void scopeValues(ScriptEngine engine, Map<String, Object> scopeValues) {
        HashSet<String> expressions = new HashSet<String>();
        for (Map.Entry<String, Object> entry : scopeValues.entrySet()) {
            engine.put(entry.getKey(), entry.getValue());
            if (!(entry.getValue() instanceof Class)) continue;
            expressions.add(String.format("%s = %s.static;", entry.getKey(), entry.getKey()));
        }
        String scriptToEval = String.join((CharSequence)"\n", expressions);
        try {
            engine.eval(scriptToEval);
        }
        catch (ScriptException e) {
            this.logger.error("ScriptException while importing scope: {}", (Object)e.getMessage());
        }
    }

    @Override
    public ScriptEngine createScriptEngine(String fileExtension) {
        ScriptEngine engine = this.engineManager.getEngineByExtension(fileExtension);
        if (engine == null) {
            engine = this.engineManager.getEngineByName(fileExtension);
        }
        if (engine == null) {
            engine = this.engineManager.getEngineByMimeType(fileExtension);
        }
        return engine;
    }

    @Override
    public boolean isSupported(String fileExtension) {
        return this.getLanguages().contains(fileExtension);
    }
}

