/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http.internal;

import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.io.net.http.HttpClientFactory;
import org.eclipse.smarthome.io.net.http.HttpClientInitializationException;
import org.eclipse.smarthome.io.net.http.TrustManagerProvider;
import org.eclipse.smarthome.io.net.http.WebSocketFactory;
import org.eclipse.smarthome.io.net.http.internal.ExtensibleTrustManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.webclient")
@NonNullByDefault
public class WebClientFactoryImpl
implements HttpClientFactory,
WebSocketFactory {
    private final Logger logger = LoggerFactory.getLogger(WebClientFactoryImpl.class);
    private static final String CONFIG_MIN_THREADS_SHARED = "minThreadsShared";
    private static final String CONFIG_MAX_THREADS_SHARED = "maxThreadsShared";
    private static final String CONFIG_KEEP_ALIVE_SHARED = "keepAliveTimeoutShared";
    private static final String CONFIG_MIN_THREADS_CUSTOM = "minThreadsCustom";
    private static final String CONFIG_MAX_THREADS_CUSTOM = "maxThreadsCustom";
    private static final String CONFIG_KEEP_ALIVE_CUSTOM = "keepAliveTimeoutCustom";
    private static final int MIN_CONSUMER_NAME_LENGTH = 4;
    private static final int MAX_CONSUMER_NAME_LENGTH = 20;
    private static final Pattern CONSUMER_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]*");
    private volatile @Nullable TrustManagerProvider trustmanagerProvider;
    @NonNullByDefault(value={})
    private ExtensibleTrustManager extensibleTrustManager;
    @NonNullByDefault(value={})
    private QueuedThreadPool threadPool;
    @NonNullByDefault(value={})
    private HttpClient commonHttpClient;
    @NonNullByDefault(value={})
    private WebSocketClient commonWebSocketClient;
    private int minThreadsShared;
    private int maxThreadsShared;
    private int keepAliveTimeoutShared;
    private int minThreadsCustom;
    private int maxThreadsCustom;
    private int keepAliveTimeoutCustom;

    @Activate
    protected void activate(Map<String, Object> parameters) {
        this.getConfigParameters(parameters);
    }

    @Modified
    protected void modified(Map<String, Object> parameters) {
        this.getConfigParameters(parameters);
        if (this.threadPool != null) {
            this.threadPool.setMinThreads(this.minThreadsShared);
            this.threadPool.setMaxThreads(this.maxThreadsShared);
            this.threadPool.setIdleTimeout(this.keepAliveTimeoutShared * 1000);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.commonHttpClient != null) {
            try {
                this.commonHttpClient.stop();
            }
            catch (Exception e) {
                this.logger.error("error while stopping shared Jetty http client", (Throwable)e);
            }
            this.commonHttpClient = null;
            this.logger.debug("Jetty shared http client stopped");
        }
        if (this.commonWebSocketClient != null) {
            try {
                this.commonWebSocketClient.stop();
            }
            catch (Exception e) {
                this.logger.error("error while stopping shared Jetty web socket client", (Throwable)e);
            }
            this.commonWebSocketClient = null;
            this.logger.debug("Jetty shared web socket client stopped");
        }
        this.threadPool = null;
    }

    @Override
    @Deprecated
    public HttpClient createHttpClient(String consumerName, String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint must not be null");
        this.logger.debug("http client for endpoint {} requested", (Object)endpoint);
        this.checkConsumerName(consumerName);
        return this.createHttpClientInternal(consumerName, endpoint, false, null);
    }

    @Override
    public HttpClient createHttpClient(String consumerName) {
        this.logger.debug("http client for consumer {} requested", (Object)consumerName);
        this.checkConsumerName(consumerName);
        return this.createHttpClientInternal(consumerName, null, false, null);
    }

    @Override
    @Deprecated
    public WebSocketClient createWebSocketClient(String consumerName, String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint must not be null");
        this.logger.debug("web socket client for endpoint {} requested", (Object)endpoint);
        this.checkConsumerName(consumerName);
        return this.createWebSocketClientInternal(consumerName, endpoint, false, null);
    }

    @Override
    public WebSocketClient createWebSocketClient(String consumerName) {
        this.logger.debug("web socket client for consumer {} requested", (Object)consumerName);
        this.checkConsumerName(consumerName);
        return this.createWebSocketClientInternal(consumerName, null, false, null);
    }

    @Override
    public HttpClient getCommonHttpClient() {
        this.initialize();
        this.logger.debug("shared http client requested");
        return this.commonHttpClient;
    }

    @Override
    public WebSocketClient getCommonWebSocketClient() {
        this.initialize();
        this.logger.debug("shared web socket client requested");
        return this.commonWebSocketClient;
    }

    private void getConfigParameters(Map<String, Object> parameters) {
        this.minThreadsShared = this.getConfigParameter(parameters, CONFIG_MIN_THREADS_SHARED, 10);
        this.maxThreadsShared = this.getConfigParameter(parameters, CONFIG_MAX_THREADS_SHARED, 40);
        this.keepAliveTimeoutShared = this.getConfigParameter(parameters, CONFIG_KEEP_ALIVE_SHARED, 10);
        this.minThreadsCustom = this.getConfigParameter(parameters, CONFIG_MIN_THREADS_CUSTOM, 5);
        this.maxThreadsCustom = this.getConfigParameter(parameters, CONFIG_MAX_THREADS_CUSTOM, 10);
        this.keepAliveTimeoutCustom = this.getConfigParameter(parameters, CONFIG_KEEP_ALIVE_CUSTOM, 10);
    }

    private int getConfigParameter(Map<String, Object> parameters, String parameter, int defaultValue) {
        if (parameters == null) {
            return defaultValue;
        }
        Object value = parameters.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("ignoring invalid value {} for parameter {}", value, (Object)parameter);
                return defaultValue;
            }
        }
        this.logger.warn("ignoring invalid type {} for parameter {}", (Object)value.getClass().getName(), (Object)parameter);
        return defaultValue;
    }

    private synchronized void initialize() {
        if (this.threadPool == null || this.commonHttpClient == null || this.commonWebSocketClient == null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public @Nullable Void run() {
                        if (WebClientFactoryImpl.this.threadPool == null) {
                            WebClientFactoryImpl.this.threadPool = WebClientFactoryImpl.this.createThreadPool("common", WebClientFactoryImpl.this.minThreadsShared, WebClientFactoryImpl.this.maxThreadsShared, WebClientFactoryImpl.this.keepAliveTimeoutShared);
                        }
                        if (WebClientFactoryImpl.this.commonHttpClient == null) {
                            WebClientFactoryImpl.this.commonHttpClient = WebClientFactoryImpl.this.createHttpClientInternal("common", null, true, WebClientFactoryImpl.this.threadPool);
                            WebClientFactoryImpl.this.threadPool.setStopTimeout(0L);
                            WebClientFactoryImpl.this.logger.debug("Jetty shared http client created");
                        }
                        if (WebClientFactoryImpl.this.commonWebSocketClient == null) {
                            WebClientFactoryImpl.this.commonWebSocketClient = WebClientFactoryImpl.this.createWebSocketClientInternal("common", null, true, WebClientFactoryImpl.this.threadPool);
                            WebClientFactoryImpl.this.logger.debug("Jetty shared web socket client created");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new HttpClientInitializationException("unexpected checked exception during initialization of the jetty client", cause);
            }
        }
    }

    private HttpClient createHttpClientInternal(final String consumerName, final @Nullable String endpoint, final boolean startClient, final @Nullable QueuedThreadPool threadPool) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<HttpClient>(){

                @Override
                public HttpClient run() {
                    if (WebClientFactoryImpl.this.logger.isDebugEnabled()) {
                        if (endpoint == null) {
                            WebClientFactoryImpl.this.logger.debug("creating http client for consumer {}", (Object)consumerName);
                        } else {
                            WebClientFactoryImpl.this.logger.debug("creating http client for consumer {}, endpoint {}", (Object)consumerName, (Object)endpoint);
                        }
                    }
                    HttpClient httpClient = new HttpClient(WebClientFactoryImpl.this.createSslContextFactory(endpoint));
                    httpClient.setMaxConnectionsPerDestination(2);
                    if (threadPool != null) {
                        httpClient.setExecutor((Executor)threadPool);
                    } else {
                        QueuedThreadPool queuedThreadPool = WebClientFactoryImpl.this.createThreadPool(consumerName, WebClientFactoryImpl.this.minThreadsCustom, WebClientFactoryImpl.this.maxThreadsCustom, WebClientFactoryImpl.this.keepAliveTimeoutCustom);
                        httpClient.setExecutor((Executor)queuedThreadPool);
                    }
                    if (startClient) {
                        try {
                            httpClient.start();
                        }
                        catch (Exception e) {
                            WebClientFactoryImpl.this.logger.error("Could not start Jetty http client", (Throwable)e);
                            throw new HttpClientInitializationException("Could not start Jetty http client", e);
                        }
                    }
                    return httpClient;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the Jetty http client", cause);
        }
    }

    private WebSocketClient createWebSocketClientInternal(final String consumerName, final @Nullable String endpoint, final boolean startClient, final @Nullable QueuedThreadPool threadPool) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<WebSocketClient>(){

                @Override
                public WebSocketClient run() {
                    if (WebClientFactoryImpl.this.logger.isDebugEnabled()) {
                        if (endpoint == null) {
                            WebClientFactoryImpl.this.logger.debug("creating web socket client for consumer {}", (Object)consumerName);
                        } else {
                            WebClientFactoryImpl.this.logger.debug("creating web socket client for consumer {}, endpoint {}", (Object)consumerName, (Object)endpoint);
                        }
                    }
                    WebSocketClient webSocketClient = new WebSocketClient(WebClientFactoryImpl.this.createSslContextFactory(endpoint));
                    if (threadPool != null) {
                        webSocketClient.setExecutor((Executor)threadPool);
                    } else {
                        QueuedThreadPool queuedThreadPool = WebClientFactoryImpl.this.createThreadPool(consumerName, WebClientFactoryImpl.this.minThreadsCustom, WebClientFactoryImpl.this.maxThreadsCustom, WebClientFactoryImpl.this.keepAliveTimeoutCustom);
                        webSocketClient.setExecutor((Executor)queuedThreadPool);
                    }
                    if (startClient) {
                        try {
                            webSocketClient.start();
                        }
                        catch (Exception e) {
                            WebClientFactoryImpl.this.logger.error("Could not start Jetty web socket client", (Throwable)e);
                            throw new HttpClientInitializationException("Could not start Jetty web socket client", e);
                        }
                    }
                    return webSocketClient;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the Jetty web socket client", cause);
        }
    }

    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(maxThreads, minThreads, keepAliveTimeout * 1000);
        queuedThreadPool.setName("ESH-httpClient-" + consumerName);
        queuedThreadPool.setDaemon(true);
        return queuedThreadPool;
    }

    private void checkConsumerName(String consumerName) {
        Objects.requireNonNull(consumerName, "consumerName must not be null");
        if (consumerName.length() < 4) {
            throw new IllegalArgumentException("consumerName " + consumerName + " too short, minimum " + 4);
        }
        if (consumerName.length() > 20) {
            throw new IllegalArgumentException("consumerName " + consumerName + " too long, maximum " + 20);
        }
        if (!CONSUMER_NAME_PATTERN.matcher(consumerName).matches()) {
            throw new IllegalArgumentException("consumerName " + consumerName + " contains illegal character, allowed only [a-zA-Z0-9_-]");
        }
    }

    private SslContextFactory createSslContextFactory(@Nullable String endpoint) {
        if (endpoint == null) {
            return this.createSslContextFactoryFromExtensibleTrustManager();
        }
        return this.createSslContextFactoryFromTrustManagerProvider(endpoint);
    }

    private SslContextFactory createSslContextFactoryFromExtensibleTrustManager() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (this.extensibleTrustManager != null) {
            try {
                this.logger.debug("Setting up SSLContext for {}", (Object)this.extensibleTrustManager);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{this.extensibleTrustManager}, null);
                sslContextFactory.setSslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                throw new HttpClientInitializationException("Cannot create an TLS context!", ex);
            }
        }
        String[] excludeCipherSuites = new String[]{"^.*_(MD5)$"};
        sslContextFactory.setExcludeCipherSuites(excludeCipherSuites);
        return sslContextFactory;
    }

    @Deprecated
    private SslContextFactory createSslContextFactoryFromTrustManagerProvider(@Nullable String endpoint) {
        Stream<TrustManager> trustManagerStream;
        TrustManager[] trustManagers;
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (endpoint != null && this.trustmanagerProvider != null && (trustManagers = (TrustManager[])(trustManagerStream = this.trustmanagerProvider.getTrustManagers(endpoint)).toArray(TrustManager[]::new)).length > 0) {
            this.logger.debug("using custom trustmanagers (certificate pinning) for httpClient for endpoint {}", (Object)endpoint);
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagers, null);
                sslContextFactory.setSslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                throw new HttpClientInitializationException("Cannot create an TLS context for the endpoint '" + endpoint + "'!", ex);
            }
        }
        String[] excludeCipherSuites = new String[]{"^.*_(MD5)$"};
        sslContextFactory.setExcludeCipherSuites(excludeCipherSuites);
        return sslContextFactory;
    }

    @Reference
    protected void setExtensibleTrustManager(ExtensibleTrustManager extensibleTrustManager) {
        this.extensibleTrustManager = extensibleTrustManager;
    }

    protected void unsetExtensibleTrustManager(ExtensibleTrustManager extensibleTrustManager) {
        if (this.extensibleTrustManager == extensibleTrustManager) {
            this.extensibleTrustManager = null;
        }
    }

    @Deprecated
    @Reference(service=TrustManagerProvider.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setTrustmanagerProvider(TrustManagerProvider trustmanagerProvider) {
        this.trustmanagerProvider = trustmanagerProvider;
    }

    @Deprecated
    protected void unsetTrustmanagerProvider(TrustManagerProvider trustmanagerProvider) {
        if (this.trustmanagerProvider == trustmanagerProvider) {
            this.trustmanagerProvider = null;
        }
    }
}

