/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.core.ManagedRuleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.osgi.framework.Bundle;

public class RuleResourceBundleImporter
extends AbstractResourceBundleProvider<Rule> {
    protected ManagedRuleProvider mProvider;

    public RuleResourceBundleImporter() {
        this.path = "ESH-INF/automation/rules/";
    }

    protected void setManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.mProvider = mProvider;
    }

    @Override
    public void deactivate() {
        this.mProvider = null;
        super.deactivate();
    }

    @Override
    protected void processAutomationProvider(Bundle bundle) {
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        this.logger.debug("Parse rules from bundle '{}' ", (Object)bundle.getSymbolicName());
        Enumeration urlEnum = null;
        try {
            if (bundle.getState() != 1) {
                urlEnum = bundle.findEntries(this.path, null, true);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                Set<Rule> parsedObjects;
                URL url = (URL)urlEnum.nextElement();
                if (!(this.getPreviousPortfolio(vendor) == null || this.waitingProviders.get(bundle) != null && ((List)this.waitingProviders.get(bundle)).contains(url))) {
                    return;
                }
                if (url.getPath().endsWith(File.separator)) continue;
                String parserType = this.getParserType(url);
                Parser parser = (Parser)this.parsers.get(parserType);
                this.updateWaitingProviders(parser, bundle, url);
                if (parser == null || (parsedObjects = this.parseData(parser, url, bundle)) == null || parsedObjects.isEmpty()) continue;
                this.addNewProvidedObjects((List<String>)null, (List<String>)null, parsedObjects);
            }
            this.putNewPortfolio(vendor, Collections.emptyList());
        }
    }

    @Override
    protected void addNewProvidedObjects(List<String> newPortfolio, List<String> previousPortfolio, Set<Rule> parsedObjects) {
        if (parsedObjects != null && !parsedObjects.isEmpty()) {
            for (Rule rule : parsedObjects) {
                if (rule == null) continue;
                try {
                    this.mProvider.add((Identifiable)rule);
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("Not importing rule '{}' because: {}", new Object[]{rule.getUID(), e.getMessage(), e});
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Not importing rule '{}' since the rule registry is in an invalid state: {}", (Object)rule.getUID(), (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    protected List<String> getPreviousPortfolio(Vendor vendor) {
        List portfolio = (List)this.providerPortfolio.get(vendor);
        if (portfolio == null) {
            for (Vendor v : this.providerPortfolio.keySet()) {
                if (!v.getVendorSymbolicName().equals(vendor.getVendorSymbolicName())) continue;
                return (List)this.providerPortfolio.get(v);
            }
        }
        return portfolio;
    }

    @Override
    protected void processAutomationProviderUninstalled(Bundle bundle) {
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        this.waitingProviders.remove(bundle);
        this.providerPortfolio.remove(vendor);
    }

    @Override
    protected String getUID(Rule parsedObject) {
        return parsedObject.getUID();
    }
}

