/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.util.ActionBuilder;
import org.eclipse.smarthome.automation.core.util.ConditionBuilder;
import org.eclipse.smarthome.automation.core.util.ModuleBuilder;
import org.eclipse.smarthome.automation.core.util.TriggerBuilder;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

public class ModuleI18nUtil {
    public static <T extends Module> List<T> getLocalizedModules(TranslationProvider i18nProvider, List<T> modules, Bundle bundle, String uid, String prefix, Locale locale) {
        ArrayList<Module> lmodules = new ArrayList<Module>();
        for (Module module : modules) {
            String label = ModuleI18nUtil.getModuleLabel(i18nProvider, bundle, uid, module.getId(), module.getLabel(), prefix, locale);
            String description = ModuleI18nUtil.getModuleDescription(i18nProvider, bundle, uid, prefix, module.getId(), module.getDescription(), locale);
            lmodules.add(ModuleI18nUtil.createLocalizedModule(module, label, description));
        }
        return lmodules;
    }

    private static <T extends Module> T createLocalizedModule(T module, String label, String description) {
        if (module instanceof Action) {
            return (T)ModuleI18nUtil.createLocalizedAction((Action)module, label, description);
        }
        if (module instanceof Condition) {
            return (T)ModuleI18nUtil.createLocalizedCondition((Condition)module, label, description);
        }
        if (module instanceof Trigger) {
            return (T)ModuleI18nUtil.createLocalizedTrigger((Trigger)module, label, description);
        }
        return null;
    }

    private static Trigger createLocalizedTrigger(Trigger module, String label, String description) {
        return ((TriggerBuilder)((TriggerBuilder)ModuleBuilder.createTrigger((Trigger)module).withLabel(label)).withDescription(description)).build();
    }

    private static Condition createLocalizedCondition(Condition module, String label, String description) {
        return ((ConditionBuilder)((ConditionBuilder)ModuleBuilder.createCondition((Condition)module).withLabel(label)).withDescription(description)).build();
    }

    private static Action createLocalizedAction(Action module, String label, String description) {
        return ((ActionBuilder)((ActionBuilder)ModuleBuilder.createAction((Action)module).withLabel(label)).withDescription(description)).build();
    }

    private static String getModuleLabel(TranslationProvider i18nProvider, Bundle bundle, String uid, String moduleName, String defaultLabel, String prefix, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> ModuleI18nUtil.inferModuleKey(prefix, uid, moduleName, "label"));
        return i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private static String getModuleDescription(TranslationProvider i18nProvider, Bundle bundle, String uid, String moduleName, String defaultDescription, String prefix, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> ModuleI18nUtil.inferModuleKey(prefix, uid, moduleName, "description"));
        return i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private static String inferModuleKey(String prefix, String uid, String moduleName, String lastSegment) {
        return String.valueOf(prefix) + uid + ".input." + moduleName + "." + lastSegment;
    }
}

