/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.http.internal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.io.http.Handler;
import org.eclipse.smarthome.io.http.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchHandler
implements Handler {
    private final Logger logger = LoggerFactory.getLogger(CatchHandler.class);
    private final Handler delegate;

    public CatchHandler(Handler delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getPriority() {
        return this.delegate.getPriority();
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
        try {
            this.delegate.handle(request, response, context);
        }
        catch (Exception e) {
            if (!context.hasError()) {
                context.error(e);
            }
            this.logger.error("Could not handle exception thrown by delegate handler {}", (Object)this.delegate, (Object)e);
        }
    }

    @Override
    public void handleError(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
        this.delegate.handleError(request, response, context);
    }
}

