/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DigitalIoConfig;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractDigitalOwDevice
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(AbstractDigitalOwDevice.class);
    protected OwDeviceParameterMap fullInParam = new OwDeviceParameterMap();
    protected OwDeviceParameterMap fullOutParam = new OwDeviceParameterMap();
    protected final List<DigitalIoConfig> ioConfig = new ArrayList<DigitalIoConfig>();

    public AbstractDigitalOwDevice(String sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() throws OwException {
        Thing thing = this.callback.getThing();
        OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider = this.callback.getDynamicStateDescriptionProvider();
        Integer i = 0;
        while (i < this.ioConfig.size()) {
            String channelId = this.ioConfig.get(i).getChannelId();
            Channel channel = thing.getChannel(channelId);
            if (channel != null) {
                Configuration channelConfig = channel.getConfiguration();
                try {
                    if (channelConfig.get("mode") != null) {
                        this.ioConfig.get(i).setIoMode((String)channelConfig.get("mode"));
                    }
                    if (channelConfig.get("logic") != null) {
                        this.ioConfig.get(i).setIoLogic((String)channelConfig.get("logic"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new OwException(String.valueOf(channelId) + " has invalid configuration");
                }
                if (dynamicStateDescriptionProvider != null) {
                    dynamicStateDescriptionProvider.setDescription(this.ioConfig.get(i).getChannelUID(), new StateDescription(null, null, null, null, this.ioConfig.get(i).isInput().booleanValue(), null));
                } else {
                    this.logger.debug("state description may be inaccurate, state description provider not available in thing {}", (Object)thing.getUID());
                }
            } else {
                throw new OwException(String.valueOf(channelId) + " not found");
            }
            this.logger.debug("configured {} channel {}: {}", new Object[]{thing.getUID(), i, this.ioConfig.get(i)});
            i = i + 1;
        }
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue()) {
            List<Boolean> statesSensed = Util.decimalTypeToBooleanList((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.fullInParam));
            List<Boolean> statesPIO = Util.decimalTypeToBooleanList((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.fullOutParam));
            int i = 0;
            while (i < this.ioConfig.size()) {
                State state;
                if (this.ioConfig.get(i).isInput().booleanValue()) {
                    state = this.ioConfig.get(i).convertState(statesSensed.get(i));
                    this.logger.trace("{} IN{}: raw {}, final {}", new Object[]{this.sensorId, i, statesSensed, state});
                } else {
                    state = this.ioConfig.get(i).convertState(statesPIO.get(i));
                    this.logger.trace("{} OUT{}: raw {}, final {}", new Object[]{this.sensorId, i, statesPIO, state});
                }
                this.callback.postUpdate(this.ioConfig.get(i).getChannelId(), state);
                ++i;
            }
        }
    }

    public int getChannelCount() {
        return this.ioConfig.size();
    }

    public boolean writeChannel(OwBaseBridgeHandler bridgeHandler, Integer ioChannel, Command command) {
        if (ioChannel < this.getChannelCount()) {
            try {
                if (this.ioConfig.get(ioChannel).isOutput().booleanValue()) {
                    DecimalType value = (DecimalType)((OnOffType)command).as(DecimalType.class);
                    if (value == null) {
                        throw new OwException("command is null");
                    }
                    bridgeHandler.writeDecimalType(this.sensorId, this.ioConfig.get(ioChannel).getParameter(), value);
                    return true;
                }
                return false;
            }
            catch (OwException e) {
                this.logger.info("could not write {} to {}: {}", new Object[]{command, ioChannel, e.getMessage()});
                return false;
            }
        }
        throw new IllegalArgumentException("channel number out of range");
    }
}

