/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS18x20
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(DS18x20.class);
    private static final OwDeviceParameterMap TEMPERATURE_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        }
    };
    private boolean ignorePOR = false;

    public DS18x20(String sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() throws OwException {
        Thing thing = this.callback.getThing();
        Channel temperatureChannel = thing.getChannel("temperature");
        if (temperatureChannel != null) {
            Configuration channelConfiguration = temperatureChannel.getConfiguration();
            if (channelConfiguration.containsKey("resolution")) {
                TEMPERATURE_PARAMETER.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature" + (String)channelConfiguration.get("resolution")));
            } else {
                TEMPERATURE_PARAMETER.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
            }
            this.ignorePOR = channelConfiguration.containsKey("ignorepor") ? (Boolean)channelConfiguration.get("ignorepor") : false;
        } else {
            throw new OwException("temperature not found");
        }
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue() && this.enabledChannels.contains("temperature")) {
            QuantityType temperature = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, TEMPERATURE_PARAMETER)), SIUnits.CELSIUS);
            this.logger.trace("read temperature {} from {}", (Object)temperature, (Object)this.sensorId);
            if (this.ignorePOR && Double.compare(temperature.doubleValue(), 85.0) == 0) {
                this.logger.trace("ignored POR value from sensor {}", (Object)this.sensorId);
            } else {
                this.callback.postUpdate("temperature", (State)temperature);
            }
        }
    }
}

