/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.discovery;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.discovery.OwDiscoveryItem;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(OwDiscoveryService.class);
    private final OwBaseBridgeHandler owBridgeHandler;

    public OwDiscoveryService(OwBaseBridgeHandler owBridgeHandler) {
        super(OwBindingConstants.SUPPORTED_THING_TYPES, 60, false);
        this.owBridgeHandler = owBridgeHandler;
        this.logger.debug("registering discovery service for {}", (Object)owBridgeHandler);
    }

    public void startScan() {
        String mainSensor;
        String associatedSensor;
        List<String> directory;
        ThingUID bridgeUID = this.owBridgeHandler.getThing().getUID();
        try {
            directory = this.owBridgeHandler.getDirectory();
        }
        catch (OwException owException) {
            this.logger.info("could not get directory for {}", (Object)bridgeUID);
            return;
        }
        Collections.sort(directory);
        HashMap<String, OwDiscoveryItem> owDiscoveryItems = new HashMap<String, OwDiscoveryItem>();
        HashMap<String, String> associationMap = new HashMap<String, String>();
        for (String directoryEntry : directory) {
            Matcher discoveryMatch = OwBindingConstants.SENSOR_ID_PATTERN.matcher(directoryEntry);
            if (!discoveryMatch.matches()) continue;
            String sensorId = discoveryMatch.group(1);
            try {
                OwDiscoveryItem owDiscoveryItem = new OwDiscoveryItem(this.owBridgeHandler, sensorId);
                owDiscoveryItems.put(owDiscoveryItem.getSensorId(), owDiscoveryItem);
                if (owDiscoveryItem.hasAssociatedSensorIds()) {
                    for (String associatedSensorId : owDiscoveryItem.getAssociatedSensorIds()) {
                        associationMap.put(associatedSensorId, owDiscoveryItem.getSensorId());
                    }
                }
                this.logger.trace("found sensor {} (id: {})", (Object)owDiscoveryItem.getSensorType(), (Object)sensorId);
            }
            catch (OwException e) {
                this.logger.info("sensor-id {}: {}", (Object)sensorId, (Object)e.getMessage());
            }
        }
        Iterator associationMapIterator = associationMap.entrySet().iterator();
        while (associationMapIterator.hasNext()) {
            Map.Entry entry = associationMapIterator.next();
            associatedSensor = (String)entry.getKey();
            mainSensor = (String)entry.getValue();
            if (associatedSensor.substring(0, 2).equals("26")) continue;
            if (owDiscoveryItems.containsKey(associatedSensor) && owDiscoveryItems.containsKey(mainSensor)) {
                ((OwDiscoveryItem)owDiscoveryItems.get(mainSensor)).addAssociatedSensor((OwDiscoveryItem)owDiscoveryItems.get(associatedSensor));
                owDiscoveryItems.remove(associatedSensor);
            } else {
                this.logger.info("cannot resolve association {}->{}, please check your sensor hardware", (Object)associatedSensor, (Object)mainSensor);
            }
            associationMapIterator.remove();
        }
        for (Map.Entry entry : associationMap.entrySet()) {
            associatedSensor = (String)entry.getKey();
            mainSensor = (String)entry.getValue();
            if (owDiscoveryItems.containsKey(associatedSensor) && owDiscoveryItems.containsKey(mainSensor)) {
                if (((OwDiscoveryItem)owDiscoveryItems.get(associatedSensor)).hasAssociatedSensors()) {
                    ((OwDiscoveryItem)owDiscoveryItems.get(mainSensor)).addAssociatedSensors(((OwDiscoveryItem)owDiscoveryItems.get(associatedSensor)).getAssociatedSensors());
                    ((OwDiscoveryItem)owDiscoveryItems.get(associatedSensor)).clearAssociatedSensors();
                }
                ((OwDiscoveryItem)owDiscoveryItems.get(mainSensor)).addAssociatedSensor((OwDiscoveryItem)owDiscoveryItems.get(associatedSensor));
                owDiscoveryItems.remove(associatedSensor);
                continue;
            }
            this.logger.info("cannot resolve association {}->{}, please check your sensor hardware", entry.getKey(), entry.getValue());
        }
        for (OwDiscoveryItem owDiscoveryItem : owDiscoveryItems.values()) {
            owDiscoveryItem.checkSensorType();
            ThingTypeUID thingTypeUID = owDiscoveryItem.getThingTypeUID();
            String normalizedId = owDiscoveryItem.getNormalizedSensorId();
            ThingUID thingUID = new ThingUID(thingTypeUID, bridgeUID, normalizedId);
            this.logger.debug("created thing UID {} for sensor {}, type {}", new Object[]{thingUID, owDiscoveryItem.getSensorId(), owDiscoveryItem.getSensorType()});
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("modelId", owDiscoveryItem.getSensorType().toString());
            properties.put("vendor", owDiscoveryItem.getVendor());
            properties.put("sensorCount", String.valueOf(owDiscoveryItem.getAssociatedSensorCount()));
            if (thingTypeUID.equals((Object)OwBindingConstants.THING_TYPE_BMS)) {
                properties.put("id", owDiscoveryItem.getSensorId());
                properties.put("id1", owDiscoveryItem.getAssociatedSensors().get(0).getSensorId());
                properties.put("temperaturesensor", "DS18B20");
                properties.put("lightsensor", String.valueOf(owDiscoveryItem.getSensorType() == OwSensorType.BMS_S));
            } else if (thingTypeUID.equals((Object)OwBindingConstants.THING_TYPE_AMS)) {
                properties.put("id", owDiscoveryItem.getSensorId());
                properties.put("id1", owDiscoveryItem.getAssociatedSensors(OwSensorType.DS18B20).get(0).getSensorId());
                properties.put("id2", owDiscoveryItem.getAssociatedSensors(OwSensorType.MS_TV).get(0).getSensorId());
                properties.put("id3", owDiscoveryItem.getAssociatedSensors(OwSensorType.DS2413).get(0).getSensorId());
                properties.put("temperaturesensor", "DS18B20");
                properties.put("lightsensor", String.valueOf(owDiscoveryItem.getSensorType() == OwSensorType.AMS_S));
            } else {
                properties.put("id", owDiscoveryItem.getSensorId());
            }
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withThingType(thingTypeUID).withProperties(properties).withBridge(bridgeUID).withLabel(owDiscoveryItem.getLabel()).build();
            this.thingDiscovered(discoveryResult);
        }
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime());
    }
}

