/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractDigitalOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2405;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2406_DS2413;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2408;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DigitalIOThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(OwBindingConstants.THING_TYPE_DIGITALIO, OwBindingConstants.THING_TYPE_DIGITALIO2, OwBindingConstants.THING_TYPE_DIGITALIO8));
    private final Logger logger = LoggerFactory.getLogger(DigitalIOThingHandler.class);

    public DigitalIOThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider);
    }

    @Override
    public void handleCommand(ChannelUID channelUID, Command command) {
        Integer ioChannel;
        if (command instanceof OnOffType && (ioChannel = Integer.valueOf(channelUID.getId().substring(channelUID.getId().length() - 1))) != null && ioChannel < ((AbstractDigitalOwDevice)this.sensors.get(0)).getChannelCount()) {
            Bridge bridge = this.getBridge();
            if (bridge != null) {
                OwBaseBridgeHandler bridgeHandler = (OwBaseBridgeHandler)bridge.getHandler();
                if (bridgeHandler != null) {
                    if (!((AbstractDigitalOwDevice)this.sensors.get(0)).writeChannel(bridgeHandler, ioChannel, command)) {
                        this.logger.debug("writing to channel {} in thing {} not permitted (input channel)", (Object)channelUID, (Object)this.thing.getUID());
                    }
                } else {
                    this.logger.warn("bridge handler not found");
                }
            } else {
                this.logger.warn("bridge not found");
            }
        }
        super.handleCommand(channelUID, command);
    }

    @Override
    public void initialize() {
        Configuration configuration = this.getConfig();
        Map properties = this.editProperties();
        if (!super.configure()) {
            return;
        }
        if (this.getThing().getStatus() == ThingStatus.OFFLINE) {
            return;
        }
        if (!properties.containsKey("modelId")) {
            this.scheduler.execute(() -> this.updateSensorProperties());
        }
        if (this.thing.getThingTypeUID().equals((Object)OwBindingConstants.THING_TYPE_DIGITALIO)) {
            this.sensors.add(new DS2405((String)this.sensorIds.get(0), this));
        } else if (this.thing.getThingTypeUID().equals((Object)OwBindingConstants.THING_TYPE_DIGITALIO2)) {
            this.sensors.add(new DS2406_DS2413((String)this.sensorIds.get(0), this));
        } else if (this.thing.getThingTypeUID().equals((Object)OwBindingConstants.THING_TYPE_DIGITALIO8)) {
            this.sensors.add(new DS2408((String)this.sensorIds.get(0), this));
        }
        try {
            ((AbstractOwDevice)this.sensors.get(0)).configureChannels();
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        if (configuration.get("refresh") == null) {
            this.refreshInterval = 10000L;
        }
        this.updateStatus(ThingStatus.UNKNOWN, ThingStatusDetail.NONE);
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, long now) {
        try {
            Boolean forcedRefresh = this.lastRefresh == 0L;
            if (now >= this.lastRefresh + this.refreshInterval) {
                this.logger.trace("refreshing {}", (Object)this.thing.getUID());
                this.lastRefresh = now;
                if (!((AbstractOwDevice)this.sensors.get(0)).checkPresence(bridgeHandler).booleanValue()) {
                    return;
                }
                ((AbstractOwDevice)this.sensors.get(0)).refresh(bridgeHandler, forcedRefresh);
            }
        }
        catch (OwException e) {
            this.logger.debug("{}: refresh exception {}", (Object)this.thing.getUID(), (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "refresh exception");
            return;
        }
    }
}

