/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.owserver;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public enum OwserverMessageType {
    ERROR(0),
    NOP(1),
    READ(2),
    WRITE(3),
    DIR(4),
    SIZE(5),
    PRESENT(6),
    DIRALL(7),
    GET(8),
    DIRALLSLASH(9),
    GETSLASH(10);

    private final int messageType;

    private OwserverMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getValue() {
        return this.messageType;
    }

    public static OwserverMessageType fromInt(int messageType) throws IllegalArgumentException {
        OwserverMessageType[] owserverMessageTypeArray = OwserverMessageType.values();
        int n = owserverMessageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OwserverMessageType value = owserverMessageTypeArray[n2];
            if (value.getValue() == messageType) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }
}

