/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.common;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmGatewayInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;

public class HomematicConfig {
    private static final String ISO_ENCODING = "ISO-8859-1";
    private static final String UTF_ENCODING = "UTF-8";
    private static final String GATEWAY_TYPE_AUTO = "AUTO";
    private static final String GATEWAY_TYPE_CCU = "CCU";
    private static final String GATEWAY_TYPE_NOCCU = "NOCCU";
    private static final int DEFAULT_PORT_RF = 2001;
    private static final int DEFAULT_PORT_WIRED = 2000;
    private static final int DEFAULT_PORT_HMIP = 2010;
    private static final int DEFAULT_PORT_CUXD = 8701;
    private static final int DEFAULT_PORT_GROUP = 9292;
    public static final int DEFAULT_INSTALL_MODE_DURATION = 60;
    private String gatewayAddress;
    private String gatewayType = "AUTO";
    private int rfPort;
    private int wiredPort;
    private int hmIpPort;
    private int cuxdPort;
    private int groupPort;
    private String callbackHost;
    private int xmlCallbackPort;
    private int binCallbackPort;
    private int socketMaxAlive = 900;
    private int timeout = 15;
    private int installModeDuration = 60;
    private long discoveryTimeToLive = -1L;
    private boolean unpairOnDeletion = false;
    private boolean factoryResetOnDeletion = false;
    private HmGatewayInfo gatewayInfo;

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public void setGatewayAddress(String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
    }

    public String getCallbackHost() {
        return this.callbackHost;
    }

    public void setCallbackHost(String callbackHost) {
        this.callbackHost = callbackHost;
    }

    @Deprecated
    public void setCallbackPort(int callbackPort) {
        this.binCallbackPort = callbackPort;
    }

    public int getXmlCallbackPort() {
        return this.xmlCallbackPort;
    }

    public void setXmlCallbackPort(int xmlCallbackPort) {
        this.xmlCallbackPort = xmlCallbackPort;
    }

    public int getBinCallbackPort() {
        return this.binCallbackPort;
    }

    public void setBinCallbackPort(int binCallbackPort) {
        this.binCallbackPort = binCallbackPort;
    }

    public HmGatewayInfo getGatewayInfo() {
        return this.gatewayInfo;
    }

    public void setGatewayInfo(HmGatewayInfo gatewayInfo) {
        this.gatewayInfo = gatewayInfo;
    }

    public int getSocketMaxAlive() {
        return this.socketMaxAlive;
    }

    public void setSocketMaxAlive(int socketMaxAlive) {
        this.socketMaxAlive = socketMaxAlive;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public long getDiscoveryTimeToLive() {
        return this.discoveryTimeToLive;
    }

    public void setDiscoveryTimeToLive(long discoveryTimeToLive) {
        this.discoveryTimeToLive = discoveryTimeToLive;
    }

    public String getGatewayType() {
        return this.gatewayType;
    }

    public void setGatewayType(String gatewayType) {
        this.gatewayType = gatewayType;
    }

    public int getInstallModeDuration() {
        return this.installModeDuration;
    }

    public void setInstallModeDuration(int installModeDuration) {
        this.installModeDuration = installModeDuration;
    }

    public boolean isUnpairOnDeletion() {
        return this.unpairOnDeletion;
    }

    public void setUnpairOnDeletion(boolean unpairOnDeletion) {
        this.unpairOnDeletion = unpairOnDeletion;
    }

    public boolean isFactoryResetOnDeletion() {
        return this.factoryResetOnDeletion;
    }

    public void setFactoryResetOnDeletion(boolean factoryResetOnDeletion) {
        this.factoryResetOnDeletion = factoryResetOnDeletion;
    }

    public String getTclRegaUrl() {
        return "http://" + this.gatewayAddress + ":8181/tclrega.exe";
    }

    public int getRpcPort(HmChannel channel) {
        return this.getRpcPort(channel.getDevice().getHmInterface());
    }

    public int getRpcPort(HmInterface hmInterface) {
        if (HmInterface.WIRED.equals((Object)hmInterface)) {
            return this.getWiredPort();
        }
        if (HmInterface.HMIP.equals((Object)hmInterface)) {
            return this.getHmIpPort();
        }
        if (HmInterface.CUXD.equals((Object)hmInterface)) {
            return this.getCuxdPort();
        }
        if (HmInterface.GROUP.equals((Object)hmInterface)) {
            return this.getGroupPort();
        }
        return this.getRfPort();
    }

    private int getRfPort() {
        return this.rfPort == 0 ? 2001 : this.rfPort;
    }

    private int getWiredPort() {
        return this.wiredPort == 0 ? 2000 : this.wiredPort;
    }

    private int getHmIpPort() {
        return this.hmIpPort == 0 ? 2010 : this.hmIpPort;
    }

    private int getCuxdPort() {
        return this.cuxdPort == 0 ? 8701 : this.cuxdPort;
    }

    public int getGroupPort() {
        return this.groupPort == 0 ? 9292 : this.groupPort;
    }

    public boolean hasWiredPort() {
        return this.wiredPort != 0;
    }

    public boolean hasHmIpPort() {
        return this.hmIpPort != 0;
    }

    public boolean hasCuxdPort() {
        return this.cuxdPort != 0;
    }

    public boolean hasGroupPort() {
        return this.groupPort != 0;
    }

    public boolean hasRfPort() {
        return this.rfPort != 0;
    }

    public String getEncoding() {
        if (this.gatewayInfo != null && this.gatewayInfo.isHomegear()) {
            return UTF_ENCODING;
        }
        return ISO_ENCODING;
    }

    public boolean isCCUType() {
        return this.gatewayType.equalsIgnoreCase(GATEWAY_TYPE_CCU);
    }

    public boolean isNoCCUType() {
        return this.gatewayType.equalsIgnoreCase(GATEWAY_TYPE_NOCCU);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("gatewayAddress", (Object)this.gatewayAddress).append("callbackHost", (Object)this.callbackHost).append("xmlCallbackPort", this.xmlCallbackPort).append("binCallbackPort", this.binCallbackPort).append("gatewayType", (Object)this.gatewayType).append("rfPort", this.getRfPort()).append("wiredPort", this.getWiredPort()).append("hmIpPort", this.getHmIpPort()).append("cuxdPort", this.getCuxdPort()).append("groupPort", this.getGroupPort()).append("timeout", this.timeout).append("discoveryTimeToLive", this.discoveryTimeToLive).append("installModeDuration", this.installModeDuration).append("socketMaxAlive", this.socketMaxAlive);
        return tsb.toString();
    }
}

