/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayAdapter;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.BinRpcClient;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.RpcClient;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.TransferMode;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownParameterSetException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.XmlRpcClient;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.ListBidcosInterfacesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.BinRpcServer;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcEventListener;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcServer;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.XmlRpcServer;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.BatteryTypeVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.ButtonVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.DeleteDeviceModeVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.DeleteDeviceVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.DisplayOptionsVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.DisplayTextVirtualDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.FirmwareVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.HmwIoModuleVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.InstallModeDurationVirtualDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.InstallModeVirtualDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.OnTimeAutomaticVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.ReloadAllFromGatewayVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.ReloadFromGatewayVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.ReloadRssiVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.RssiVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.SignalStrengthVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.StateContactVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.DelayedExecuter;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmGatewayInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmRssiInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHomematicGateway
implements RpcEventListener,
HomematicGateway,
VirtualGateway {
    private final Logger logger = LoggerFactory.getLogger(AbstractHomematicGateway.class);
    public static final double DEFAULT_DISABLE_DELAY = 2.0;
    private static final long CONNECTION_TRACKER_INTERVAL_SECONDS = 15L;
    private static final String GATEWAY_POOL_NAME = "homematicGateway";
    private final Map<TransferMode, RpcClient<?>> rpcClients = new HashMap();
    private final Map<TransferMode, RpcServer> rpcServers = new HashMap<TransferMode, RpcServer>();
    protected HomematicConfig config;
    protected HttpClient httpClient;
    private final String id;
    private final HomematicGatewayAdapter gatewayAdapter;
    private final DelayedExecuter sendDelayedExecutor = new DelayedExecuter();
    private final DelayedExecuter receiveDelayedExecutor = new DelayedExecuter();
    private final Set<HmDatapointInfo> echoEvents = Collections.synchronizedSet(new HashSet());
    private ScheduledFuture<?> connectionTrackerFuture;
    private ConnectionTrackerThread connectionTrackerThread;
    private final Map<String, HmDevice> devices = Collections.synchronizedMap(new HashMap());
    private final Map<HmInterface, TransferMode> availableInterfaces = new TreeMap<HmInterface, TransferMode>();
    private static List<VirtualDatapointHandler> virtualDatapointHandlers = new ArrayList<VirtualDatapointHandler>();
    private boolean cancelLoadAllMetadata;
    private boolean initialized;
    private boolean newDeviceEventsEnabled;
    private ScheduledFuture<?> enableNewDeviceFuture;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"homematicGateway");

    static {
        virtualDatapointHandlers.add(new BatteryTypeVirtualDatapointHandler());
        virtualDatapointHandlers.add(new FirmwareVirtualDatapointHandler());
        virtualDatapointHandlers.add(new DisplayOptionsVirtualDatapointHandler());
        virtualDatapointHandlers.add(new ReloadFromGatewayVirtualDatapointHandler());
        virtualDatapointHandlers.add(new ReloadAllFromGatewayVirtualDatapointHandler());
        virtualDatapointHandlers.add(new OnTimeAutomaticVirtualDatapointHandler());
        virtualDatapointHandlers.add(new InstallModeVirtualDatapoint());
        virtualDatapointHandlers.add(new InstallModeDurationVirtualDatapoint());
        virtualDatapointHandlers.add(new DeleteDeviceModeVirtualDatapointHandler());
        virtualDatapointHandlers.add(new DeleteDeviceVirtualDatapointHandler());
        virtualDatapointHandlers.add(new RssiVirtualDatapointHandler());
        virtualDatapointHandlers.add(new ReloadRssiVirtualDatapointHandler());
        virtualDatapointHandlers.add(new StateContactVirtualDatapointHandler());
        virtualDatapointHandlers.add(new SignalStrengthVirtualDatapointHandler());
        virtualDatapointHandlers.add(new DisplayTextVirtualDatapoint());
        virtualDatapointHandlers.add(new HmwIoModuleVirtualDatapointHandler());
        virtualDatapointHandlers.add(new ButtonVirtualDatapointHandler());
    }

    public AbstractHomematicGateway(String id, HomematicConfig config, HomematicGatewayAdapter gatewayAdapter, HttpClient httpClient) {
        this.id = id;
        this.config = config;
        this.gatewayAdapter = gatewayAdapter;
        this.httpClient = httpClient;
    }

    @Override
    public void initialize() throws IOException {
        this.logger.debug("Initializing gateway with id '{}'", (Object)this.id);
        HmGatewayInfo gatewayInfo = this.config.getGatewayInfo();
        if (gatewayInfo.isHomegear()) {
            this.availableInterfaces.put(HmInterface.RF, TransferMode.BIN_RPC);
        } else if (gatewayInfo.isCCU()) {
            if (gatewayInfo.isRfInterface()) {
                this.availableInterfaces.put(HmInterface.RF, TransferMode.XML_RPC);
            }
            if (gatewayInfo.isWiredInterface()) {
                this.availableInterfaces.put(HmInterface.WIRED, TransferMode.XML_RPC);
            }
            if (gatewayInfo.isHmipInterface()) {
                this.availableInterfaces.put(HmInterface.HMIP, TransferMode.XML_RPC);
            }
            if (gatewayInfo.isCuxdInterface()) {
                this.availableInterfaces.put(HmInterface.CUXD, TransferMode.BIN_RPC);
            }
            if (gatewayInfo.isGroupInterface()) {
                this.availableInterfaces.put(HmInterface.GROUP, TransferMode.XML_RPC);
            }
        } else {
            if (gatewayInfo.isRfInterface()) {
                this.availableInterfaces.put(HmInterface.RF, TransferMode.XML_RPC);
            }
            if (gatewayInfo.isWiredInterface()) {
                this.availableInterfaces.put(HmInterface.WIRED, TransferMode.XML_RPC);
            }
            if (gatewayInfo.isHmipInterface()) {
                this.availableInterfaces.put(HmInterface.HMIP, TransferMode.XML_RPC);
            }
        }
        this.logger.info("{}", (Object)this.config.getGatewayInfo());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<HmInterface, TransferMode> entry : this.availableInterfaces.entrySet()) {
            sb.append((Object)entry.getKey()).append(":").append((Object)entry.getValue()).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        this.logger.debug("Used Homematic transfer modes: {}", (Object)sb.toString());
        this.startClients();
        this.startServers();
        if (!this.config.getGatewayInfo().isHomegear()) {
            long delay = this.config.getGatewayInfo().isCCU1() ? 10 : 3;
            this.enableNewDeviceFuture = this.scheduler.schedule(() -> {
                this.newDeviceEventsEnabled = true;
            }, delay, TimeUnit.MINUTES);
        } else {
            this.newDeviceEventsEnabled = true;
        }
    }

    @Override
    public void dispose() {
        this.initialized = false;
        if (this.enableNewDeviceFuture != null) {
            this.enableNewDeviceFuture.cancel(true);
        }
        this.newDeviceEventsEnabled = false;
        this.stopWatchdogs();
        this.sendDelayedExecutor.stop();
        this.receiveDelayedExecutor.stop();
        this.stopServers();
        this.stopClients();
        this.devices.clear();
        this.echoEvents.clear();
        this.availableInterfaces.clear();
        this.config.setGatewayInfo(null);
    }

    protected synchronized void startClients() throws IOException {
        for (TransferMode mode : this.availableInterfaces.values()) {
            if (this.rpcClients.containsKey((Object)mode)) continue;
            this.rpcClients.put(mode, mode == TransferMode.XML_RPC ? new XmlRpcClient(this.config, this.httpClient) : new BinRpcClient(this.config));
        }
    }

    protected synchronized void stopClients() {
        for (RpcClient<?> rpcClient : this.rpcClients.values()) {
            rpcClient.dispose();
        }
        this.rpcClients.clear();
    }

    private synchronized void startServers() throws IOException {
        for (TransferMode mode : this.availableInterfaces.values()) {
            if (this.rpcServers.containsKey((Object)mode)) continue;
            RpcServer rpcServer = mode == TransferMode.XML_RPC ? new XmlRpcServer(this, this.config) : new BinRpcServer(this, this.config);
            this.rpcServers.put(mode, rpcServer);
            rpcServer.start();
        }
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            this.getRpcClient(hmInterface).init(hmInterface, String.valueOf(hmInterface.toString()) + "-" + this.id);
        }
    }

    private synchronized void stopServers() {
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            try {
                this.getRpcClient(hmInterface).release(hmInterface);
            }
            catch (IOException ex) {
                this.logger.debug("Unable to release the connection to the gateway with id '{}': {}", new Object[]{this.id, ex.getMessage(), ex});
            }
        }
        for (TransferMode mode : this.rpcServers.keySet()) {
            this.rpcServers.get((Object)mode).shutdown();
        }
        this.rpcServers.clear();
    }

    @Override
    public void startWatchdogs() {
        this.logger.debug("Starting connection tracker for gateway with id '{}'", (Object)this.id);
        this.connectionTrackerThread = new ConnectionTrackerThread();
        this.connectionTrackerFuture = this.scheduler.scheduleWithFixedDelay(this.connectionTrackerThread, 30L, 15L, TimeUnit.SECONDS);
    }

    private void stopWatchdogs() {
        if (this.connectionTrackerFuture != null) {
            this.connectionTrackerFuture.cancel(true);
        }
        this.connectionTrackerThread = null;
    }

    protected HmInterface getDefaultInterface() {
        return this.availableInterfaces.containsKey((Object)HmInterface.RF) ? HmInterface.RF : HmInterface.HMIP;
    }

    @Override
    public RpcClient<?> getRpcClient(HmInterface hmInterface) throws IOException {
        RpcClient<?> rpcClient = this.rpcClients.get((Object)this.availableInterfaces.get((Object)hmInterface));
        if (rpcClient == null) {
            throw new IOException("RPC client for interface " + (Object)((Object)hmInterface) + " not available");
        }
        return rpcClient;
    }

    protected abstract void loadVariables(HmChannel var1) throws IOException;

    protected abstract void loadScripts(HmChannel var1) throws IOException;

    protected abstract void loadDeviceNames(Collection<HmDevice> var1) throws IOException;

    protected abstract void setVariable(HmDatapoint var1, Object var2) throws IOException;

    protected abstract void executeScript(HmDatapoint var1) throws IOException;

    @Override
    public HmDatapoint getDatapoint(HmDatapointInfo dpInfo) throws HomematicClientException {
        HmDevice device = this.getDevice(dpInfo.getAddress());
        HmChannel channel = device.getChannel(dpInfo.getChannel());
        if (channel == null) {
            throw new HomematicClientException(String.format("Channel %s in device '%s' not found on gateway '%s'", dpInfo.getChannel(), dpInfo.getAddress(), this.id));
        }
        HmDatapoint dp = channel.getDatapoint(dpInfo);
        if (dp == null) {
            throw new HomematicClientException(String.format("Datapoint '%s' not found on gateway '%s'", dpInfo, this.id));
        }
        return dp;
    }

    @Override
    public HmDevice getDevice(String address) throws HomematicClientException {
        HmDevice device = this.devices.get(address);
        if (device == null) {
            throw new HomematicClientException(String.format("Device with address '%s' not found on gateway '%s'", address, this.id));
        }
        return device;
    }

    @Override
    public void cancelLoadAllDeviceMetadata() {
        this.cancelLoadAllMetadata = true;
    }

    @Override
    public void loadAllDeviceMetadata() throws IOException {
        this.cancelLoadAllMetadata = false;
        List<HmDevice> deviceDescriptions = this.getDeviceDescriptions();
        HashSet<String> loadedDevices = new HashSet<String>();
        HashMap<String, List<HmDatapoint>> datapointsByChannelIdCache = new HashMap<String, List<HmDatapoint>>();
        for (HmDevice device : deviceDescriptions) {
            if (this.cancelLoadAllMetadata) continue;
            try {
                this.logger.trace("Loading metadata for device '{}' of type '{}'", (Object)device.getAddress(), (Object)device.getType());
                if (device.isGatewayExtras()) {
                    this.loadChannelValues(device.getChannel(HmChannel.CHANNEL_NUMBER_VARIABLE));
                    this.loadChannelValues(device.getChannel(HmChannel.CHANNEL_NUMBER_SCRIPT));
                } else {
                    for (HmChannel channel : device.getChannels()) {
                        this.logger.trace("  Loading channel {}", (Object)channel);
                        if (("HM-RCV-50".equals(device.getType()) || "HMW-RCV-50".equals(device.getType())) && channel.getNumber() > 1) {
                            HmChannel previousChannel = device.getChannel(channel.getNumber() - 1);
                            this.cloneAllDatapointsIntoChannel(channel, previousChannel.getDatapoints());
                            continue;
                        }
                        String channelId = String.format("%s:%s:%s", channel.getDevice().getType(), channel.getDevice().getFirmware(), channel.getNumber());
                        Collection cachedDatapoints = (Collection)datapointsByChannelIdCache.get(channelId);
                        if (cachedDatapoints != null) {
                            this.cloneAllDatapointsIntoChannel(channel, cachedDatapoints);
                            continue;
                        }
                        this.logger.trace("    Loading datapoints into channel {}", (Object)channel);
                        this.addChannelDatapoints(channel, HmParamsetType.MASTER);
                        this.addChannelDatapoints(channel, HmParamsetType.VALUES);
                        if (channel.isReconfigurable()) continue;
                        datapointsByChannelIdCache.put(channelId, channel.getDatapoints());
                    }
                }
                this.prepareDevice(device);
                loadedDevices.add(device.getAddress());
                this.gatewayAdapter.onDeviceLoaded(device);
            }
            catch (IOException ex) {
                this.logger.warn("Can't load device with address '{}' from gateway '{}': {}", new Object[]{device.getAddress(), this.id, ex.getMessage()});
            }
        }
        if (!this.cancelLoadAllMetadata) {
            this.devices.keySet().retainAll(loadedDevices);
        }
        this.initialized = true;
    }

    protected void addChannelDatapoints(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        try {
            this.getRpcClient(channel.getDevice().getHmInterface()).addChannelDatapoints(channel, paramsetType);
        }
        catch (UnknownParameterSetException unknownParameterSetException) {
            this.logger.info("Can not load metadata for device: {}, channel: {}, paramset: {}, maybe there are no channels available", new Object[]{channel.getDevice().getAddress(), channel.getNumber(), paramsetType});
        }
    }

    private List<HmDevice> getDeviceDescriptions() throws IOException {
        ArrayList<HmDevice> deviceDescriptions = new ArrayList<HmDevice>();
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            deviceDescriptions.addAll(this.getRpcClient(hmInterface).listDevices(hmInterface));
        }
        if (!this.cancelLoadAllMetadata) {
            deviceDescriptions.add(this.createGatewayDevice());
            this.loadDeviceNames(deviceDescriptions);
        }
        return deviceDescriptions;
    }

    private void cloneAllDatapointsIntoChannel(HmChannel channel, Collection<HmDatapoint> datapoints) {
        this.logger.trace("    Cloning {} datapoints into channel {}", (Object)datapoints.size(), (Object)channel);
        for (HmDatapoint dp : datapoints) {
            if (dp.isVirtual()) continue;
            HmDatapoint clonedDp = dp.clone();
            clonedDp.setValue(null);
            channel.addDatapoint(clonedDp);
        }
    }

    @Override
    public void loadChannelValues(HmChannel channel) throws IOException {
        if (channel.getDevice().isGatewayExtras()) {
            if (channel.getNumber() != HmChannel.CHANNEL_NUMBER_EXTRAS) {
                List<HmDatapoint> datapoints = channel.getDatapoints();
                if (channel.getNumber() == HmChannel.CHANNEL_NUMBER_VARIABLE) {
                    this.loadVariables(channel);
                    this.logger.debug("Loaded {} gateway variable(s)", (Object)datapoints.size());
                } else if (channel.getNumber() == HmChannel.CHANNEL_NUMBER_SCRIPT) {
                    this.loadScripts(channel);
                    this.logger.debug("Loaded {} gateway script(s)", (Object)datapoints.size());
                }
            }
        } else {
            this.logger.debug("Loading values for channel {} of device '{}'", (Object)channel, (Object)channel.getDevice().getAddress());
            this.setChannelDatapointValues(channel, HmParamsetType.MASTER);
            this.setChannelDatapointValues(channel, HmParamsetType.VALUES);
        }
        for (HmDatapoint dp : channel.getDatapoints()) {
            this.handleVirtualDatapointEvent(dp, false);
        }
        channel.setInitialized(true);
    }

    @Override
    public void updateChannelValueDatapoints(HmChannel channel) throws IOException {
        this.logger.debug("Updating value datapoints for channel {} of device '{}', has {} datapoints before", new Object[]{channel, channel.getDevice().getAddress(), channel.getDatapoints().size()});
        channel.removeValueDatapoints();
        this.addChannelDatapoints(channel, HmParamsetType.VALUES);
        this.setChannelDatapointValues(channel, HmParamsetType.VALUES);
        this.logger.debug("Updated value datapoints for channel {} of device '{}' (function {}), now has {} datapoints", new Object[]{channel, channel.getDevice().getAddress(), channel.getCurrentFunction(), channel.getDatapoints().size()});
    }

    protected void setChannelDatapointValues(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        try {
            this.getRpcClient(channel.getDevice().getHmInterface()).setChannelDatapointValues(channel, paramsetType);
        }
        catch (UnknownParameterSetException unknownParameterSetException) {
            this.logger.info("Can not load values for device: {}, channel: {}, paramset: {}, maybe there are no values available", new Object[]{channel.getDevice().getAddress(), channel.getNumber(), paramsetType});
        }
    }

    @Override
    public void loadDatapointValue(HmDatapoint dp) throws IOException {
        this.getRpcClient(dp.getChannel().getDevice().getHmInterface()).getDatapointValue(dp);
    }

    @Override
    public void loadRssiValues() throws IOException {
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            if (hmInterface != HmInterface.RF && hmInterface != HmInterface.CUXD) continue;
            List<HmRssiInfo> rssiInfos = this.getRpcClient(hmInterface).loadRssiInfo(hmInterface);
            for (HmRssiInfo hmRssiInfo : rssiInfos) {
                this.updateRssiInfo(hmRssiInfo.getAddress(), "RSSI_DEVICE", hmRssiInfo.getDevice());
                this.updateRssiInfo(hmRssiInfo.getAddress(), "RSSI_PEER", hmRssiInfo.getPeer());
            }
        }
    }

    @Override
    public void setInstallMode(boolean enable, int seconds) throws IOException {
        HmDevice gwExtrasHm = this.devices.get("GWE00000000");
        if (gwExtrasHm != null) {
            VirtualDatapointHandler handler;
            HmDatapoint installModeDataPoint = null;
            HmDatapoint installModeDurationDataPoint = null;
            HmChannel hmChannel = gwExtrasHm.getChannel(HmChannel.CHANNEL_NUMBER_EXTRAS);
            HmDatapointInfo installModeDurationDataPointInfo = new HmDatapointInfo(HmParamsetType.VALUES, hmChannel, "INSTALL_MODE_DURATION");
            if (enable) {
                installModeDurationDataPoint = hmChannel.getDatapoint(installModeDurationDataPointInfo);
            }
            HmDatapointInfo installModeDataPointInfo = new HmDatapointInfo(HmParamsetType.VALUES, hmChannel, "INSTALL_MODE");
            installModeDataPoint = hmChannel.getDatapoint(installModeDataPointInfo);
            if (installModeDurationDataPoint != null) {
                try {
                    handler = this.getVirtualDatapointHandler(installModeDurationDataPoint, null);
                    handler.handleCommand(this, installModeDurationDataPoint, new HmDatapointConfig(), seconds);
                    this.gatewayAdapter.onStateUpdated(installModeDurationDataPoint);
                }
                catch (HomematicClientException ex) {
                    this.logger.warn("Failed to send datapoint {}", (Object)installModeDurationDataPoint, (Object)ex);
                }
            }
            if (installModeDataPoint != null) {
                try {
                    handler = this.getVirtualDatapointHandler(installModeDataPoint, null);
                    handler.handleCommand(this, installModeDataPoint, new HmDatapointConfig(), enable);
                    this.gatewayAdapter.onStateUpdated(installModeDataPoint);
                    return;
                }
                catch (HomematicClientException ex) {
                    this.logger.warn("Failed to send datapoint {}", (Object)installModeDataPoint, (Object)ex);
                }
            }
        }
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            if (hmInterface != HmInterface.RF && hmInterface != HmInterface.CUXD) continue;
            this.getRpcClient(hmInterface).setInstallMode(hmInterface, enable, seconds);
        }
    }

    @Override
    public int getInstallMode() throws IOException {
        for (HmInterface hmInterface : this.availableInterfaces.keySet()) {
            if (hmInterface != HmInterface.RF && hmInterface != HmInterface.CUXD) continue;
            return this.getRpcClient(hmInterface).getInstallMode(hmInterface);
        }
        throw new IllegalStateException("Could not determine install mode because no suitable interface exists");
    }

    private void updateRssiInfo(String address, String datapointName, Integer value) {
        HmDatapointInfo dpInfo = new HmDatapointInfo(address, HmParamsetType.VALUES, 0, datapointName);
        try {
            HmChannel channel = this.getDevice(dpInfo.getAddress()).getChannel(0);
            if (channel != null) {
                this.eventReceived(dpInfo, value);
            }
        }
        catch (HomematicClientException homematicClientException) {}
    }

    @Override
    public void triggerDeviceValuesReload(HmDevice device) {
        this.logger.debug("Triggering values reload for device '{}'", (Object)device.getAddress());
        for (HmChannel channel : device.getChannels()) {
            channel.setInitialized(false);
        }
        this.gatewayAdapter.reloadDeviceValues(device);
    }

    @Override
    public void sendDatapointIgnoreVirtual(HmDatapoint dp, HmDatapointConfig dpConfig, Object newValue) throws IOException, HomematicClientException {
        this.sendDatapoint(dp, dpConfig, newValue, null, true);
    }

    @Override
    public void sendDatapoint(HmDatapoint dp, HmDatapointConfig dpConfig, Object newValue, String rxMode) throws IOException, HomematicClientException {
        this.sendDatapoint(dp, dpConfig, newValue, rxMode, false);
    }

    private void sendDatapoint(final HmDatapoint dp, final HmDatapointConfig dpConfig, final Object newValue, final String rxMode, final boolean ignoreVirtualDatapoints) throws IOException, HomematicClientException {
        final HmDatapointInfo dpInfo = new HmDatapointInfo(dp);
        if (dp.isPressDatapoint() || this.config.getGatewayInfo().isHomegear() && dp.isVariable()) {
            this.echoEvents.add(dpInfo);
        }
        if (dp.isReadOnly()) {
            this.logger.warn("Datapoint is readOnly, it is not published to the gateway with id '{}': '{}'", (Object)this.id, (Object)dpInfo);
        } else if (HmValueType.ACTION == dp.getType() && MiscUtils.isFalseValue(newValue)) {
            this.logger.warn("Datapoint of type ACTION cannot be set to false, it is not published to the gateway with id '{}': '{}'", (Object)this.id, (Object)dpInfo);
        } else {
            final AbstractHomematicGateway gateway = this;
            this.sendDelayedExecutor.start(dpInfo, dpConfig.getDelay(), new DelayedExecuter.DelayedExecuterCallback(){

                @Override
                public void execute() throws IOException, HomematicClientException {
                    VirtualDatapointHandler virtualDatapointHandler;
                    VirtualDatapointHandler virtualDatapointHandler2 = virtualDatapointHandler = ignoreVirtualDatapoints ? null : AbstractHomematicGateway.this.getVirtualDatapointHandler(dp, newValue);
                    if (virtualDatapointHandler != null) {
                        AbstractHomematicGateway.this.logger.debug("Handling virtual datapoint '{}' on gateway with id '{}'", (Object)dp.getName(), (Object)AbstractHomematicGateway.this.id);
                        virtualDatapointHandler.handleCommand(gateway, dp, dpConfig, newValue);
                    } else if (dp.isScript()) {
                        if (MiscUtils.isTrueValue(newValue)) {
                            AbstractHomematicGateway.this.logger.debug("Executing script '{}' on gateway with id '{}'", (Object)dp.getInfo(), (Object)AbstractHomematicGateway.this.id);
                            AbstractHomematicGateway.this.executeScript(dp);
                        }
                    } else if (dp.isVariable()) {
                        AbstractHomematicGateway.this.logger.debug("Sending variable '{}' with value '{}' to gateway with id '{}'", new Object[]{dp.getInfo(), newValue, AbstractHomematicGateway.this.id});
                        AbstractHomematicGateway.this.setVariable(dp, newValue);
                    } else {
                        AbstractHomematicGateway.this.logger.debug("Sending datapoint '{}' with value '{}' to gateway with id '{}' using rxMode '{}'", new Object[]{dpInfo, newValue, AbstractHomematicGateway.this.id, rxMode == null ? "DEFAULT" : rxMode});
                        AbstractHomematicGateway.this.getRpcClient(dp.getChannel().getDevice().getHmInterface()).setDatapointValue(dp, newValue, rxMode);
                    }
                    dp.setValue(newValue);
                    if (MiscUtils.isTrueValue(newValue) && (dp.isPressDatapoint() || dp.isScript() || dp.isActionType())) {
                        AbstractHomematicGateway.this.disableDatapoint(dp, 2.0);
                    }
                }
            });
        }
    }

    private VirtualDatapointHandler getVirtualDatapointHandler(HmDatapoint dp, Object value) {
        for (VirtualDatapointHandler vdph : virtualDatapointHandlers) {
            if (!vdph.canHandleCommand(dp, value)) continue;
            return vdph;
        }
        return null;
    }

    private void handleVirtualDatapointEvent(HmDatapoint dp, boolean publishToGateway) {
        for (VirtualDatapointHandler vdph : virtualDatapointHandlers) {
            if (!vdph.canHandleEvent(dp)) continue;
            vdph.handleEvent(this, dp);
            if (!publishToGateway) continue;
            this.gatewayAdapter.onStateUpdated(vdph.getVirtualDatapoint(dp.getChannel()));
        }
    }

    @Override
    public void eventReceived(HmDatapointInfo dpInfo, Object newValue) {
        String className = newValue == null ? "Unknown" : newValue.getClass().getSimpleName();
        this.logger.debug("Received new ({}) value '{}' for '{}' from gateway with id '{}'", new Object[]{className, newValue, dpInfo, this.id});
        if (this.echoEvents.remove(dpInfo)) {
            this.logger.debug("Echo event detected, ignoring '{}'", (Object)dpInfo);
        } else {
            try {
                if (this.connectionTrackerThread != null && dpInfo.isPong() && this.id.equals(newValue)) {
                    this.connectionTrackerThread.pongReceived();
                }
                if (this.initialized) {
                    HmDatapoint dp = this.getDatapoint(dpInfo);
                    HmDatapointConfig config = this.gatewayAdapter.getDatapointConfig(dp);
                    this.receiveDelayedExecutor.start(dpInfo, config.getReceiveDelay(), () -> {
                        dp.setValue(newValue);
                        this.gatewayAdapter.onStateUpdated(dp);
                        this.handleVirtualDatapointEvent(dp, true);
                        if (dp.isPressDatapoint() && MiscUtils.isTrueValue(dp.getValue())) {
                            this.disableDatapoint(dp, 2.0);
                        }
                    });
                }
            }
            catch (IOException | HomematicClientException exception) {}
        }
    }

    @Override
    public void newDevices(List<String> adresses) {
        if (this.initialized && this.newDeviceEventsEnabled) {
            for (String address : adresses) {
                try {
                    this.logger.debug("New device '{}' detected on gateway with id '{}'", (Object)address, (Object)this.id);
                    List<HmDevice> deviceDescriptions = this.getDeviceDescriptions();
                    for (HmDevice device : deviceDescriptions) {
                        if (!device.getAddress().equals(address)) continue;
                        for (HmChannel channel : device.getChannels()) {
                            this.addChannelDatapoints(channel, HmParamsetType.MASTER);
                            this.addChannelDatapoints(channel, HmParamsetType.VALUES);
                        }
                        this.prepareDevice(device);
                        this.gatewayAdapter.onNewDevice(device);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
    }

    @Override
    public void deleteDevices(List<String> addresses) {
        if (this.initialized) {
            for (String address : addresses) {
                this.logger.debug("Device '{}' removed from gateway with id '{}'", (Object)address, (Object)this.id);
                HmDevice device = this.devices.remove(address);
                if (device == null) continue;
                this.gatewayAdapter.onDeviceDeleted(device);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public HomematicGatewayAdapter getGatewayAdapter() {
        return this.gatewayAdapter;
    }

    private HmDevice createGatewayDevice() {
        String type = String.format("%s-%s", "GATEWAY-EXTRAS", StringUtils.upperCase((String)this.id));
        HmDevice device = new HmDevice("GWE00000000", this.getDefaultInterface(), type, this.config.getGatewayInfo().getId(), null, null);
        device.setName("GATEWAY-EXTRAS");
        device.addChannel(new HmChannel("GATEWAY-EXTRAS", HmChannel.CHANNEL_NUMBER_EXTRAS));
        device.addChannel(new HmChannel("GATEWAY-VARIABLE", HmChannel.CHANNEL_NUMBER_VARIABLE));
        device.addChannel(new HmChannel("GATEWAY-SCRIPT", HmChannel.CHANNEL_NUMBER_SCRIPT));
        return device;
    }

    private void prepareDevice(HmDevice device) {
        for (VirtualDatapointHandler vdph : virtualDatapointHandlers) {
            vdph.initialize(device);
        }
        this.devices.put(device.getAddress(), device);
        this.logger.debug("Loaded device '{}' ({}) with {} datapoints", new Object[]{device.getAddress(), device.getType(), device.getDatapointCount()});
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)device);
            for (HmChannel channel : device.getChannels()) {
                this.logger.trace("  {}", (Object)channel);
                for (HmDatapoint dp : channel.getDatapoints()) {
                    this.logger.trace("    {}", (Object)dp);
                }
            }
        }
    }

    @Override
    public void disableDatapoint(final HmDatapoint dp, double delay) {
        try {
            this.sendDelayedExecutor.start(new HmDatapointInfo(dp), delay, new DelayedExecuter.DelayedExecuterCallback(){

                @Override
                public void execute() throws IOException {
                    if (MiscUtils.isTrueValue(dp.getValue())) {
                        dp.setValue(Boolean.FALSE);
                        AbstractHomematicGateway.this.gatewayAdapter.onStateUpdated(dp);
                        AbstractHomematicGateway.this.handleVirtualDatapointEvent(dp, true);
                    } else if (dp.getType() == HmValueType.ENUM && dp.getValue() != null && !dp.getValue().equals(0)) {
                        dp.setValue(dp.getMinValue());
                        AbstractHomematicGateway.this.gatewayAdapter.onStateUpdated(dp);
                        AbstractHomematicGateway.this.handleVirtualDatapointEvent(dp, true);
                    }
                }
            });
        }
        catch (IOException | HomematicClientException ex) {
            this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Override
    public void deleteDevice(String address, boolean reset, boolean force, boolean defer) {
        for (RpcClient<?> rpcClient : this.rpcClients.values()) {
            try {
                rpcClient.deleteDevice(this.getDevice(address), this.translateFlags(reset, force, defer));
            }
            catch (HomematicClientException e) {
                this.logger.info("Device deletion not possible: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                this.logger.warn("Device deletion failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private int translateFlags(boolean reset, boolean force, boolean defer) {
        int resultFlag = 0;
        if (reset) {
            ++resultFlag;
        }
        if (force) {
            resultFlag += 2;
        }
        if (defer) {
            resultFlag += 4;
        }
        return resultFlag;
    }

    private class ConnectionTrackerThread
    implements Runnable {
        private boolean connectionLost;
        private boolean ping;
        private boolean pong;

        private ConnectionTrackerThread() {
        }

        @Override
        public void run() {
            try {
                if (this.ping && !this.pong) {
                    this.handleInvalidConnection("No Pong received!");
                }
                this.pong = false;
                if (AbstractHomematicGateway.this.config.getGatewayInfo().isCCU1()) {
                    AbstractHomematicGateway.this.getRpcClient(AbstractHomematicGateway.this.getDefaultInterface()).listBidcosInterfaces(AbstractHomematicGateway.this.getDefaultInterface());
                    this.pongReceived();
                } else {
                    AbstractHomematicGateway.this.getRpcClient(AbstractHomematicGateway.this.getDefaultInterface()).ping(AbstractHomematicGateway.this.getDefaultInterface(), AbstractHomematicGateway.this.id);
                }
                this.ping = true;
                try {
                    this.updateDutyCycleRatio();
                }
                catch (IOException e) {
                    AbstractHomematicGateway.this.logger.debug("Could not read the duty cycle ratio: {}", (Object)e.getMessage());
                }
            }
            catch (IOException ex) {
                try {
                    this.handleInvalidConnection("IOException " + ex.getMessage());
                }
                catch (IOException iOException) {}
            }
        }

        public void pongReceived() {
            this.pong = true;
            this.connectionConfirmed();
        }

        private void updateDutyCycleRatio() throws IOException {
            ListBidcosInterfacesParser parser = AbstractHomematicGateway.this.getRpcClient(AbstractHomematicGateway.this.getDefaultInterface()).listBidcosInterfaces(AbstractHomematicGateway.this.getDefaultInterface());
            Integer dutyCycleRatio = parser.getDutyCycleRatio();
            if (dutyCycleRatio != null) {
                AbstractHomematicGateway.this.gatewayAdapter.onDutyCycleRatioUpdate(dutyCycleRatio);
            }
        }

        private void connectionConfirmed() {
            if (this.connectionLost) {
                this.connectionLost = false;
                AbstractHomematicGateway.this.logger.info("Connection resumed on gateway '{}'", (Object)AbstractHomematicGateway.this.id);
                AbstractHomematicGateway.this.gatewayAdapter.onConnectionResumed();
            }
        }

        private void handleInvalidConnection(String cause) throws IOException {
            this.ping = false;
            if (!this.connectionLost) {
                this.connectionLost = true;
                AbstractHomematicGateway.this.logger.warn("Connection lost on gateway '{}', cause: \"{}\"", (Object)AbstractHomematicGateway.this.id, (Object)cause);
                AbstractHomematicGateway.this.gatewayAdapter.onConnectionLost();
            }
            AbstractHomematicGateway.this.stopServers();
            AbstractHomematicGateway.this.stopClients();
            AbstractHomematicGateway.this.startClients();
            AbstractHomematicGateway.this.startServers();
        }
    }
}

