/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.message;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;

public class XmlRpcRequest
implements RpcRequest<String> {
    private String methodName;
    private List<Object> parms;
    private StringBuilder sb;
    private TYPE type;
    public static SimpleDateFormat xmlRpcDateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    public XmlRpcRequest(String methodName) {
        this(methodName, TYPE.REQUEST);
    }

    public XmlRpcRequest(String methodName, TYPE type) {
        this.methodName = methodName;
        this.type = type;
        this.parms = new ArrayList<Object>();
    }

    @Override
    public void addArg(Object parameter) {
        this.parms.add(parameter);
    }

    @Override
    public String createMessage() {
        return this.toString();
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        this.sb = new StringBuilder();
        this.sb.append("<?xml");
        this.attr("version", "1.0");
        this.attr("encoding", "ISO-8859-1");
        this.sb.append("?>\n");
        if (this.type == TYPE.REQUEST) {
            this.sb.append("<methodCall>");
            this.tag("methodName", this.methodName);
        } else {
            this.sb.append("<methodResponse>");
        }
        this.sb.append("\n");
        this.sb.append("<params>");
        for (Object parameter : this.parms) {
            this.sb.append("<param><value>");
            this.generateValue(parameter);
            this.sb.append("</value></param>");
        }
        this.sb.append("</params>");
        if (this.type == TYPE.REQUEST) {
            this.sb.append("</methodCall>");
        } else {
            this.sb.append("</methodResponse>");
        }
        return this.sb.toString();
    }

    private void attr(String name, String value) {
        this.sb.append(" ").append(name).append("=\"").append(value).append("\"");
    }

    private void tag(String name, String value) {
        this.sb.append("<").append(name).append(">").append(value).append("</").append(name).append(">");
    }

    private void generateValue(Object value) {
        if (value == null) {
            this.tag("string", "void");
        } else {
            Class<?> clazz = value.getClass();
            if (clazz == String.class || clazz == Character.class) {
                this.sb.append(StringEscapeUtils.escapeXml((String)value.toString()));
            } else if (clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class) {
                this.tag("int", value.toString());
            } else if (clazz == Double.class) {
                this.tag("double", String.valueOf((Double)value));
            } else if (clazz == Float.class) {
                BigDecimal bd = new BigDecimal(((Float)value).floatValue());
                this.generateValue(bd.setScale(6, RoundingMode.HALF_DOWN).doubleValue());
            } else if (clazz == BigDecimal.class) {
                this.generateValue(((BigDecimal)value).setScale(6, RoundingMode.HALF_DOWN).doubleValue());
            } else if (clazz == Boolean.class) {
                this.tag("boolean", (Boolean)value != false ? "1" : "0");
            } else if (clazz == Date.class) {
                this.tag("dateTime.iso8601", xmlRpcDateFormat.format((Date)value));
            } else if (value instanceof Calendar) {
                this.generateValue(((Calendar)value).getTime());
            } else if (value instanceof byte[]) {
                this.tag("base64", Base64.getEncoder().encodeToString((byte[])value));
            } else if (clazz.isArray() || value instanceof List) {
                this.sb.append("<array><data>");
                Object[] array = null;
                array = value instanceof List ? ((List)value).toArray() : (Object[])value;
                Object[] objectArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arrayObject = objectArray[n2];
                    this.sb.append("<value>");
                    this.generateValue(arrayObject);
                    this.sb.append("</value>");
                    ++n2;
                }
                this.sb.append("</data></array>");
            } else if (value instanceof Map) {
                this.sb.append("<struct>");
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.sb.append("<member>");
                    this.sb.append("<name>").append(entry.getKey()).append("</name>");
                    this.sb.append("<value>");
                    this.generateValue(entry.getValue());
                    this.sb.append("</value>");
                    this.sb.append("</member>");
                }
                this.sb.append("</struct>");
            } else {
                throw new RuntimeException("Unsupported XML-RPC Type: " + value.getClass());
            }
        }
    }

    public static enum TYPE {
        REQUEST,
        RESPONSE;

    }
}

