/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataEntry;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataList;

public class CcuVariablesAndScriptsParser
extends CommonRpcParser<TclScriptDataList, Void> {
    private HmChannel channel;

    public CcuVariablesAndScriptsParser(HmChannel channel) {
        this.channel = channel;
    }

    @Override
    public Void parse(TclScriptDataList resultList) throws IOException {
        if (resultList.getEntries() != null) {
            for (TclScriptDataEntry entry : resultList.getEntries()) {
                HmDatapoint dp = this.channel.getDatapoint(HmParamsetType.VALUES, entry.name);
                if (dp != null) {
                    dp.setValue(this.convertToType(entry.value));
                    continue;
                }
                dp = new HmDatapoint();
                dp.setName(entry.name);
                dp.setInfo(entry.name);
                dp.setDescription(entry.description);
                dp.setType(HmValueType.parse(entry.valueType));
                dp.setValue(this.convertToType(entry.value));
                if (dp.isIntegerType()) {
                    dp.setMinValue(this.toInteger(entry.minValue));
                    dp.setMaxValue(this.toInteger(entry.maxValue));
                } else {
                    dp.setMinValue(this.toDouble(entry.minValue));
                    dp.setMaxValue(this.toDouble(entry.maxValue));
                }
                dp.setReadOnly(entry.readOnly);
                dp.setUnit(entry.unit);
                String[] result = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)entry.options, (String)";");
                dp.setOptions(result == null || result.length == 0 ? null : result);
                if (dp.getOptions() != null) {
                    dp.setMinValue(0);
                    dp.setMaxValue(dp.getOptions().length - 1);
                }
                dp.setParamsetType(HmParamsetType.VALUES);
                this.channel.addDatapoint(dp);
            }
        }
        return null;
    }
}

