/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayOptionsParser
extends CommonRpcParser<Object, Void> {
    private final Logger logger = LoggerFactory.getLogger(DisplayOptionsParser.class);
    private static final String[] onOff = new String[]{"ON", "OFF"};
    private HmChannel channel;
    private String text;
    private int beep = 0;
    private int backlight = 0;
    private int unit = 0;
    private List<String> symbols = new ArrayList<String>();

    public DisplayOptionsParser(HmChannel channel) {
        this.channel = channel;
    }

    @Override
    public Void parse(Object value) throws IOException {
        String optionsString = StringUtils.remove((String)this.toString(value), (char)' ');
        if (optionsString != null) {
            int idxFirstSep = optionsString.indexOf(",");
            if (idxFirstSep == -1) {
                this.text = optionsString;
                optionsString = "";
            } else {
                this.text = optionsString.substring(0, idxFirstSep);
                optionsString = optionsString.substring(idxFirstSep + 1);
            }
            String[] options = StringUtils.split((String)optionsString, (String)",");
            Object[] availableSymbols = this.getAvailableSymbols(this.channel);
            String[] availableBeepOptions = this.getAvailableOptions(this.channel, "BEEP");
            String[] availableBacklightOptions = this.getAvailableOptions(this.channel, "BACKLIGHT");
            String[] availableUnitOptions = this.getAvailableOptions(this.channel, "UNIT");
            String deviceAddress = this.channel.getDevice().getAddress();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Remote control '{}' supports these beep options: {}", (Object)deviceAddress, (Object)availableBeepOptions);
                this.logger.debug("Remote control '{}' supports these backlight options: {}", (Object)deviceAddress, (Object)availableBacklightOptions);
                this.logger.debug("Remote control '{}' supports these unit options: {}", (Object)deviceAddress, (Object)availableUnitOptions);
                this.logger.debug("Remote control '{}' supports these symbols: {}", (Object)deviceAddress, this.symbols);
            }
            if (options != null) {
                String[] stringArray = options;
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameter = stringArray[n2];
                    this.logger.debug("Parsing remote control option '{}'", (Object)parameter);
                    this.beep = this.getIntParameter(availableBeepOptions, this.beep, parameter, "BEEP", deviceAddress);
                    this.backlight = this.getIntParameter(availableBacklightOptions, this.backlight, parameter, "BACKLIGHT", deviceAddress);
                    this.unit = this.getIntParameter(availableUnitOptions, this.unit, parameter, "UNIT", deviceAddress);
                    if (ArrayUtils.contains((Object[])availableSymbols, (Object)parameter)) {
                        this.logger.debug("Symbol '{}' found for remote control '{}'", (Object)parameter, (Object)deviceAddress);
                        this.symbols.add(parameter);
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private int getIntParameter(String[] options, int currentValue, String parameter, String parameterName, String deviceAddress) {
        int idx = ArrayUtils.indexOf((Object[])options, (Object)parameter);
        if (idx != -1) {
            if (currentValue == 0) {
                this.logger.debug("{} option '{}' found at index {} for remote control '{}'", new Object[]{parameterName, parameter, idx + 1, deviceAddress});
                return idx + 1;
            }
            this.logger.warn("{} option already set for remote control '{}', ignoring '{}'!", new Object[]{parameterName, deviceAddress, parameter});
            return currentValue;
        }
        return currentValue;
    }

    private String[] getAvailableOptions(HmChannel channel, String datapointName) {
        HmDatapointInfo dpInfo = HmDatapointInfo.createValuesInfo(channel, datapointName);
        HmDatapoint dp = channel.getDatapoint(dpInfo);
        if (dp != null) {
            Object[] options = (String[])ArrayUtils.remove((Object[])dp.getOptions(), (int)0);
            String[] stringArray = onOff;
            int n = onOff.length;
            int n2 = 0;
            while (n2 < n) {
                String onOffString = stringArray[n2];
                int onIdx = ArrayUtils.indexOf((Object[])options, (Object)onOffString);
                if (onIdx != -1) {
                    options[onIdx] = String.valueOf(datapointName) + "_" + onOffString;
                }
                ++n2;
            }
            return options;
        }
        return new String[0];
    }

    private String[] getAvailableSymbols(HmChannel channel) {
        ArrayList<String> symbols = new ArrayList<String>();
        for (HmDatapoint datapoint : channel.getDatapoints()) {
            if (datapoint.isReadOnly() || !datapoint.isBooleanType() || datapoint.getParamsetType() != HmParamsetType.VALUES || "SUBMIT".equals(datapoint.getName()) || "INSTALL_TEST".equals(datapoint.getName())) continue;
            symbols.add(datapoint.getName());
        }
        return symbols.toArray(new String[0]);
    }

    public String getText() {
        return this.text;
    }

    public int getBeep() {
        return this.beep;
    }

    public int getBacklight() {
        return this.backlight;
    }

    public int getUnit() {
        return this.unit;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }
}

