/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;

public class HomegearLoadDeviceNamesParser
extends CommonRpcParser<Object[], Void> {
    private Collection<HmDevice> devices;

    public HomegearLoadDeviceNamesParser(Collection<HmDevice> devices) {
        this.devices = devices;
    }

    @Override
    public Void parse(Object[] message) throws IOException {
        HashMap<String, HmDevice> devicesById = new HashMap<String, HmDevice>();
        for (HmDevice device : this.devices) {
            devicesById.put(device.getHomegearId(), device);
        }
        message = (Object[])message[0];
        int i = 0;
        while (i < message.length) {
            Map data = (Map)message[i];
            String id = this.toString(data.get("ID"));
            String name = this.toString(data.get("NAME"));
            HmDevice device = (HmDevice)devicesById.get(this.getSanitizedAddress(id));
            if (device != null) {
                device.setName(name);
            }
            ++i;
        }
        return null;
    }
}

