/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmRssiInfo;

public class RssiInfoParser
extends CommonRpcParser<Object[], List<HmRssiInfo>> {
    private HomematicConfig config;

    public RssiInfoParser(HomematicConfig config) {
        this.config = config;
    }

    @Override
    public List<HmRssiInfo> parse(Object[] result) throws IOException {
        ArrayList<HmRssiInfo> rssiList = new ArrayList<HmRssiInfo>();
        if (result != null && result.length > 0 && result[0] instanceof Map) {
            Map devices = (Map)result[0];
            for (String sourceDevice : devices.keySet()) {
                Map targetDevices = (Map)devices.get(sourceDevice);
                if (targetDevices == null) continue;
                for (String targetDevice : targetDevices.keySet()) {
                    if (!targetDevice.equals(this.config.getGatewayInfo().getAddress())) continue;
                    Integer rssiDevice = this.getAdjustedRssiValue((Integer)((Object[])targetDevices.get(targetDevice))[0]);
                    Integer rssiPeer = this.getAdjustedRssiValue((Integer)((Object[])targetDevices.get(targetDevice))[1]);
                    HmRssiInfo rssiInfo = new HmRssiInfo(sourceDevice, rssiDevice, rssiPeer);
                    rssiList.add(rssiInfo);
                }
            }
        }
        return rssiList;
    }
}

